/*
 * Copyright 2020 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.app.appsearch;

import java.util.concurrent.Executor;

/**
 * Encapsulates results of a search operation.
 *
 * <p>Each {@link android.app.appsearch.AppSearchSession#search AppSearchSession.search} operation returns a list of {@link android.app.appsearch.SearchResult SearchResult} objects,
 * referred to as a "page", limited by the size configured by {@link android.app.appsearch.SearchSpec.Builder#setResultCountPerPage  }.
 *
 * <p>To fetch a page of results, call {@link #getNextPage}.
 *
 * <p>All instances of {@link android.app.appsearch.SearchResults SearchResults} must call {@link android.app.appsearch.SearchResults#close() SearchResults.close()} after the
 * results are fetched.
 *
 * <p>This class is not thread safe.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public class SearchResults implements java.io.Closeable {

SearchResults() { throw new RuntimeException("Stub!"); }

public void close() { throw new RuntimeException("Stub!"); }

/**
 * Retrieves the next page of {@link android.app.appsearch.SearchResult SearchResult} objects.
 *
 * <p>The page size is configured by {@link android.app.appsearch.SearchSpec.Builder#setResultCountPerPage SearchSpec.Builder.setResultCountPerPage}.
 *
 * <p>Continue calling this method to access results until it returns an empty list, signifying
 * there are no more results.
 *
 * @param executor Executor on which to invoke the callback.
 * This value cannot be {@code null}.
 * Callback and listener events are dispatched through this
 * {@link java.util.concurrent.Executor Executor}, providing an easy way to control which thread is
 * used. To dispatch events through the main thread of your
 * application, you can use
 * {@link android.content.Context#getMainExecutor() Context.getMainExecutor()}.
 * Otherwise, provide an {@link java.util.concurrent.Executor Executor} that dispatches to an appropriate thread.
 * @param callback Callback to receive the pending result of performing this operation.

 * This value cannot be {@code null}.
 */

public void getNextPage(@android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull java.util.function.Consumer<android.app.appsearch.AppSearchResult<java.util.List<android.app.appsearch.SearchResult>>> callback) { throw new RuntimeException("Stub!"); }
}

