/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.app.appsearch;

import java.util.Map;

/**
 * This class represents the specification logic for AppSearch. It can be used to set the filter and
 * settings of search a suggestions.
 *
 * @see android.app.appsearch.AppSearchSession#searchSuggestion
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class SearchSuggestionSpec implements android.os.Parcelable {

SearchSuggestionSpec() { throw new RuntimeException("Stub!"); }

/** @hide */

public final int describeContents() { throw new RuntimeException("Stub!"); }

/**
 * Returns the map of namespace and target document ids to search over.
 *
 * <p>The keys of the returned map are namespaces, and the values are the target document ids in
 * that namespace to search over.
 *
 * <p>If {@link android.app.appsearch.SearchSuggestionSpec.Builder#addFilterDocumentIds Builder.addFilterDocumentIds} was never called, returns an empty map. In this
 * case AppSearch will search over all namespace and document ids.
 *
 * <p>Calling this function repeatedly is inefficient. Prefer to retain the Map returned by this
 * function, rather than calling it multiple times.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.util.Map<java.lang.String,java.util.List<java.lang.String>> getFilterDocumentIds() { throw new RuntimeException("Stub!"); }

/**
 * Returns the list of namespaces to search over.
 *
 * <p>If empty, will search over all namespaces.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.util.List<java.lang.String> getFilterNamespaces() { throw new RuntimeException("Stub!"); }

/**
 * Returns the map of schema and target properties to search over.
 *
 * <p>The keys of the returned map are schema types, and the values are the target property path
 * in that schema to search over.
 *
 * <p>If {@link android.app.appsearch.SearchSuggestionSpec.Builder#addFilterPropertyPaths Builder.addFilterPropertyPaths} was never called, returns an empty map. In this
 * case AppSearch will search over all schemas and properties.
 *
 * <p>Calling this function repeatedly is inefficient. Prefer to retain the Map returned by this
 * function, rather than calling it multiple times.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.util.Map<java.lang.String,java.util.List<java.lang.String>> getFilterProperties() { throw new RuntimeException("Stub!"); }

/**
 * Returns the list of schema to search the suggestion over.
 *
 * <p>If empty, will search over all schemas.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.util.List<java.lang.String> getFilterSchemas() { throw new RuntimeException("Stub!"); }

/**
 * Returns the maximum number of wanted suggestion that will be returned in the result object.
 */

public int getMaximumResultCount() { throw new RuntimeException("Stub!"); }

/**
 * Returns the ranking strategy.
 * @return Value is {@link android.app.appsearch.SearchSuggestionSpec#SUGGESTION_RANKING_STRATEGY_NONE}, {@link android.app.appsearch.SearchSuggestionSpec#SUGGESTION_RANKING_STRATEGY_DOCUMENT_COUNT}, or {@link android.app.appsearch.SearchSuggestionSpec#SUGGESTION_RANKING_STRATEGY_TERM_FREQUENCY}
 */

public int getRankingStrategy() { throw new RuntimeException("Stub!"); }

/**
 * Returns the list of String parameters that can be referenced in the query through the
 * "getSearchStringParameter({index})" function.
 *
 * @see android.app.appsearch.AppSearchSession#search

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.util.List<java.lang.String> getSearchStringParameters() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param dest This value cannot be {@code null}.
 */

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.app.appsearch.SearchSuggestionSpec> CREATOR;
static { CREATOR = null; }

/**
 * Ranked by the document count that contains the term.
 *
 * <p>Suppose the following document is in the index.
 *
 * <pre>Doc1 contains: term1 term2 term2 term2</pre>
 *
 * <pre>Doc2 contains: term1</pre>
 *
 * <p>Then, suppose that a search suggestion for "t" is issued with the DOCUMENT_COUNT, the
 * returned {@link android.app.appsearch.SearchSuggestionResult SearchSuggestionResult}s will be: term1, term2. The term1 will have higher
 * score and appear in the results first.
 */

public static final int SUGGESTION_RANKING_STRATEGY_DOCUMENT_COUNT = 0; // 0x0

/** No Ranking, results are returned in arbitrary order. */

public static final int SUGGESTION_RANKING_STRATEGY_NONE = 2; // 0x2

/**
 * Ranked by the term appear frequency.
 *
 * <p>Suppose the following document is in the index.
 *
 * <pre>Doc1 contains: term1 term2 term2 term2</pre>
 *
 * <pre>Doc2 contains: term1</pre>
 *
 * <p>Then, suppose that a search suggestion for "t" is issued with the TERM_FREQUENCY, the
 * returned {@link android.app.appsearch.SearchSuggestionResult SearchSuggestionResult}s will be: term2, term1. The term2 will have higher
 * score and appear in the results first.
 */

public static final int SUGGESTION_RANKING_STRATEGY_TERM_FREQUENCY = 1; // 0x1
/** Builder for {@link android.app.appsearch.SearchSuggestionSpec objects}. */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

/**
 * Creates an {@link android.app.appsearch.SearchSuggestionSpec.Builder SearchSuggestionSpec.Builder} object.
 *
 * @param maximumResultCount Sets the maximum number of suggestion in the returned object.

 * Value is 1 or greater
 */

public Builder(int maximumResultCount) { throw new RuntimeException("Stub!"); }

/**
 * Adds a document ID filter to {@link android.app.appsearch.SearchSuggestionSpec SearchSuggestionSpec} Entry. Only search for
 * suggestions in the given specified documents.
 *
 * <p>If unset, the query will search over all documents.
 
 * @param namespace This value cannot be {@code null}.
 * @param documentIds This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.SearchSuggestionSpec.Builder addFilterDocumentIds(@android.annotation.NonNull java.lang.String namespace, @android.annotation.NonNull java.lang.String... documentIds) { throw new RuntimeException("Stub!"); }

/**
 * Adds a document ID filter to {@link android.app.appsearch.SearchSuggestionSpec SearchSuggestionSpec} Entry. Only search for
 * suggestions in the given specified documents.
 *
 * <p>If unset, the query will search over all documents.
 
 * @param namespace This value cannot be {@code null}.
 * @param documentIds This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.SearchSuggestionSpec.Builder addFilterDocumentIds(@android.annotation.NonNull java.lang.String namespace, @android.annotation.NonNull java.util.Collection<java.lang.String> documentIds) { throw new RuntimeException("Stub!"); }

/**
 * Adds a namespace filter to {@link android.app.appsearch.SearchSuggestionSpec SearchSuggestionSpec} Entry. Only search for
 * suggestions that has documents under the specified namespaces.
 *
 * <p>If unset, the query will search over all namespaces.
 
 * @param namespaces This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.SearchSuggestionSpec.Builder addFilterNamespaces(@android.annotation.NonNull java.lang.String... namespaces) { throw new RuntimeException("Stub!"); }

/**
 * Adds a namespace filter to {@link android.app.appsearch.SearchSuggestionSpec SearchSuggestionSpec} Entry. Only search for
 * suggestions that has documents under the specified namespaces.
 *
 * <p>If unset, the query will search over all namespaces.
 
 * @param namespaces This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.SearchSuggestionSpec.Builder addFilterNamespaces(@android.annotation.NonNull java.util.Collection<java.lang.String> namespaces) { throw new RuntimeException("Stub!"); }

/**
 * Adds property paths for the specified type to the property filter of {@link android.app.appsearch.SearchSuggestionSpec SearchSuggestionSpec} Entry. Only search for suggestions that has content under the
 * specified property. If property paths are added for a type, then only the properties
 * referred to will be retrieved for results of that type.
 *
 * <p>If a property path that is specified isn't present in a result, it will be ignored for
 * that result. Property paths cannot be null.
 *
 * <p>If no property paths are added for a particular type, then all properties of results
 * of that type will be retrieved.
 *
 * <p>Example properties: 'body', 'sender.name', 'sender.emailaddress', etc.
 *
 * @param schema the {@link android.app.appsearch.AppSearchSchema AppSearchSchema} that contains the target properties
 * This value cannot be {@code null}.
 * @param propertyPaths The String version of {@link android.app.appsearch.PropertyPath PropertyPath}. A dot-delimited sequence
 *     of property names indicating which property in the document these snippets correspond
 *     to.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.SearchSuggestionSpec.Builder addFilterProperties(@android.annotation.NonNull java.lang.String schema, @android.annotation.NonNull java.util.Collection<java.lang.String> propertyPaths) { throw new RuntimeException("Stub!"); }

/**
 * Adds property paths for the specified type to the property filter of {@link android.app.appsearch.SearchSuggestionSpec SearchSuggestionSpec} Entry. Only search for suggestions that has content under the
 * specified property. If property paths are added for a type, then only the properties
 * referred to will be retrieved for results of that type.
 *
 * <p>If a property path that is specified isn't present in a result, it will be ignored for
 * that result. Property paths cannot be null.
 *
 * <p>If no property paths are added for a particular type, then all properties of results
 * of that type will be retrieved.
 *
 * @param schema the {@link android.app.appsearch.AppSearchSchema AppSearchSchema} that contains the target properties
 * This value cannot be {@code null}.
 * @param propertyPaths The {@link android.app.appsearch.PropertyPath PropertyPath} to search suggestion over

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.SearchSuggestionSpec.Builder addFilterPropertyPaths(@android.annotation.NonNull java.lang.String schema, @android.annotation.NonNull java.util.Collection<android.app.appsearch.PropertyPath> propertyPaths) { throw new RuntimeException("Stub!"); }

/**
 * Adds a schema filter to {@link android.app.appsearch.SearchSuggestionSpec SearchSuggestionSpec} Entry. Only search for suggestions
 * that has documents under the specified schema.
 *
 * <p>If unset, the query will search over all schema.
 
 * @param schemaTypes This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.SearchSuggestionSpec.Builder addFilterSchemas(@android.annotation.NonNull java.lang.String... schemaTypes) { throw new RuntimeException("Stub!"); }

/**
 * Adds a schema filter to {@link android.app.appsearch.SearchSuggestionSpec SearchSuggestionSpec} Entry. Only search for suggestions
 * that has documents under the specified schema.
 *
 * <p>If unset, the query will search over all schema.
 
 * @param schemaTypes This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.SearchSuggestionSpec.Builder addFilterSchemas(@android.annotation.NonNull java.util.Collection<java.lang.String> schemaTypes) { throw new RuntimeException("Stub!"); }

/**
 * Adds Strings to the list of String parameters that can be referenced in the query through
 * the "getSearchStringParameter({index})" function.
 *
 * @see android.app.appsearch.AppSearchSession#search
 
 * @param searchStringParameters This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.SearchSuggestionSpec.Builder addSearchStringParameters(@android.annotation.NonNull java.lang.String... searchStringParameters) { throw new RuntimeException("Stub!"); }

/**
 * Adds Strings to the list of String parameters that can be referenced in the query through
 * the "getSearchStringParameter({index})" function.
 *
 * @see android.app.appsearch.AppSearchSession#search
 
 * @param searchStringParameters This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.SearchSuggestionSpec.Builder addSearchStringParameters(@android.annotation.NonNull java.util.List<java.lang.String> searchStringParameters) { throw new RuntimeException("Stub!"); }

/**
 * Constructs a new {@link android.app.appsearch.SearchSpec SearchSpec} from the contents of this builder.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.SearchSuggestionSpec build() { throw new RuntimeException("Stub!"); }

/**
 * Sets ranking strategy for suggestion results.
 *
 * <p>The default value {@link #SUGGESTION_RANKING_STRATEGY_DOCUMENT_COUNT} will be used if
 * this method is never called.
 
 * @param rankingStrategy Value is {@link android.app.appsearch.SearchSuggestionSpec#SUGGESTION_RANKING_STRATEGY_NONE}, {@link android.app.appsearch.SearchSuggestionSpec#SUGGESTION_RANKING_STRATEGY_DOCUMENT_COUNT}, or {@link android.app.appsearch.SearchSuggestionSpec#SUGGESTION_RANKING_STRATEGY_TERM_FREQUENCY}
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.SearchSuggestionSpec.Builder setRankingStrategy(int rankingStrategy) { throw new RuntimeException("Stub!"); }
}

}

