/*
 * Copyright 2021 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.app.appsearch.observer;


/**
 * Contains information about a schema change detected by an {@link android.app.appsearch.observer.ObserverCallback ObserverCallback}.
 *
 * <p>This object will be sent when a schema type having a name matching an observer's schema
 * filters (as determined by {@link android.app.appsearch.observer.ObserverSpec#getFilterSchemas ObserverSpec.getFilterSchemas}) has been added, updated, or
 * removed.
 *
 * <p>Note that schema changes may cause documents to be migrated or removed. When this happens,
 * individual document updates will NOT be dispatched via {@link android.app.appsearch.observer.DocumentChangeInfo DocumentChangeInfo}. The only
 * notification will be of the schema type change via {@link android.app.appsearch.observer.SchemaChangeInfo SchemaChangeInfo}. Depending on your
 * use case, you may need to re-query the whole schema type when this happens.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class SchemaChangeInfo {

/**
 * Constructs a new {@link android.app.appsearch.observer.SchemaChangeInfo SchemaChangeInfo}.
 *
 * @param packageName The package name of the app which owns the schema that changed.
 * @param databaseName The database in which the schema that changed resides.
 * @param changedSchemaNames Names of schemas that have changed as part of this notification.
 */

public SchemaChangeInfo(@android.annotation.NonNull java.lang.String packageName, @android.annotation.NonNull java.lang.String databaseName, @android.annotation.NonNull java.util.Set<java.lang.String> changedSchemaNames) { throw new RuntimeException("Stub!"); }

public boolean equals(@android.annotation.Nullable java.lang.Object o) { throw new RuntimeException("Stub!"); }

/**
 * Returns the names of schema types affected by this change notification.
 *
 * <p>This will never be empty.
 */

@android.annotation.NonNull
public java.util.Set<java.lang.String> getChangedSchemaNames() { throw new RuntimeException("Stub!"); }

/** Returns the database in which the schema that was changed resides. */

@android.annotation.NonNull
public java.lang.String getDatabaseName() { throw new RuntimeException("Stub!"); }

/** Returns the package name of the app which owns the schema that changed. */

@android.annotation.NonNull
public java.lang.String getPackageName() { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.lang.String toString() { throw new RuntimeException("Stub!"); }
}

