/*
 * Copyright 2020 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package android.app.appsearch;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class AppSearchResult<ValueType> {

private AppSearchResult() { throw new RuntimeException("Stub!"); }

public boolean isSuccess() { throw new RuntimeException("Stub!"); }

public int getResultCode() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public ValueType getResultValue() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public java.lang.String getErrorMessage() { throw new RuntimeException("Stub!"); }

public boolean equals(@android.annotation.Nullable java.lang.Object other) { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.lang.String toString() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public static <ValueType> android.app.appsearch.AppSearchResult<ValueType> newSuccessfulResult(@android.annotation.Nullable ValueType value) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public static <ValueType> android.app.appsearch.AppSearchResult<ValueType> newFailedResult(int resultCode, @android.annotation.Nullable java.lang.String errorMessage) { throw new RuntimeException("Stub!"); }

public static final int RESULT_INTERNAL_ERROR = 2; // 0x2

public static final int RESULT_INVALID_ARGUMENT = 3; // 0x3

public static final int RESULT_INVALID_SCHEMA = 7; // 0x7

public static final int RESULT_IO_ERROR = 4; // 0x4

public static final int RESULT_NOT_FOUND = 6; // 0x6

public static final int RESULT_OK = 0; // 0x0

public static final int RESULT_OUT_OF_SPACE = 5; // 0x5

public static final int RESULT_SECURITY_ERROR = 8; // 0x8

public static final int RESULT_UNKNOWN_ERROR = 1; // 0x1
}

