/*
 * Copyright 2020 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.app.appsearch;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class SearchSpec {

SearchSpec() { throw new RuntimeException("Stub!"); }

public int getTermMatch() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.List<java.lang.String> getFilterSchemas() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.List<java.lang.String> getFilterNamespaces() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.List<java.lang.String> getFilterPackageNames() { throw new RuntimeException("Stub!"); }

public int getResultCountPerPage() { throw new RuntimeException("Stub!"); }

public int getRankingStrategy() { throw new RuntimeException("Stub!"); }

public int getOrder() { throw new RuntimeException("Stub!"); }

public int getSnippetCount() { throw new RuntimeException("Stub!"); }

public int getSnippetCountPerProperty() { throw new RuntimeException("Stub!"); }

public int getMaxSnippetSize() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.Map<java.lang.String,java.util.List<java.lang.String>> getProjections() { throw new RuntimeException("Stub!"); }

public int getResultGroupingTypeFlags() { throw new RuntimeException("Stub!"); }

public int getResultGroupingLimit() { throw new RuntimeException("Stub!"); }

public static final int GROUPING_TYPE_PER_NAMESPACE = 2; // 0x2

public static final int GROUPING_TYPE_PER_PACKAGE = 1; // 0x1

public static final int ORDER_ASCENDING = 1; // 0x1

public static final int ORDER_DESCENDING = 0; // 0x0

public static final java.lang.String PROJECTION_SCHEMA_TYPE_WILDCARD = "*";

public static final int RANKING_STRATEGY_CREATION_TIMESTAMP = 2; // 0x2

public static final int RANKING_STRATEGY_DOCUMENT_SCORE = 1; // 0x1

public static final int RANKING_STRATEGY_NONE = 0; // 0x0

public static final int RANKING_STRATEGY_RELEVANCE_SCORE = 3; // 0x3

public static final int RANKING_STRATEGY_SYSTEM_USAGE_COUNT = 6; // 0x6

public static final int RANKING_STRATEGY_SYSTEM_USAGE_LAST_USED_TIMESTAMP = 7; // 0x7

public static final int RANKING_STRATEGY_USAGE_COUNT = 4; // 0x4

public static final int RANKING_STRATEGY_USAGE_LAST_USED_TIMESTAMP = 5; // 0x5

public static final int TERM_MATCH_EXACT_ONLY = 1; // 0x1

public static final int TERM_MATCH_PREFIX = 2; // 0x2
@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

public Builder() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.app.appsearch.SearchSpec.Builder setTermMatch(int termMatchType) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.app.appsearch.SearchSpec.Builder addFilterSchemas(@android.annotation.NonNull java.lang.String... schemas) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.app.appsearch.SearchSpec.Builder addFilterSchemas(@android.annotation.NonNull java.util.Collection<java.lang.String> schemas) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.app.appsearch.SearchSpec.Builder addFilterNamespaces(@android.annotation.NonNull java.lang.String... namespaces) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.app.appsearch.SearchSpec.Builder addFilterNamespaces(@android.annotation.NonNull java.util.Collection<java.lang.String> namespaces) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.app.appsearch.SearchSpec.Builder addFilterPackageNames(@android.annotation.NonNull java.lang.String... packageNames) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.app.appsearch.SearchSpec.Builder addFilterPackageNames(@android.annotation.NonNull java.util.Collection<java.lang.String> packageNames) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.app.appsearch.SearchSpec.Builder setResultCountPerPage(int resultCountPerPage) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.app.appsearch.SearchSpec.Builder setRankingStrategy(int rankingStrategy) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.app.appsearch.SearchSpec.Builder setOrder(int order) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.app.appsearch.SearchSpec.Builder setSnippetCount(int snippetCount) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.app.appsearch.SearchSpec.Builder setSnippetCountPerProperty(int snippetCountPerProperty) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.app.appsearch.SearchSpec.Builder setMaxSnippetSize(int maxSnippetSize) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.app.appsearch.SearchSpec.Builder addProjection(@android.annotation.NonNull java.lang.String schema, @android.annotation.NonNull java.util.Collection<java.lang.String> propertyPaths) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.app.appsearch.SearchSpec.Builder setResultGrouping(int groupingTypeFlags, int limit) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.app.appsearch.SearchSpec build() { throw new RuntimeException("Stub!"); }
}

}

