/*
 * Copyright 2020 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.app.appsearch;


/**
 * Represents a document unit.
 *
 * <p>Documents contain structured data conforming to their {@link android.app.appsearch.AppSearchSchema AppSearchSchema} type. Each
 * document is uniquely identified by a namespace and a String ID within that namespace.
 *
 * <p>Documents are constructed by using the {@link android.app.appsearch.GenericDocument.Builder GenericDocument.Builder}.
 *
 * @see android.app.appsearch.AppSearchSession#put
 * @see android.app.appsearch.AppSearchSession#getByDocumentId
 * @see android.app.appsearch.AppSearchSession#search
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public class GenericDocument {

/**
 * Creates a new {@link android.app.appsearch.GenericDocument GenericDocument} from an existing instance.
 *
 * <p>This method should be only used by constructor of a subclass.

 * @param document This value cannot be {@code null}.
 */

protected GenericDocument(@android.annotation.NonNull android.app.appsearch.GenericDocument document) { throw new RuntimeException("Stub!"); }

/**
 * The maximum number of indexed properties a document can have.
 *
 * <p>Indexed properties are properties which are strings where the {@link android.app.appsearch.AppSearchSchema.StringPropertyConfig#getIndexingType  } value is anything other than {@link android.app.appsearch.AppSearchSchema.StringPropertyConfig#INDEXING_TYPE_NONE  }.
 */

public static int getMaxIndexedProperties() { throw new RuntimeException("Stub!"); }

/**
 * Returns the unique identifier of the {@link android.app.appsearch.GenericDocument GenericDocument}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.lang.String getId() { throw new RuntimeException("Stub!"); }

/**
 * Returns the namespace of the {@link android.app.appsearch.GenericDocument GenericDocument}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.lang.String getNamespace() { throw new RuntimeException("Stub!"); }

/**
 * Returns the {@link android.app.appsearch.AppSearchSchema AppSearchSchema} type of the {@link android.app.appsearch.GenericDocument GenericDocument}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.lang.String getSchemaType() { throw new RuntimeException("Stub!"); }

/**
 * Returns the creation timestamp of the {@link android.app.appsearch.GenericDocument GenericDocument}, in milliseconds.
 *
 * <p>The value is in the {@link java.lang.System#currentTimeMillis System#currentTimeMillis} time base.
 
 * <br>
 * Value is a non-negative timestamp measured as the number of
 * milliseconds since 1970-01-01T00:00:00Z.

 * @return Value is a non-negative timestamp measured as the number of
 * milliseconds since 1970-01-01T00:00:00Z.
 */

public long getCreationTimestampMillis() { throw new RuntimeException("Stub!"); }

/**
 * Returns the TTL (time-to-live) of the {@link android.app.appsearch.GenericDocument GenericDocument}, in milliseconds.
 *
 * <p>The TTL is measured against {@link #getCreationTimestampMillis}. At the timestamp of
 * {@code creationTimestampMillis + ttlMillis}, measured in the {@link java.lang.System#currentTimeMillis System#currentTimeMillis}
 * time base, the document will be auto-deleted.
 *
 * <p>The default value is 0, which means the document is permanent and won't be auto-deleted
 * until the app is uninstalled or {@link android.app.appsearch.AppSearchSession#remove AppSearchSession#remove} is called.
 */

public long getTtlMillis() { throw new RuntimeException("Stub!"); }

/**
 * Returns the score of the {@link android.app.appsearch.GenericDocument GenericDocument}.
 *
 * <p>The score is a query-independent measure of the document's quality, relative to other
 * {@link android.app.appsearch.GenericDocument GenericDocument} objects of the same {@link android.app.appsearch.AppSearchSchema AppSearchSchema} type.
 *
 * <p>Results may be sorted by score using {@link android.app.appsearch.SearchSpec.Builder#setRankingStrategy SearchSpec.Builder#setRankingStrategy}.
 * Documents with higher scores are considered better than documents with lower scores.
 *
 * <p>Any non-negative integer can be used a score.
 */

public int getScore() { throw new RuntimeException("Stub!"); }

/**
 * Returns the names of all properties defined in this document.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.util.Set<java.lang.String> getPropertyNames() { throw new RuntimeException("Stub!"); }

/**
 * Retrieves the property value with the given path as {@link java.lang.Object Object}.
 *
 * <p>A path can be a simple property name, such as those returned by {@link #getPropertyNames}.
 * It may also be a dot-delimited path through the nested document hierarchy, with nested {@link android.app.appsearch.GenericDocument GenericDocument} properties accessed via {@code '.'} and repeated properties optionally
 * indexed into via {@code [n]}.
 *
 * <p>For example, given the following {@link android.app.appsearch.GenericDocument GenericDocument}:
 *
 * <pre>
 *     (Message) {
 *         from: "sender@example.com"
 *         to: [{
 *             name: "Albert Einstein"
 *             email: "einstein@example.com"
 *           }, {
 *             name: "Marie Curie"
 *             email: "curie@example.com"
 *           }]
 *         tags: ["important", "inbox"]
 *         subject: "Hello"
 *     }
 * </pre>
 *
 * <p>Here are some example paths and their results:
 *
 * <ul>
 *   <li>{@code "from"} returns {@code "sender@example.com"} as a {@link java.lang.String String} array with one
 *       element
 *   <li>{@code "to"} returns the two nested documents containing contact information as a
 *       {@link android.app.appsearch.GenericDocument GenericDocument} array with two elements
 *   <li>{@code "to[1]"} returns the second nested document containing Marie Curie's contact
 *       information as a {@link android.app.appsearch.GenericDocument GenericDocument} array with one element
 *   <li>{@code "to[1].email"} returns {@code "curie@example.com"}
 *   <li>{@code "to[100].email"} returns {@code null} as this particular document does not have
 *       that many elements in its {@code "to"} array.
 *   <li>{@code "to.email"} aggregates emails across all nested documents that have them,
 *       returning {@code ["einstein@example.com", "curie@example.com"]} as a {@link java.lang.String String}
 *       array with two elements.
 * </ul>
 *
 * <p>If you know the expected type of the property you are retrieving, it is recommended to use
 * one of the typed versions of this method instead, such as {@link #getPropertyString} or
 * {@link #getPropertyStringArray}.
 *
 * <p>If the property was assigned as an empty array using one of the {@code
 * Builder#setProperty} functions, this method will return an empty array. If no such property
 * exists at all, this method returns {@code null}.
 *
 * <p>Note: If the property is an empty {@link android.app.appsearch.GenericDocument GenericDocument}[] or {@code byte[][]}, this
 * method will return a {@code null} value in versions of Android prior to {@link
 * android.os.Build.VERSION_CODES#TIRAMISU Android T}. Starting in Android T it will return an
 * empty array if the property has been set as an empty array, matching the behavior of other
 * property types.
 *
 * @param path The path to look for.
 * This value cannot be {@code null}.
 * @return The entry with the given path as an object or {@code null} if there is no such path.
 *     The returned object will be one of the following types: {@code String[]}, {@code long[]},
 *     {@code double[]}, {@code boolean[]}, {@code byte[][]}, {@code GenericDocument[]}.
 */

@android.annotation.Nullable
public java.lang.Object getProperty(@android.annotation.NonNull java.lang.String path) { throw new RuntimeException("Stub!"); }

/**
 * Retrieves a {@link java.lang.String String} property by path.
 *
 * <p>See {@link #getProperty} for a detailed description of the path syntax.
 *
 * @param path The path to look for.
 * This value cannot be {@code null}.
 * @return The first {@link java.lang.String String} associated with the given path or {@code null} if there is
 *     no such value or the value is of a different type.
 */

@android.annotation.Nullable
public java.lang.String getPropertyString(@android.annotation.NonNull java.lang.String path) { throw new RuntimeException("Stub!"); }

/**
 * Retrieves a {@code long} property by path.
 *
 * <p>See {@link #getProperty} for a detailed description of the path syntax.
 *
 * @param path The path to look for.
 * This value cannot be {@code null}.
 * @return The first {@code long} associated with the given path or default value {@code 0} if
 *     there is no such value or the value is of a different type.
 */

public long getPropertyLong(@android.annotation.NonNull java.lang.String path) { throw new RuntimeException("Stub!"); }

/**
 * Retrieves a {@code double} property by path.
 *
 * <p>See {@link #getProperty} for a detailed description of the path syntax.
 *
 * @param path The path to look for.
 * This value cannot be {@code null}.
 * @return The first {@code double} associated with the given path or default value {@code 0.0}
 *     if there is no such value or the value is of a different type.
 */

public double getPropertyDouble(@android.annotation.NonNull java.lang.String path) { throw new RuntimeException("Stub!"); }

/**
 * Retrieves a {@code boolean} property by path.
 *
 * <p>See {@link #getProperty} for a detailed description of the path syntax.
 *
 * @param path The path to look for.
 * This value cannot be {@code null}.
 * @return The first {@code boolean} associated with the given path or default value {@code
 *     false} if there is no such value or the value is of a different type.
 */

public boolean getPropertyBoolean(@android.annotation.NonNull java.lang.String path) { throw new RuntimeException("Stub!"); }

/**
 * Retrieves a {@code byte[]} property by path.
 *
 * <p>See {@link #getProperty} for a detailed description of the path syntax.
 *
 * @param path The path to look for.
 * This value cannot be {@code null}.
 * @return The first {@code byte[]} associated with the given path or {@code null} if there is
 *     no such value or the value is of a different type.
 */

@android.annotation.Nullable
public byte[] getPropertyBytes(@android.annotation.NonNull java.lang.String path) { throw new RuntimeException("Stub!"); }

/**
 * Retrieves a {@link android.app.appsearch.GenericDocument GenericDocument} property by path.
 *
 * <p>See {@link #getProperty} for a detailed description of the path syntax.
 *
 * @param path The path to look for.
 * This value cannot be {@code null}.
 * @return The first {@link android.app.appsearch.GenericDocument GenericDocument} associated with the given path or {@code null} if
 *     there is no such value or the value is of a different type.
 */

@android.annotation.Nullable
public android.app.appsearch.GenericDocument getPropertyDocument(@android.annotation.NonNull java.lang.String path) { throw new RuntimeException("Stub!"); }

/**
 * Retrieves a repeated {@code String} property by path.
 *
 * <p>See {@link #getProperty} for a detailed description of the path syntax.
 *
 * <p>If the property has not been set via {@link android.app.appsearch.GenericDocument.Builder#setPropertyString Builder#setPropertyString}, this method
 * returns {@code null}.
 *
 * <p>If it has been set via {@link android.app.appsearch.GenericDocument.Builder#setPropertyString Builder#setPropertyString} to an empty {@code String[]},
 * this method returns an empty {@code String[]}.
 *
 * @param path The path to look for.
 * This value cannot be {@code null}.
 * @return The {@code String[]} associated with the given path, or {@code null} if no value is
 *     set or the value is of a different type.
 */

@android.annotation.Nullable
public java.lang.String[] getPropertyStringArray(@android.annotation.NonNull java.lang.String path) { throw new RuntimeException("Stub!"); }

/**
 * Retrieves a repeated {@code long[]} property by path.
 *
 * <p>See {@link #getProperty} for a detailed description of the path syntax.
 *
 * <p>If the property has not been set via {@link android.app.appsearch.GenericDocument.Builder#setPropertyLong Builder#setPropertyLong}, this method returns
 * {@code null}.
 *
 * <p>If it has been set via {@link android.app.appsearch.GenericDocument.Builder#setPropertyLong Builder#setPropertyLong} to an empty {@code long[]}, this
 * method returns an empty {@code long[]}.
 *
 * @param path The path to look for.
 * This value cannot be {@code null}.
 * @return The {@code long[]} associated with the given path, or {@code null} if no value is set
 *     or the value is of a different type.
 */

@android.annotation.Nullable
public long[] getPropertyLongArray(@android.annotation.NonNull java.lang.String path) { throw new RuntimeException("Stub!"); }

/**
 * Retrieves a repeated {@code double} property by path.
 *
 * <p>See {@link #getProperty} for a detailed description of the path syntax.
 *
 * <p>If the property has not been set via {@link android.app.appsearch.GenericDocument.Builder#setPropertyDouble Builder#setPropertyDouble}, this method
 * returns {@code null}.
 *
 * <p>If it has been set via {@link android.app.appsearch.GenericDocument.Builder#setPropertyDouble Builder#setPropertyDouble} to an empty {@code double[]},
 * this method returns an empty {@code double[]}.
 *
 * @param path The path to look for.
 * This value cannot be {@code null}.
 * @return The {@code double[]} associated with the given path, or {@code null} if no value is
 *     set or the value is of a different type.
 */

@android.annotation.Nullable
public double[] getPropertyDoubleArray(@android.annotation.NonNull java.lang.String path) { throw new RuntimeException("Stub!"); }

/**
 * Retrieves a repeated {@code boolean} property by path.
 *
 * <p>See {@link #getProperty} for a detailed description of the path syntax.
 *
 * <p>If the property has not been set via {@link android.app.appsearch.GenericDocument.Builder#setPropertyBoolean Builder#setPropertyBoolean}, this method
 * returns {@code null}.
 *
 * <p>If it has been set via {@link android.app.appsearch.GenericDocument.Builder#setPropertyBoolean Builder#setPropertyBoolean} to an empty {@code boolean[]},
 * this method returns an empty {@code boolean[]}.
 *
 * @param path The path to look for.
 * This value cannot be {@code null}.
 * @return The {@code boolean[]} associated with the given path, or {@code null} if no value is
 *     set or the value is of a different type.
 */

@android.annotation.Nullable
public boolean[] getPropertyBooleanArray(@android.annotation.NonNull java.lang.String path) { throw new RuntimeException("Stub!"); }

/**
 * Retrieves a {@code byte[][]} property by path.
 *
 * <p>See {@link #getProperty} for a detailed description of the path syntax.
 *
 * <p>If the property has not been set via {@link android.app.appsearch.GenericDocument.Builder#setPropertyBytes Builder#setPropertyBytes}, this method returns
 * {@code null}.
 *
 * <p>If it has been set via {@link android.app.appsearch.GenericDocument.Builder#setPropertyBytes Builder#setPropertyBytes} to an empty {@code byte[][]}, this
 * method returns an empty {@code byte[][]} starting in {@link
 * android.os.Build.VERSION_CODES#TIRAMISU Android T} and {@code null} in earlier versions of
 * Android.
 *
 * @param path The path to look for.
 * This value cannot be {@code null}.
 * @return The {@code byte[][]} associated with the given path, or {@code null} if no value is
 *     set or the value is of a different type.
 */

@android.annotation.Nullable
public byte[][] getPropertyBytesArray(@android.annotation.NonNull java.lang.String path) { throw new RuntimeException("Stub!"); }

/**
 * Retrieves a repeated {@link android.app.appsearch.GenericDocument GenericDocument} property by path.
 *
 * <p>See {@link #getProperty} for a detailed description of the path syntax.
 *
 * <p>If the property has not been set via {@link android.app.appsearch.GenericDocument.Builder#setPropertyDocument Builder#setPropertyDocument}, this method
 * returns {@code null}.
 *
 * <p>If it has been set via {@link android.app.appsearch.GenericDocument.Builder#setPropertyDocument Builder#setPropertyDocument} to an empty {@code
 * GenericDocument[]}, this method returns an empty {@code GenericDocument[]} starting in {@link
 * android.os.Build.VERSION_CODES#TIRAMISU Android T} and {@code null} in earlier versions of
 * Android.
 *
 * @param path The path to look for.
 * This value cannot be {@code null}.
 * @return The {@link android.app.appsearch.GenericDocument GenericDocument}[] associated with the given path, or {@code null} if no
 *     value is set or the value is of a different type.
 */

@android.annotation.Nullable
public android.app.appsearch.GenericDocument[] getPropertyDocumentArray(@android.annotation.NonNull java.lang.String path) { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param other This value may be {@code null}.
 */

public boolean equals(@android.annotation.Nullable java.lang.Object other) { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.lang.String toString() { throw new RuntimeException("Stub!"); }
/**
 * The builder class for {@link android.app.appsearch.GenericDocument GenericDocument}.
 *
 * @param <BuilderType> Type of subclass who extends this.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static class Builder<BuilderType extends android.app.appsearch.GenericDocument.Builder> {

/**
 * Creates a new {@link android.app.appsearch.GenericDocument.Builder GenericDocument.Builder}.
 *
 * <p>Document IDs are unique within a namespace.
 *
 * <p>The number of namespaces per app should be kept small for efficiency reasons.
 *
 * @param namespace the namespace to set for the {@link android.app.appsearch.GenericDocument GenericDocument}.
 * This value cannot be {@code null}.
 * @param id the unique identifier for the {@link android.app.appsearch.GenericDocument GenericDocument} in its namespace.
 * This value cannot be {@code null}.
 * @param schemaType the {@link android.app.appsearch.AppSearchSchema AppSearchSchema} type of the {@link android.app.appsearch.GenericDocument GenericDocument}. The
 *     provided {@code schemaType} must be defined using {@link android.app.appsearch.AppSearchSession#setSchema AppSearchSession#setSchema}
 *     prior to inserting a document of this {@code schemaType} into the AppSearch index
 *     using {@link android.app.appsearch.AppSearchSession#put AppSearchSession#put}. Otherwise, the document will be rejected by
 *     {@link android.app.appsearch.AppSearchSession#put AppSearchSession#put} with result code {@link android.app.appsearch.AppSearchResult#RESULT_NOT_FOUND      }.

 * This value cannot be {@code null}.
 */

public Builder(@android.annotation.NonNull java.lang.String namespace, @android.annotation.NonNull java.lang.String id, @android.annotation.NonNull java.lang.String schemaType) { throw new RuntimeException("Stub!"); }

/**
 * Sets the score of the {@link android.app.appsearch.GenericDocument GenericDocument}.
 *
 * <p>The score is a query-independent measure of the document's quality, relative to other
 * {@link android.app.appsearch.GenericDocument GenericDocument} objects of the same {@link android.app.appsearch.AppSearchSchema AppSearchSchema} type.
 *
 * <p>Results may be sorted by score using {@link android.app.appsearch.SearchSpec.Builder#setRankingStrategy SearchSpec.Builder#setRankingStrategy}.
 * Documents with higher scores are considered better than documents with lower scores.
 *
 * <p>Any non-negative integer can be used a score. By default, scores are set to 0.
 *
 * @param score any non-negative {@code int} representing the document's score.
 
 * Value is between 0 and Integer.MAX_VALUE inclusive
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public BuilderType setScore(int score) { throw new RuntimeException("Stub!"); }

/**
 * Sets the creation timestamp of the {@link android.app.appsearch.GenericDocument GenericDocument}, in milliseconds.
 *
 * <p>This should be set using a value obtained from the {@link java.lang.System#currentTimeMillis System#currentTimeMillis}
 * time base.
 *
 * <p>If this method is not called, this will be set to the time the object is built.
 *
 * @param creationTimestampMillis a creation timestamp in milliseconds.
 
 * Value is a non-negative timestamp measured as the number of
 * milliseconds since 1970-01-01T00:00:00Z.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public BuilderType setCreationTimestampMillis(long creationTimestampMillis) { throw new RuntimeException("Stub!"); }

/**
 * Sets the TTL (time-to-live) of the {@link android.app.appsearch.GenericDocument GenericDocument}, in milliseconds.
 *
 * <p>The TTL is measured against {@link #getCreationTimestampMillis}. At the timestamp of
 * {@code creationTimestampMillis + ttlMillis}, measured in the {@link java.lang.System#currentTimeMillis  } time base, the document will be auto-deleted.
 *
 * <p>The default value is 0, which means the document is permanent and won't be
 * auto-deleted until the app is uninstalled or {@link android.app.appsearch.AppSearchSession#remove AppSearchSession#remove} is called.
 *
 * @param ttlMillis a non-negative duration in milliseconds.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public BuilderType setTtlMillis(long ttlMillis) { throw new RuntimeException("Stub!"); }

/**
 * Sets one or multiple {@code String} values for a property, replacing its previous values.
 *
 * @param name the name associated with the {@code values}. Must match the name for this
 *     property as given in {@link android.app.appsearch.AppSearchSchema.PropertyConfig#getName AppSearchSchema.PropertyConfig#getName}.
 * This value cannot be {@code null}.
 * @param values the {@code String} values of the property.
 * This value cannot be {@code null}.
 * @throws java.lang.IllegalArgumentException if no values are provided, or if a passed in {@code
 *     String} is {@code null} or "".
 
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public BuilderType setPropertyString(@android.annotation.NonNull java.lang.String name, @android.annotation.NonNull java.lang.String... values) { throw new RuntimeException("Stub!"); }

/**
 * Sets one or multiple {@code boolean} values for a property, replacing its previous
 * values.
 *
 * @param name the name associated with the {@code values}. Must match the name for this
 *     property as given in {@link android.app.appsearch.AppSearchSchema.PropertyConfig#getName AppSearchSchema.PropertyConfig#getName}.
 * This value cannot be {@code null}.
 * @param values the {@code boolean} values of the property.
 * This value cannot be {@code null}.
 * @throws java.lang.IllegalArgumentException if the name is empty or {@code null}.
 
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public BuilderType setPropertyBoolean(@android.annotation.NonNull java.lang.String name, @android.annotation.NonNull boolean... values) { throw new RuntimeException("Stub!"); }

/**
 * Sets one or multiple {@code long} values for a property, replacing its previous values.
 *
 * @param name the name associated with the {@code values}. Must match the name for this
 *     property as given in {@link android.app.appsearch.AppSearchSchema.PropertyConfig#getName AppSearchSchema.PropertyConfig#getName}.
 * This value cannot be {@code null}.
 * @param values the {@code long} values of the property.
 * This value cannot be {@code null}.
 * @throws java.lang.IllegalArgumentException if the name is empty or {@code null}.
 
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public BuilderType setPropertyLong(@android.annotation.NonNull java.lang.String name, @android.annotation.NonNull long... values) { throw new RuntimeException("Stub!"); }

/**
 * Sets one or multiple {@code double} values for a property, replacing its previous values.
 *
 * @param name the name associated with the {@code values}. Must match the name for this
 *     property as given in {@link android.app.appsearch.AppSearchSchema.PropertyConfig#getName AppSearchSchema.PropertyConfig#getName}.
 * This value cannot be {@code null}.
 * @param values the {@code double} values of the property.
 * This value cannot be {@code null}.
 * @throws java.lang.IllegalArgumentException if the name is empty or {@code null}.
 
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public BuilderType setPropertyDouble(@android.annotation.NonNull java.lang.String name, @android.annotation.NonNull double... values) { throw new RuntimeException("Stub!"); }

/**
 * Sets one or multiple {@code byte[]} for a property, replacing its previous values.
 *
 * @param name the name associated with the {@code values}. Must match the name for this
 *     property as given in {@link android.app.appsearch.AppSearchSchema.PropertyConfig#getName AppSearchSchema.PropertyConfig#getName}.
 * This value cannot be {@code null}.
 * @param values the {@code byte[]} of the property.
 * This value cannot be {@code null}.
 * @throws java.lang.IllegalArgumentException if no values are provided, or if a passed in {@code
 *     byte[]} is {@code null}, or if name is empty.
 
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public BuilderType setPropertyBytes(@android.annotation.NonNull java.lang.String name, @android.annotation.NonNull byte[]... values) { throw new RuntimeException("Stub!"); }

/**
 * Sets one or multiple {@link android.app.appsearch.GenericDocument GenericDocument} values for a property, replacing its
 * previous values.
 *
 * @param name the name associated with the {@code values}. Must match the name for this
 *     property as given in {@link android.app.appsearch.AppSearchSchema.PropertyConfig#getName AppSearchSchema.PropertyConfig#getName}.
 * This value cannot be {@code null}.
 * @param values the {@link android.app.appsearch.GenericDocument GenericDocument} values of the property.
 * This value cannot be {@code null}.
 * @throws java.lang.IllegalArgumentException if no values are provided, or if a passed in {@link android.app.appsearch.GenericDocument GenericDocument} is {@code null}, or if name is empty.
 
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public BuilderType setPropertyDocument(@android.annotation.NonNull java.lang.String name, @android.annotation.NonNull android.app.appsearch.GenericDocument... values) { throw new RuntimeException("Stub!"); }

/**
 * Builds the {@link android.app.appsearch.GenericDocument GenericDocument} object.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.GenericDocument build() { throw new RuntimeException("Stub!"); }
}

}

