/*
 * Copyright 2020 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.app.appsearch;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class SetSchemaRequest {

SetSchemaRequest() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.Set<android.app.appsearch.AppSearchSchema> getSchemas() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.Set<java.lang.String> getSchemasNotDisplayedBySystem() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.Map<java.lang.String,java.util.Set<android.app.appsearch.PackageIdentifier>> getSchemasVisibleToPackages() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.Map<java.lang.String,java.util.Set<java.util.Set<java.lang.Integer>>> getRequiredPermissionsForSchemaTypeVisibility() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.Map<java.lang.String,android.app.appsearch.Migrator> getMigrators() { throw new RuntimeException("Stub!"); }

public boolean isForceOverride() { throw new RuntimeException("Stub!"); }

public int getVersion() { throw new RuntimeException("Stub!"); }

public static final int READ_ASSISTANT_APP_SEARCH_DATA = 6; // 0x6

public static final int READ_CALENDAR = 2; // 0x2

public static final int READ_CONTACTS = 3; // 0x3

public static final int READ_EXTERNAL_STORAGE = 4; // 0x4

public static final int READ_HOME_APP_SEARCH_DATA = 5; // 0x5

public static final int READ_SMS = 1; // 0x1
@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

public Builder() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.app.appsearch.SetSchemaRequest.Builder addSchemas(@android.annotation.NonNull android.app.appsearch.AppSearchSchema... schemas) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.app.appsearch.SetSchemaRequest.Builder addSchemas(@android.annotation.NonNull java.util.Collection<android.app.appsearch.AppSearchSchema> schemas) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.app.appsearch.SetSchemaRequest.Builder setSchemaTypeDisplayedBySystem(@android.annotation.NonNull java.lang.String schemaType, boolean displayed) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.app.appsearch.SetSchemaRequest.Builder addRequiredPermissionsForSchemaTypeVisibility(@android.annotation.NonNull java.lang.String schemaType, @android.annotation.NonNull java.util.Set<java.lang.Integer> permissions) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.app.appsearch.SetSchemaRequest.Builder clearRequiredPermissionsForSchemaTypeVisibility(@android.annotation.NonNull java.lang.String schemaType) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.app.appsearch.SetSchemaRequest.Builder setSchemaTypeVisibilityForPackage(@android.annotation.NonNull java.lang.String schemaType, boolean visible, @android.annotation.NonNull android.app.appsearch.PackageIdentifier packageIdentifier) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.app.appsearch.SetSchemaRequest.Builder setMigrator(@android.annotation.NonNull java.lang.String schemaType, @android.annotation.NonNull android.app.appsearch.Migrator migrator) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.app.appsearch.SetSchemaRequest.Builder setMigrators(@android.annotation.NonNull java.util.Map<java.lang.String,android.app.appsearch.Migrator> migrators) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.app.appsearch.SetSchemaRequest.Builder setForceOverride(boolean forceOverride) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.app.appsearch.SetSchemaRequest.Builder setVersion(int version) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.app.appsearch.SetSchemaRequest build() { throw new RuntimeException("Stub!"); }
}

}

