/*
 * Copyright 2020 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.app.appsearch;

import android.app.appsearch.exceptions.AppSearchException;
import java.util.Collection;
import java.util.List;
import java.util.Map;

/**
 * This class represents the specification logic for AppSearch. It can be used to set the type of
 * search, like prefix or exact only or apply filters to search for a specific schema type only etc.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class SearchSpec implements android.os.Parcelable {

SearchSpec() { throw new RuntimeException("Stub!"); }

/** @hide */

public final int describeContents() { throw new RuntimeException("Stub!"); }

/**
 * Get the advanced ranking expression, or "" if {@link android.app.appsearch.SearchSpec.Builder#setRankingStrategy(java.lang.String) Builder.setRankingStrategy(String)} was
 * not called.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.lang.String getAdvancedRankingExpression() { throw new RuntimeException("Stub!"); }

/**
 * Returns the default embedding metric type used for embedding search (see {@link android.app.appsearch.AppSearchSession#search  }) and ranking (see {@link android.app.appsearch.SearchSpec.Builder#setRankingStrategy(java.lang.String)  }).

 * @return Value is {@link android.app.appsearch.SearchSpec#EMBEDDING_SEARCH_METRIC_TYPE_DEFAULT}, {@link android.app.appsearch.SearchSpec#EMBEDDING_SEARCH_METRIC_TYPE_COSINE}, {@link android.app.appsearch.SearchSpec#EMBEDDING_SEARCH_METRIC_TYPE_DOT_PRODUCT}, or {@link android.app.appsearch.SearchSpec#EMBEDDING_SEARCH_METRIC_TYPE_EUCLIDEAN}
 */

public int getDefaultEmbeddingSearchMetricType() { throw new RuntimeException("Stub!"); }

/**
 * Returns the list of {@link android.app.appsearch.EmbeddingVector EmbeddingVector} that can be referenced in the query through the
 * "getEmbeddingParameter({index})" function.
 *
 * @see android.app.appsearch.AppSearchSession#search

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.util.List<android.app.appsearch.EmbeddingVector> getEmbeddingParameters() { throw new RuntimeException("Stub!"); }

/**
 * Returns the list of document ids to search over.
 *
 * <p>If empty, the query will search over all documents.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.util.List<java.lang.String> getFilterDocumentIds() { throw new RuntimeException("Stub!"); }

/**
 * Returns the list of namespaces to search over.
 *
 * <p>If empty, the query will search over all namespaces.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.util.List<java.lang.String> getFilterNamespaces() { throw new RuntimeException("Stub!"); }

/**
 * Returns the list of package name filters to search over.
 *
 * <p>If empty, the query will search over all packages that the caller has access to. If
 * package names are specified which caller doesn't have access to, then those package names
 * will be ignored.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.util.List<java.lang.String> getFilterPackageNames() { throw new RuntimeException("Stub!"); }

/**
 * Returns the map of schema and target properties to search over.
 *
 * <p>If empty, will search over all schema and properties.
 *
 * <p>Calling this function repeatedly is inefficient. Prefer to retain the Map returned by this
 * function, rather than calling it multiple times.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.util.Map<java.lang.String,java.util.List<java.lang.String>> getFilterProperties() { throw new RuntimeException("Stub!"); }

/**
 * Returns the list of schema types to search for.
 *
 * <p>If empty, the query will search over all schema types.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.util.List<java.lang.String> getFilterSchemas() { throw new RuntimeException("Stub!"); }

/**
 * Returns the informational ranking expressions.
 *
 * @see Builder#addInformationalRankingExpressions

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.util.List<java.lang.String> getInformationalRankingExpressions() { throw new RuntimeException("Stub!"); }

/**
 * Returns specification on which documents need to be joined.
 * @return This value may be {@code null}.
 */

@android.annotation.Nullable
public android.app.appsearch.JoinSpec getJoinSpec() { throw new RuntimeException("Stub!"); }

/** Returns the maximum size of a snippet in characters. */

public int getMaxSnippetSize() { throw new RuntimeException("Stub!"); }

/**
 * Returns the order of returned search results (descending or ascending).
 * @return Value is {@link android.app.appsearch.SearchSpec#ORDER_DESCENDING}, or {@link android.app.appsearch.SearchSpec#ORDER_ASCENDING}
 */

public int getOrder() { throw new RuntimeException("Stub!"); }

/**
 * Returns a map from schema type to property paths to be used for projection.
 *
 * <p>If the map is empty, then all properties will be retrieved for all results.
 *
 * <p>Calling this function repeatedly is inefficient. Prefer to retain the Map returned by this
 * function, rather than calling it multiple times.
 *
 * @return A mapping of schema types to lists of projection {@link android.app.appsearch.PropertyPath PropertyPath} objects.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.util.Map<java.lang.String,java.util.List<android.app.appsearch.PropertyPath>> getProjectionPaths() { throw new RuntimeException("Stub!"); }

/**
 * Returns a map from schema type to property paths to be used for projection.
 *
 * <p>If the map is empty, then all properties will be retrieved for all results.
 *
 * <p>Calling this function repeatedly is inefficient. Prefer to retain the Map returned by this
 * function, rather than calling it multiple times.
 *
 * @return A mapping of schema types to lists of projection strings.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.util.Map<java.lang.String,java.util.List<java.lang.String>> getProjections() { throw new RuntimeException("Stub!"); }

/**
 * Returns properties weights to be used for scoring.
 *
 * <p>Calling this function repeatedly is inefficient. Prefer to retain the {@link java.util.Map Map} returned
 * by this function, rather than calling it multiple times.
 *
 * @return a {@link java.util.Map Map} of schema type to an inner-map of property paths of the schema type to
 *     the weight to set for that property.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.util.Map<java.lang.String,java.util.Map<android.app.appsearch.PropertyPath,java.lang.Double>> getPropertyWeightPaths() { throw new RuntimeException("Stub!"); }

/**
 * Returns properties weights to be used for scoring.
 *
 * <p>Calling this function repeatedly is inefficient. Prefer to retain the {@link java.util.Map Map} returned
 * by this function, rather than calling it multiple times.
 *
 * @return a {@link java.util.Map Map} of schema type to an inner-map of property paths of the schema type to
 *     the weight to set for that property.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.util.Map<java.lang.String,java.util.Map<java.lang.String,java.lang.Double>> getPropertyWeights() { throw new RuntimeException("Stub!"); }

/**
 * Returns the ranking strategy.
 * @return Value is {@link android.app.appsearch.SearchSpec#RANKING_STRATEGY_NONE}, {@link android.app.appsearch.SearchSpec#RANKING_STRATEGY_DOCUMENT_SCORE}, {@link android.app.appsearch.SearchSpec#RANKING_STRATEGY_CREATION_TIMESTAMP}, {@link android.app.appsearch.SearchSpec#RANKING_STRATEGY_RELEVANCE_SCORE}, {@link android.app.appsearch.SearchSpec#RANKING_STRATEGY_USAGE_COUNT}, {@link android.app.appsearch.SearchSpec#RANKING_STRATEGY_USAGE_LAST_USED_TIMESTAMP}, {@link android.app.appsearch.SearchSpec#RANKING_STRATEGY_SYSTEM_USAGE_COUNT}, {@link android.app.appsearch.SearchSpec#RANKING_STRATEGY_SYSTEM_USAGE_LAST_USED_TIMESTAMP}, {@link android.app.appsearch.SearchSpec#RANKING_STRATEGY_JOIN_AGGREGATE_SCORE}, or {@link android.app.appsearch.SearchSpec#RANKING_STRATEGY_ADVANCED_RANKING_EXPRESSION}
 */

public int getRankingStrategy() { throw new RuntimeException("Stub!"); }

/** Returns the number of results per page in the result set. */

public int getResultCountPerPage() { throw new RuntimeException("Stub!"); }

/**
 * Get the maximum number of results to return for each group.
 *
 * @return the maximum number of results to return for each group or 0 if {@link android.app.appsearch.SearchSpec.Builder#setResultGrouping(int,int)      } was not called.
 */

public int getResultGroupingLimit() { throw new RuntimeException("Stub!"); }

/**
 * Get the type of grouping limit to apply, or 0 if {@link android.app.appsearch.SearchSpec.Builder#setResultGrouping Builder.setResultGrouping} was not
 * called.

 * @return Value is either <code>0</code> or a combination of {@link android.app.appsearch.SearchSpec#GROUPING_TYPE_PER_PACKAGE}, {@link android.app.appsearch.SearchSpec#GROUPING_TYPE_PER_NAMESPACE}, and {@link android.app.appsearch.SearchSpec#GROUPING_TYPE_PER_SCHEMA}
 */

public int getResultGroupingTypeFlags() { throw new RuntimeException("Stub!"); }

/**
 * Gets a tag to indicate the source of this search, or {@code null} if {@link android.app.appsearch.SearchSpec.Builder#setSearchSourceLogTag(java.lang.String)  } was not called.
 *
 * <p>Some AppSearch implementations may log a hash of this tag using statsd. This tag may be
 * used for tracing performance issues and crashes to a component of an app.
 *
 * <p>Call {@link android.app.appsearch.SearchSpec.Builder#setSearchSourceLogTag Builder.setSearchSourceLogTag} and give a unique value if you want to
 * distinguish this search scenario with other search scenarios during performance analysis.
 *
 * <p>Under no circumstances will AppSearch log the raw String value using statsd, but it will
 * be provided as-is to custom {@code AppSearchLogger} implementations you have registered in
 * your app.
 */

@android.annotation.Nullable
public java.lang.String getSearchSourceLogTag() { throw new RuntimeException("Stub!"); }

/**
 * Returns the list of String parameters that can be referenced in the query through the
 * "getSearchStringParameter({index})" function.
 *
 * @see android.app.appsearch.AppSearchSession#search

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.util.List<java.lang.String> getSearchStringParameters() { throw new RuntimeException("Stub!"); }

/** Returns how many documents to generate snippets for. */

public int getSnippetCount() { throw new RuntimeException("Stub!"); }

/**
 * Returns how many matches for each property of a matching document to generate snippets for.
 */

public int getSnippetCountPerProperty() { throw new RuntimeException("Stub!"); }

/**
 * Returns how the query terms should match terms in the index.
 * @return Value is {@link android.app.appsearch.SearchSpec#TERM_MATCH_EXACT_ONLY}, or {@link android.app.appsearch.SearchSpec#TERM_MATCH_PREFIX}
 */

public int getTermMatch() { throw new RuntimeException("Stub!"); }

/** Returns whether the LIST_FILTER_HAS_PROPERTY_FUNCTION feature is enabled. */

public boolean isListFilterHasPropertyFunctionEnabled() { throw new RuntimeException("Stub!"); }

/** Returns whether the LIST_FILTER_MATCH_SCORE_EXPRESSION_FUNCTION feature is enabled. */

public boolean isListFilterMatchScoreExpressionFunctionEnabled() { throw new RuntimeException("Stub!"); }

/** Returns whether the LIST_FILTER_QUERY_LANGUAGE feature is enabled. */

public boolean isListFilterQueryLanguageEnabled() { throw new RuntimeException("Stub!"); }

/** Returns whether the NUMERIC_SEARCH feature is enabled. */

public boolean isNumericSearchEnabled() { throw new RuntimeException("Stub!"); }

/** Returns whether the ScorablePropertyRanking feature is enabled. */

public boolean isScorablePropertyRankingEnabled() { throw new RuntimeException("Stub!"); }

/** Returns whether the VERBATIM_SEARCH feature is enabled. */

public boolean isVerbatimSearchEnabled() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param dest This value cannot be {@code null}.
 */

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

/** Creator class for {@link android.app.appsearch.SearchSpec SearchSpec}. */

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.app.appsearch.SearchSpec> CREATOR;
static { CREATOR = null; }

/** Cosine similarity as metric for embedding search and ranking. */

public static final int EMBEDDING_SEARCH_METRIC_TYPE_COSINE = 1; // 0x1

/**
 * Use the default metric set in {@link android.app.appsearch.SearchSpec#getDefaultEmbeddingSearchMetricType() SearchSpec.getDefaultEmbeddingSearchMetricType()} for
 * embedding search and ranking.
 */

public static final int EMBEDDING_SEARCH_METRIC_TYPE_DEFAULT = 0; // 0x0

/** Dot product similarity as metric for embedding search and ranking. */

public static final int EMBEDDING_SEARCH_METRIC_TYPE_DOT_PRODUCT = 2; // 0x2

/** Euclidean distance as metric for embedding search and ranking. */

public static final int EMBEDDING_SEARCH_METRIC_TYPE_EUCLIDEAN = 3; // 0x3

/**
 * Results should be grouped together by namespace for the purpose of enforcing a limit on the
 * number of results returned per namespace.
 */

public static final int GROUPING_TYPE_PER_NAMESPACE = 2; // 0x2

/**
 * Results should be grouped together by package for the purpose of enforcing a limit on the
 * number of results returned per package.
 */

public static final int GROUPING_TYPE_PER_PACKAGE = 1; // 0x1

/**
 * Results should be grouped together by schema type for the purpose of enforcing a limit on the
 * number of results returned per schema type.
 */

public static final int GROUPING_TYPE_PER_SCHEMA = 4; // 0x4

/** Search results will be returned in an ascending order. */

public static final int ORDER_ASCENDING = 1; // 0x1

/** Search results will be returned in a descending order. */

public static final int ORDER_DESCENDING = 0; // 0x0

/**
 * Schema type to be used in {@link android.app.appsearch.SearchSpec.Builder#addProjection SearchSpec.Builder.addProjection} to apply property paths to
 * all results, excepting any types that have had their own, specific property paths set.
 *
 * @deprecated use {@link #SCHEMA_TYPE_WILDCARD} instead.
 */

@Deprecated public static final java.lang.String PROJECTION_SCHEMA_TYPE_WILDCARD = "*";

/** Ranked by the advanced ranking expression provided. */

public static final int RANKING_STRATEGY_ADVANCED_RANKING_EXPRESSION = 9; // 0x9

/** Ranked by document creation timestamps. */

public static final int RANKING_STRATEGY_CREATION_TIMESTAMP = 2; // 0x2

/** Ranked by app-provided document scores. */

public static final int RANKING_STRATEGY_DOCUMENT_SCORE = 1; // 0x1

/**
 * Ranked by the aggregated ranking signal of the joined documents.
 *
 * <p>Which aggregation strategy is used to determine a ranking signal is specified in the
 * {@link android.app.appsearch.JoinSpec JoinSpec} set by {@link android.app.appsearch.SearchSpec.Builder#setJoinSpec Builder.setJoinSpec}. This ranking strategy may not be used if
 * no {@link android.app.appsearch.JoinSpec JoinSpec} is provided.
 *
 * @see android.app.appsearch.SearchSpec.Builder#build
 */

public static final int RANKING_STRATEGY_JOIN_AGGREGATE_SCORE = 8; // 0x8

/** No Ranking, results are returned in arbitrary order. */

public static final int RANKING_STRATEGY_NONE = 0; // 0x0

/** Ranked by document relevance score. */

public static final int RANKING_STRATEGY_RELEVANCE_SCORE = 3; // 0x3

/** Ranked by number of usages from a system UI surface. */

public static final int RANKING_STRATEGY_SYSTEM_USAGE_COUNT = 6; // 0x6

/** Ranked by timestamp of last usage from a system UI surface. */

public static final int RANKING_STRATEGY_SYSTEM_USAGE_LAST_USED_TIMESTAMP = 7; // 0x7

/** Ranked by number of usages, as reported by the app. */

public static final int RANKING_STRATEGY_USAGE_COUNT = 4; // 0x4

/** Ranked by timestamp of last usage, as reported by the app. */

public static final int RANKING_STRATEGY_USAGE_LAST_USED_TIMESTAMP = 5; // 0x5

/**
 * Schema type to be used in {@link android.app.appsearch.SearchSpec.Builder#addFilterProperties(java.lang.String,java.util.Collection) SearchSpec.Builder.addFilterProperties(String, Collection)}
 * and {@link android.app.appsearch.SearchSpec.Builder#addProjection SearchSpec.Builder.addProjection} to apply property paths to all results,
 * excepting any types that have had their own, specific property paths set.
 */

public static final java.lang.String SCHEMA_TYPE_WILDCARD = "*";

/**
 * Query terms will only match exact tokens in the index.
 *
 * <p>For example, a query term "foo" will only match indexed token "foo", and not "foot" or
 * "football".
 */

public static final int TERM_MATCH_EXACT_ONLY = 1; // 0x1

/**
 * Query terms will match indexed tokens when the query term is a prefix of the token.
 *
 * <p>For example, a query term "foo" will match indexed tokens like "foo", "foot", and
 * "football".
 */

public static final int TERM_MATCH_PREFIX = 2; // 0x2
/** Builder for {@link android.app.appsearch.SearchSpec objects}. */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

/** Constructs a new {@link android.app.appsearch.SearchSpec.Builder Builder} for {@link android.app.appsearch.SearchSpec SearchSpec} objects. */

public Builder() { throw new RuntimeException("Stub!"); }

/**
 * Constructs a new {@link android.app.appsearch.SearchSpec.Builder Builder} from the given {@link android.app.appsearch.SearchSpec SearchSpec}.
 * @param searchSpec This value cannot be {@code null}.
 */

public Builder(@android.annotation.NonNull android.app.appsearch.SearchSpec searchSpec) { throw new RuntimeException("Stub!"); }

/**
 * Adds an embedding search to {@link android.app.appsearch.SearchSpec SearchSpec} Entry, which will be referred in the query
 * expression and the ranking expression for embedding search.
 *
 * @see android.app.appsearch.AppSearchSession#search
 * @see android.app.appsearch.SearchSpec.Builder#setRankingStrategy(String)
 
 * @param searchEmbeddings This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.SearchSpec.Builder addEmbeddingParameters(@android.annotation.NonNull android.app.appsearch.EmbeddingVector... searchEmbeddings) { throw new RuntimeException("Stub!"); }

/**
 * Adds an embedding search to {@link android.app.appsearch.SearchSpec SearchSpec} Entry, which will be referred in the query
 * expression and the ranking expression for embedding search.
 *
 * @see android.app.appsearch.AppSearchSession#search
 * @see android.app.appsearch.SearchSpec.Builder#setRankingStrategy(String)
 
 * @param searchEmbeddings This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.SearchSpec.Builder addEmbeddingParameters(@android.annotation.NonNull java.util.Collection<android.app.appsearch.EmbeddingVector> searchEmbeddings) { throw new RuntimeException("Stub!"); }

/**
 * Adds a document id filter to {@link android.app.appsearch.SearchSpec SearchSpec} Entry. Only search for documents that
 * have the specified document ids.
 *
 * <p>If unset, the query will search over all documents.
 
 * @param documentIds This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.SearchSpec.Builder addFilterDocumentIds(@android.annotation.NonNull java.lang.String... documentIds) { throw new RuntimeException("Stub!"); }

/**
 * Adds a document id filter to {@link android.app.appsearch.SearchSpec SearchSpec} Entry. Only search for documents that
 * have the specified document ids.
 *
 * <p>If unset, the query will search over all documents.
 
 * @param documentIds This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.SearchSpec.Builder addFilterDocumentIds(@android.annotation.NonNull java.util.Collection<java.lang.String> documentIds) { throw new RuntimeException("Stub!"); }

/**
 * Adds a namespace filter to {@link android.app.appsearch.SearchSpec SearchSpec} Entry. Only search for documents that have
 * the specified namespaces.
 *
 * <p>If unset, the query will search over all namespaces.
 
 * @param namespaces This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.SearchSpec.Builder addFilterNamespaces(@android.annotation.NonNull java.lang.String... namespaces) { throw new RuntimeException("Stub!"); }

/**
 * Adds a namespace filter to {@link android.app.appsearch.SearchSpec SearchSpec} Entry. Only search for documents that have
 * the specified namespaces.
 *
 * <p>If unset, the query will search over all namespaces.
 
 * @param namespaces This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.SearchSpec.Builder addFilterNamespaces(@android.annotation.NonNull java.util.Collection<java.lang.String> namespaces) { throw new RuntimeException("Stub!"); }

/**
 * Adds a package name filter to {@link android.app.appsearch.SearchSpec SearchSpec} Entry. Only search for documents that
 * were indexed from the specified packages.
 *
 * <p>If unset, the query will search over all packages that the caller has access to. If
 * package names are specified which caller doesn't have access to, then those package names
 * will be ignored.
 
 * @param packageNames This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.SearchSpec.Builder addFilterPackageNames(@android.annotation.NonNull java.lang.String... packageNames) { throw new RuntimeException("Stub!"); }

/**
 * Adds a package name filter to {@link android.app.appsearch.SearchSpec SearchSpec} Entry. Only search for documents that
 * were indexed from the specified packages.
 *
 * <p>If unset, the query will search over all packages that the caller has access to. If
 * package names are specified which caller doesn't have access to, then those package names
 * will be ignored.
 
 * @param packageNames This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.SearchSpec.Builder addFilterPackageNames(@android.annotation.NonNull java.util.Collection<java.lang.String> packageNames) { throw new RuntimeException("Stub!"); }

/**
 * Adds property paths for the specified type to the property filter of {@link android.app.appsearch.SearchSpec SearchSpec}
 * Entry. Only returns documents that have matches under the specified properties. If
 * property paths are added for a type, then only the properties referred to will be
 * searched for results of that type.
 *
 * <p>If a property path that is specified isn't present in a result, it will be ignored for
 * that result. Property paths cannot be null.
 *
 * <p>If no property paths are added for a particular type, then all properties of results
 * of that type will be searched.
 *
 * <p>Example properties: 'body', 'sender.name', 'sender.emailaddress', etc.
 *
 * <p>If property paths are added for the {@link android.app.appsearch.SearchSpec#SCHEMA_TYPE_WILDCARD SearchSpec.SCHEMA_TYPE_WILDCARD}, then
 * those property paths will apply to all results, excepting any types that have their own,
 * specific property paths set.
 *
 * @param schema the {@link android.app.appsearch.AppSearchSchema AppSearchSchema} that contains the target properties
 * This value cannot be {@code null}.
 * @param propertyPaths The String version of {@link android.app.appsearch.PropertyPath PropertyPath}. A dot-delimited sequence
 *     of property names.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.SearchSpec.Builder addFilterProperties(@android.annotation.NonNull java.lang.String schema, @android.annotation.NonNull java.util.Collection<java.lang.String> propertyPaths) { throw new RuntimeException("Stub!"); }

/**
 * Adds property paths for the specified type to the property filter of {@link android.app.appsearch.SearchSpec SearchSpec}
 * Entry. Only returns documents that have matches under the specified properties. If
 * property paths are added for a type, then only the properties referred to will be
 * searched for results of that type.
 *
 * @see #addFilterProperties(String, Collection)
 * @param schema the {@link android.app.appsearch.AppSearchSchema AppSearchSchema} that contains the target properties
 * This value cannot be {@code null}.
 * @param propertyPaths The {@link android.app.appsearch.PropertyPath PropertyPath} to search search over
 
 * This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.SearchSpec.Builder addFilterPropertyPaths(@android.annotation.NonNull java.lang.String schema, @android.annotation.NonNull java.util.Collection<android.app.appsearch.PropertyPath> propertyPaths) { throw new RuntimeException("Stub!"); }

/**
 * Adds a Schema type filter to {@link android.app.appsearch.SearchSpec SearchSpec} Entry. Only search for documents that
 * have the specified schema types.
 *
 * <p>If unset, the query will search over all schema types.
 
 * @param schemas This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.SearchSpec.Builder addFilterSchemas(@android.annotation.NonNull java.lang.String... schemas) { throw new RuntimeException("Stub!"); }

/**
 * Adds a Schema type filter to {@link android.app.appsearch.SearchSpec SearchSpec} Entry. Only search for documents that
 * have the specified schema types.
 *
 * <p>If unset, the query will search over all schema types.
 
 * @param schemas This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.SearchSpec.Builder addFilterSchemas(@android.annotation.NonNull java.util.Collection<java.lang.String> schemas) { throw new RuntimeException("Stub!"); }

/**
 * Adds informational ranking expressions to be evaluated for each document in the search
 * result. The values of these expressions will be returned to the caller via {@link android.app.appsearch.SearchResult#getInformationalRankingSignals()  }. These expressions are purely for the
 * caller to retrieve additional information about the result and have no effect on ranking.
 *
 * <p>The syntax is exactly the same as specified in {@link android.app.appsearch.SearchSpec.Builder#setRankingStrategy(java.lang.String)  }.
 
 * @param informationalRankingExpressions This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.SearchSpec.Builder addInformationalRankingExpressions(@android.annotation.NonNull java.lang.String... informationalRankingExpressions) { throw new RuntimeException("Stub!"); }

/**
 * Adds informational ranking expressions to be evaluated for each document in the search
 * result. The values of these expressions will be returned to the caller via {@link android.app.appsearch.SearchResult#getInformationalRankingSignals()  }. These expressions are purely for the
 * caller to retrieve additional information about the result and have no effect on ranking.
 *
 * <p>The syntax is exactly the same as specified in {@link android.app.appsearch.SearchSpec.Builder#setRankingStrategy(java.lang.String)  }.
 
 * @param informationalRankingExpressions This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.SearchSpec.Builder addInformationalRankingExpressions(@android.annotation.NonNull java.util.Collection<java.lang.String> informationalRankingExpressions) { throw new RuntimeException("Stub!"); }

/**
 * Adds property paths for the specified type to be used for projection. If property paths
 * are added for a type, then only the properties referred to will be retrieved for results
 * of that type. If a property path that is specified isn't present in a result, it will be
 * ignored for that result. Property paths cannot be null.
 *
 * @see #addProjectionPaths
 * @param schema a string corresponding to the schema to add projections to.
 * This value cannot be {@code null}.
 * @param propertyPaths the projections to add.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.SearchSpec.Builder addProjection(@android.annotation.NonNull java.lang.String schema, @android.annotation.NonNull java.util.Collection<java.lang.String> propertyPaths) { throw new RuntimeException("Stub!"); }

/**
 * Adds property paths for the specified type to be used for projection. If property paths
 * are added for a type, then only the properties referred to will be retrieved for results
 * of that type. If a property path that is specified isn't present in a result, it will be
 * ignored for that result. Property paths cannot be null.
 *
 * <p>If no property paths are added for a particular type, then all properties of results
 * of that type will be retrieved.
 *
 * <p>If property path is added for the {@link android.app.appsearch.SearchSpec#SCHEMA_TYPE_WILDCARD SearchSpec.SCHEMA_TYPE_WILDCARD}, then those
 * property paths will apply to all results, excepting any types that have their own,
 * specific property paths set.
 *
 * <p>Suppose the following document is in the index.
 *
 * <pre>{@code
 * Email: Document {
 *   sender: Document {
 *     name: "Mr. Person"
 *     email: "mrperson123@google.com"
 *   }
 *   recipients: [
 *     Document {
 *       name: "John Doe"
 *       email: "johndoe123@google.com"
 *     }
 *     Document {
 *       name: "Jane Doe"
 *       email: "janedoe123@google.com"
 *     }
 *   ]
 *   subject: "IMPORTANT"
 *   body: "Limited time offer!"
 * }
 * }</pre>
 *
 * <p>Then, suppose that a query for "important" is issued with the following projection
 * type property paths:
 *
 * <pre>{@code
 * {schema: "Email", ["subject", "sender.name", "recipients.name"]}
 * }</pre>
 *
 * <p>The above document will be returned as:
 *
 * <pre>{@code
 * Email: Document {
 *   sender: Document {
 *     name: "Mr. Body"
 *   }
 *   recipients: [
 *     Document {
 *       name: "John Doe"
 *     }
 *     Document {
 *       name: "Jane Doe"
 *     }
 *   ]
 *   subject: "IMPORTANT"
 * }
 * }</pre>
 *
 * @param schema a string corresponding to the schema to add projections to.
 * This value cannot be {@code null}.
 * @param propertyPaths the projections to add.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.SearchSpec.Builder addProjectionPaths(@android.annotation.NonNull java.lang.String schema, @android.annotation.NonNull java.util.Collection<android.app.appsearch.PropertyPath> propertyPaths) { throw new RuntimeException("Stub!"); }

/**
 * Adds Strings to the list of String parameters that can be referenced in the query through
 * the "getSearchStringParameter({index})" function.
 *
 * @see android.app.appsearch.AppSearchSession#search
 
 * @param searchStringParameters This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.SearchSpec.Builder addSearchStringParameters(@android.annotation.NonNull java.lang.String... searchStringParameters) { throw new RuntimeException("Stub!"); }

/**
 * Adds Strings to the list of String parameters that can be referenced in the query through
 * the "getSearchStringParameter({index})" function.
 *
 * @see android.app.appsearch.AppSearchSession#search
 
 * @param searchStringParameters This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.SearchSpec.Builder addSearchStringParameters(@android.annotation.NonNull java.util.List<java.lang.String> searchStringParameters) { throw new RuntimeException("Stub!"); }

/**
 * Constructs a new {@link android.app.appsearch.SearchSpec SearchSpec} from the contents of this builder.
 *
 * @throws java.lang.IllegalArgumentException if property weights are provided with a ranking strategy
 *     that isn't RANKING_STRATEGY_RELEVANCE_SCORE.
 * @throws java.lang.IllegalStateException if the ranking strategy is {@link
 *     #RANKING_STRATEGY_JOIN_AGGREGATE_SCORE} and {@link #setJoinSpec} has never been
 *     called.
 * @throws java.lang.IllegalStateException if the aggregation scoring strategy has been set in {@link android.app.appsearch.JoinSpec#getAggregationScoringStrategy()      } but the ranking strategy is not {@link
 *     #RANKING_STRATEGY_JOIN_AGGREGATE_SCORE}.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.SearchSpec build() { throw new RuntimeException("Stub!"); }

/**
 * Clears the embedding parameters.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.SearchSpec.Builder clearEmbeddingParameters() { throw new RuntimeException("Stub!"); }

/**
 * Clears the document id filters.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.SearchSpec.Builder clearFilterDocumentIds() { throw new RuntimeException("Stub!"); }

/**
 * Clears all namespace filters.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.SearchSpec.Builder clearFilterNamespaces() { throw new RuntimeException("Stub!"); }

/**
 * Clears all package name filters.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.SearchSpec.Builder clearFilterPackageNames() { throw new RuntimeException("Stub!"); }

/**
 * Clears the property filters for all schema types.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.SearchSpec.Builder clearFilterProperties() { throw new RuntimeException("Stub!"); }

/**
 * Clears all schema type filters.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.SearchSpec.Builder clearFilterSchemas() { throw new RuntimeException("Stub!"); }

/**
 * Clears all informational ranking expressions.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.SearchSpec.Builder clearInformationalRankingExpressions() { throw new RuntimeException("Stub!"); }

/**
 * Clears the {@link android.app.appsearch.JoinSpec JoinSpec}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.SearchSpec.Builder clearJoinSpec() { throw new RuntimeException("Stub!"); }

/**
 * Clears the projections for all schema types.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.SearchSpec.Builder clearProjections() { throw new RuntimeException("Stub!"); }

/**
 * Clears the property weights for all schema types.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.SearchSpec.Builder clearPropertyWeights() { throw new RuntimeException("Stub!"); }

/**
 * Clears the result grouping and limit.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.SearchSpec.Builder clearResultGrouping() { throw new RuntimeException("Stub!"); }

/**
 * Clears the log tag that indicates the source of this search.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.SearchSpec.Builder clearSearchSourceLogTag() { throw new RuntimeException("Stub!"); }

/**
 * Clears the list of String parameters that can be referenced in the query through the
 * "getSearchStringParameter({index})" function.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.SearchSpec.Builder clearSearchStringParameters() { throw new RuntimeException("Stub!"); }

/**
 * Sets the default embedding metric type used for embedding search (see {@link android.app.appsearch.AppSearchSession#search  }) and ranking (see {@link android.app.appsearch.SearchSpec.Builder#setRankingStrategy(java.lang.String)  }).
 *
 * <p>If this method is not called, the default embedding search metric type is {@link android.app.appsearch.SearchSpec#EMBEDDING_SEARCH_METRIC_TYPE_COSINE  }. Metrics specified within
 * "semanticSearch" or "matchedSemanticScores" functions in search/ranking expressions will
 * override this default.
 
 * @param defaultEmbeddingSearchMetricType Value is {@link android.app.appsearch.SearchSpec#EMBEDDING_SEARCH_METRIC_TYPE_DEFAULT}, {@link android.app.appsearch.SearchSpec#EMBEDDING_SEARCH_METRIC_TYPE_COSINE}, {@link android.app.appsearch.SearchSpec#EMBEDDING_SEARCH_METRIC_TYPE_DOT_PRODUCT}, or {@link android.app.appsearch.SearchSpec#EMBEDDING_SEARCH_METRIC_TYPE_EUCLIDEAN}
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.SearchSpec.Builder setDefaultEmbeddingSearchMetricType(int defaultEmbeddingSearchMetricType) { throw new RuntimeException("Stub!"); }

/**
 * Specifies which documents to join with, and how to join.
 *
 * <p>If the ranking strategy is {@link #RANKING_STRATEGY_JOIN_AGGREGATE_SCORE}, and the
 * JoinSpec is null, {@link #build} will throw an {@link android.app.appsearch.exceptions.AppSearchException AppSearchException}.
 *
 * @param joinSpec a specification on how to perform the Join operation.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.SearchSpec.Builder setJoinSpec(@android.annotation.NonNull android.app.appsearch.JoinSpec joinSpec) { throw new RuntimeException("Stub!"); }

/**
 * Sets the LIST_FILTER_HAS_PROPERTY_FUNCTION feature as enabled/disabled according to the
 * enabled parameter.
 *
 * @param enabled Enables the feature if true, otherwise disables it
 *     <p>If disabled, disallows the use of the "hasProperty" function. See {@link android.app.appsearch.AppSearchSession#search      } for more details about the function.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.SearchSpec.Builder setListFilterHasPropertyFunctionEnabled(boolean enabled) { throw new RuntimeException("Stub!"); }

/**
 * Sets the LIST_FILTER_MATCH_SCORE_EXPRESSION_FUNCTION feature as enabled/disabled
 * according to the enabled parameter.
 *
 * <p>If not enabled, the use of the "matchScoreExpression" function is disallowed. See
 * {@link android.app.appsearch.AppSearchSession#search AppSearchSession.search} for more details about the function.
 *
 * @param enabled Enables the feature if true, otherwise disables it

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.SearchSpec.Builder setListFilterMatchScoreExpressionFunctionEnabled(boolean enabled) { throw new RuntimeException("Stub!"); }

/**
 * Sets the LIST_FILTER_QUERY_LANGUAGE feature as enabled/disabled according to the enabled
 * parameter.
 *
 * @param enabled Enables the feature if true, otherwise disables it.
 *     <p>This feature covers the expansion of the query language to conform to the
 *     definition of the list filters language (https://aip.dev/160). This includes:
 *     <ul>
 *       <li>addition of explicit 'AND' and 'NOT' operators
 *       <li>property restricts are allowed with grouping (ex. "prop:(a OR b)")
 *       <li>addition of custom functions to control matching
 *     </ul>
 *     <p>The newly added custom functions covered by this feature are:
 *     <ul>
 *       <li>createList(String...)
 *       <li>termSearch(String, {@code List<String>})
 *     </ul>
 *     <p>createList takes a variable number of strings and returns a list of strings. It is
 *     for use with termSearch.
 *     <p>termSearch takes a query string that will be parsed according to the supported
 *     query language and an optional list of strings that specify the properties to be
 *     restricted to. This exists as a convenience for multiple property restricts. So, for
 *     example, the query "(subject:foo OR body:foo) (subject:bar OR body:bar)" could be
 *     rewritten as "termSearch(\"foo bar\", createList(\"subject\", \"bar\"))"

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.SearchSpec.Builder setListFilterQueryLanguageEnabled(boolean enabled) { throw new RuntimeException("Stub!"); }

/**
 * Sets {@code maxSnippetSize}, the maximum snippet size. Snippet windows start at {@code
 * maxSnippetSize/2} bytes before the middle of the matching token and end at {@code
 * maxSnippetSize/2} bytes after the middle of the matching token. It respects token
 * boundaries, therefore the returned window may be smaller than requested.
 *
 * <p>Setting {@code maxSnippetSize} to 0 will disable windowing and an empty String will be
 * returned. If matches enabled is also set to false, then snippeting is disabled.
 *
 * <p>For example, {@code maxSnippetSize} = 16. "foo bar baz bat rat" with a query of "baz"
 * will return a window of "bar baz bat" which is only 11 bytes long.
 
 * @param maxSnippetSize Value is between 0 and MAX_SNIPPET_SIZE_LIMIT inclusive
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.SearchSpec.Builder setMaxSnippetSize(int maxSnippetSize) { throw new RuntimeException("Stub!"); }

/**
 * Sets the NUMERIC_SEARCH feature as enabled/disabled according to the enabled parameter.
 *
 * @param enabled Enables the feature if true, otherwise disables it.
 *     <p>If disabled, disallows use of {@link android.app.appsearch.AppSearchSchema.LongPropertyConfig#INDEXING_TYPE_RANGE      } and all other numeric
 *     querying features.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.SearchSpec.Builder setNumericSearchEnabled(boolean enabled) { throw new RuntimeException("Stub!"); }

/**
 * Sets the order of returned search results, the default is {@link #ORDER_DESCENDING},
 * meaning that results with higher scores come first.
 *
 * <p>This order field will be ignored if RankingStrategy = {@code RANKING_STRATEGY_NONE}.
 
 * @param order Value is {@link android.app.appsearch.SearchSpec#ORDER_DESCENDING}, or {@link android.app.appsearch.SearchSpec#ORDER_ASCENDING}
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.SearchSpec.Builder setOrder(int order) { throw new RuntimeException("Stub!"); }

/**
 * Sets property weights by schema type and property path.
 *
 * <p>Property weights are used to promote and demote query term matches within a {@link android.app.appsearch.GenericDocument GenericDocument} property when applying scoring.
 *
 * <p>Property weights must be positive values (greater than 0). A property's weight is
 * multiplied with that property's scoring contribution. This means weights set between 0.0
 * and 1.0 demote scoring contributions by a term match within the property. Weights set
 * above 1.0 promote scoring contributions by a term match within the property.
 *
 * <p>Properties that exist in the {@link android.app.appsearch.AppSearchSchema AppSearchSchema}, but do not have a weight
 * explicitly set will be given a default weight of 1.0.
 *
 * <p>Weights set for property paths that do not exist in the {@link android.app.appsearch.AppSearchSchema AppSearchSchema} will
 * be discarded and not affect scoring.
 *
 * <p><b>NOTE:</b> Property weights only affect scoring for query-dependent scoring
 * strategies, such as {@link #RANKING_STRATEGY_RELEVANCE_SCORE}.
 *
 * @param schemaType the schema type to set property weights for.
 * This value cannot be {@code null}.
 * @param propertyPathWeights a {@link java.util.Map Map} of property paths of the schema type to the
 *     weight to set for that property.
 * This value cannot be {@code null}.
 * @throws java.lang.IllegalArgumentException if a weight is equal to or less than 0.0.
 
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.SearchSpec.Builder setPropertyWeightPaths(@android.annotation.NonNull java.lang.String schemaType, @android.annotation.NonNull java.util.Map<android.app.appsearch.PropertyPath,java.lang.Double> propertyPathWeights) { throw new RuntimeException("Stub!"); }

/**
 * Sets property weights by schema type and property path.
 *
 * <p>Property weights are used to promote and demote query term matches within a {@link android.app.appsearch.GenericDocument GenericDocument} property when applying scoring.
 *
 * <p>Property weights must be positive values (greater than 0). A property's weight is
 * multiplied with that property's scoring contribution. This means weights set between 0.0
 * and 1.0 demote scoring contributions by a term match within the property. Weights set
 * above 1.0 promote scoring contributions by a term match within the property.
 *
 * <p>Properties that exist in the {@link android.app.appsearch.AppSearchSchema AppSearchSchema}, but do not have a weight
 * explicitly set will be given a default weight of 1.0.
 *
 * <p>Weights set for property paths that do not exist in the {@link android.app.appsearch.AppSearchSchema AppSearchSchema} will
 * be discarded and not affect scoring.
 *
 * <p><b>NOTE:</b> Property weights only affect scoring for query-dependent scoring
 * strategies, such as {@link #RANKING_STRATEGY_RELEVANCE_SCORE}.
 *
 * @param schemaType the schema type to set property weights for.
 * This value cannot be {@code null}.
 * @param propertyPathWeights a {@link java.util.Map Map} of property paths of the schema type to the
 *     weight to set for that property.
 * This value cannot be {@code null}.
 * @throws java.lang.IllegalArgumentException if a weight is equal to or less than 0.0.
 
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.SearchSpec.Builder setPropertyWeights(@android.annotation.NonNull java.lang.String schemaType, @android.annotation.NonNull java.util.Map<java.lang.String,java.lang.Double> propertyPathWeights) { throw new RuntimeException("Stub!"); }

/**
 * Sets ranking strategy for AppSearch results.
 * @param rankingStrategy Value is {@link android.app.appsearch.SearchSpec#RANKING_STRATEGY_NONE}, {@link android.app.appsearch.SearchSpec#RANKING_STRATEGY_DOCUMENT_SCORE}, {@link android.app.appsearch.SearchSpec#RANKING_STRATEGY_CREATION_TIMESTAMP}, {@link android.app.appsearch.SearchSpec#RANKING_STRATEGY_RELEVANCE_SCORE}, {@link android.app.appsearch.SearchSpec#RANKING_STRATEGY_USAGE_COUNT}, {@link android.app.appsearch.SearchSpec#RANKING_STRATEGY_USAGE_LAST_USED_TIMESTAMP}, {@link android.app.appsearch.SearchSpec#RANKING_STRATEGY_SYSTEM_USAGE_COUNT}, {@link android.app.appsearch.SearchSpec#RANKING_STRATEGY_SYSTEM_USAGE_LAST_USED_TIMESTAMP}, {@link android.app.appsearch.SearchSpec#RANKING_STRATEGY_JOIN_AGGREGATE_SCORE}, or {@link android.app.appsearch.SearchSpec#RANKING_STRATEGY_ADVANCED_RANKING_EXPRESSION}
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.SearchSpec.Builder setRankingStrategy(int rankingStrategy) { throw new RuntimeException("Stub!"); }

/**
 * Enables advanced ranking to score based on {@code advancedRankingExpression}.
 *
 * <p>This method will set RankingStrategy to {@link
 * #RANKING_STRATEGY_ADVANCED_RANKING_EXPRESSION}.
 *
 * <p>The ranking expression is a mathematical expression that will be evaluated to a
 * floating-point number of double type representing the score of each document.
 *
 * <p>Numeric literals, arithmetic operators, mathematical functions, document-based, and
 * property-value-based functions are supported to build expressions.
 *
 * <p>The following are supported arithmetic operators:
 *
 * <ul>
 *   <li>Addition(+)
 *   <li>Subtraction(-)
 *   <li>Multiplication(*)
 *   <li>Floating Point Division(/)
 * </ul>
 *
 * <p>Operator precedences are compliant with the Java Language, and parentheses are
 * supported. For example, "2.2 + (3 - 4) / 2" evaluates to 1.7.
 *
 * <p>The following are supported basic mathematical functions:
 *
 * <ul>
 *   <li>log(x) - the natural log of x
 *   <li>log(x, y) - the log of y with base x
 *   <li>pow(x, y) - x to the power of y
 *   <li>sqrt(x)
 *   <li>abs(x)
 *   <li>sin(x), cos(x), tan(x)
 *   <li>Example: "max(abs(-100), 10) + pow(2, 10)" will be evaluated to 1124
 * </ul>
 *
 * <p>The following variadic mathematical functions are supported, with n > 0. They also
 * accept list value parameters. For example, if V is a value of list type, we can call
 * sum(V) to get the sum of all the values in V. List literals are not supported, so a value
 * of list type can only be constructed as a return value of some particular document-based
 * functions.
 *
 * <ul>
 *   <li>max(v1, v2, ..., vn) or max(V)
 *   <li>min(v1, v2, ..., vn) or min(V)
 *   <li>len(v1, v2, ..., vn) or len(V)
 *   <li>sum(v1, v2, ..., vn) or sum(V)
 *   <li>avg(v1, v2, ..., vn) or avg(V)
 * </ul>
 *
 * <p>Document-based functions must be called via "this", which represents the current
 * document being scored. The following are supported document-based functions:
 *
 * <ul>
 *   <li>this.documentScore()
 *       <p>Get the app-provided document score of the current document. This is the same
 *       score that is returned for {@link #RANKING_STRATEGY_DOCUMENT_SCORE}.
 *   <li>this.creationTimestamp()
 *       <p>Get the creation timestamp of the current document. This is the same score that
 *       is returned for {@link #RANKING_STRATEGY_CREATION_TIMESTAMP}.
 *   <li>this.relevanceScore()
 *       <p>Get the BM25F relevance score of the current document in relation to the query
 *       string. This is the same score that is returned for {@link
 *       #RANKING_STRATEGY_RELEVANCE_SCORE}.
 *   <li>this.usageCount(type) and this.usageLastUsedTimestamp(type)
 *       <p>Get the number of usages or the timestamp of last usage by type for the current
 *       document, where type must be evaluated to an integer from 1 to 2. Type 1 refers to
 *       usages reported by {@link android.app.appsearch.AppSearchSession#reportUsage AppSearchSession.reportUsage}, and type 2 refers to
 *       usages reported by {@link android.app.appsearch.GlobalSearchSession#reportSystemUsage GlobalSearchSession.reportSystemUsage}.
 *   <li>this.childrenRankingSignals()
 *       <p>Returns a list of children ranking signals calculated by scoring the joined
 *       documents using the ranking strategy specified in the nested {@link android.app.appsearch.SearchSpec SearchSpec}.
 *       Currently, a document can only be a child of another document in the context of
 *       joins. If this function is called without the Join API enabled, a type error will
 *       be raised.
 *   <li>this.propertyWeights()
 *       <p>Returns a list of the normalized weights of the matched properties for the
 *       current document being scored. Property weights come from what's specified in
 *       {@link android.app.appsearch.SearchSpec SearchSpec}. After normalizing, each provided weight will be divided by the
 *       maximum weight, so that each of them will be <= 1.
 *   <li>this.matchedSemanticScores(getEmbeddingParameter({embedding_index}), {metric})
 *       <p>Returns a list of the matched similarity scores from "semanticSearch" in the
 *       query expression (see also {@link android.app.appsearch.AppSearchSession#search AppSearchSession.search}) based on
 *       embedding_index and metric. If metric is omitted, it defaults to the metric
 *       specified in {@link android.app.appsearch.SearchSpec.Builder#setDefaultEmbeddingSearchMetricType(int) SearchSpec.Builder.setDefaultEmbeddingSearchMetricType(int)}.
 *       If no "semanticSearch" is called for embedding_index and metric in the query, this
 *       function will return an empty list. If multiple "semanticSearch"s are called for
 *       the same embedding_index and metric, this function will return a list of their
 *       merged scores.
 *       <p>Example: `this.matchedSemanticScores(getEmbeddingParameter(0), "COSINE")` will
 *       return a list of matched scores within the range of [0.5, 1], if
 *       `semanticSearch(getEmbeddingParameter(0), 0.5, 1, "COSINE")` is called in the query
 *       expression.
 * </ul>
 *
 * <p>Property-value-based functions can be called via the function of
 * getScorableProperty(schemaType, propertyPath)
 *
 * <ul>
 *   <li>In order to use this function, ScorablePropertyRanking feature must be enabled via
 *       {@link android.app.appsearch.SearchSpec.Builder#setScorablePropertyRankingEnabled(boolean) SearchSpec.Builder.setScorablePropertyRankingEnabled(boolean)}.
 *   <li>Param 'schemaType' must be a valid AppSearch SchemaType otherwise an error is
 *       returned.
 *   <li>Param 'propertyPath' must be valid and scorable otherwise an error is returned. It
 *       is considered scorable when:
 *       <ul>
 *         <li>It is to a property that is set to be enabled for scoring, or that
 *         <li>It points to a scorable property of nested schema types.
 *       </ul>
 *   <li>This function returns a list double values for the matched documents.
 *       <ul>
 *         <li>If the matched document's schema is different from 'schemaType', or the
 *             property under the 'propertyPath' holds no element, an empty list is
 *             returned.
 *       </ul>
 *   <li>Some examples below:
 *       <p>Suppose that there are two schemas: 'Gmail' and 'Person'. 'Gmail' schema has a
 *       property 'recipient' with schema type 'Person'. In the advanced ranking expression,
 *       you can have:
 *       <ul>
 *         <li>"sum(getScorableProperty('Gmail', 'viewTimes'))"
 *         <li>"maxOrDefault(getScorableProperty('Person', 'income'), 0)"
 *         <li>"sum(getScorableProperty('Gmail', 'recipient.income'))"
 *         <li>"this.documentScore() + sum(getScorableProperty('Gmail', 'viewTimes'))"
 *       </ul>
 * </ul>
 *
 * <p>The following functions are provided for enhanced list manipulation.
 *
 * <ul>
 *   <li>minOrDefault(V, default_score)
 *       <p>Returns the minimum value in the input list V or the default_score if the list
 *       is empty.
 *       <p>Example: "minOrDefault(this.matchedSemanticScores(getEmbeddingParameter(0)),
 *       10)" will return the minimum matched semantic scores or 10 if there is no matched
 *       score for the current document.
 *       <p>This function requires the feature {@link
 *       Features#SEARCH_SPEC_RANKING_FUNCTION_MAX_MIN_OR_DEFAULT}.
 *   <li>maxOrDefault(V, default_score)
 *       <p>Returns the maximum value in the input list V or the default_score if the list
 *       is empty.
 *       <p>Example: "maxOrDefault(this.matchedSemanticScores(getEmbeddingParameter(0)),
 *       -10)" will return the maximum matched semantic scores or -10 if there is no matched
 *       score for the current document.
 *       <p>This function requires the feature {@link
 *       Features#SEARCH_SPEC_RANKING_FUNCTION_MAX_MIN_OR_DEFAULT}.
 *   <li>filterByRange(V, low, high)
 *       <p>Returns a sublist of V that only contains the elements that fall within the
 *       specified range [low, high].
 *       <p>Example: "filterByRange(this.matchedSemanticScores(getEmbeddingParameter(0)), 0,
 *       1)" will return a list of matched semantic scores that are between 0 and 1,
 *       inclusive.
 *       <p>This function requires the feature {@link
 *       Features#SEARCH_SPEC_RANKING_FUNCTION_FILTER_BY_RANGE}.
 * </ul>
 *
 * <p>Some errors may occur when using advanced ranking.
 *
 * <p>Syntax Error: the expression violates the syntax of the advanced ranking language.
 * Below are some examples.
 *
 * <ul>
 *   <li>"1 + " - missing operand
 *   <li>"2 * (1 + 2))" - unbalanced parenthesis
 *   <li>"2 ^ 3" - unknown operator
 * </ul>
 *
 * <p>Type Error: the expression fails a static type check. Below are some examples.
 *
 * <ul>
 *   <li>"sin(2, 3)" - wrong number of arguments for the sin function
 *   <li>"this.childrenRankingSignals() + 1" - cannot add a list with a number
 *   <li>"this.propertyWeights()" - the final type of the overall expression cannot be a
 *       list, which can be fixed by "max(this.propertyWeights())"
 *   <li>"abs(this.propertyWeights())" - the abs function does not support list type
 *       arguments
 *   <li>"print(2)" - unknown function
 * </ul>
 *
 * <p>Evaluation Error: an error occurred while evaluating the value of the expression.
 * Below are some examples.
 *
 * <ul>
 *   <li>"1 / 0", "log(0)", "1 + sqrt(-1)" - getting a non-finite value in the middle of
 *       evaluation
 *   <li>"this.usageCount(1 + 0.5)" - expect the argument to be an integer. Note that this
 *       is not a type error and "this.usageCount(1.5 + 1/2)" can succeed without any issues
 *   <li>"this.documentScore()" - in case of an IO error, this will be an evaluation error
 * </ul>
 *
 * <p>Syntax errors and type errors will fail the entire search and will cause {@link android.app.appsearch.SearchResults#getNextPage  } to throw an {@link android.app.appsearch.exceptions.AppSearchException AppSearchException} with the result code of
 * {@link android.app.appsearch.AppSearchResult#RESULT_INVALID_ARGUMENT AppSearchResult.RESULT_INVALID_ARGUMENT}.
 *
 * <p>Evaluation errors will result in the offending documents receiving the default score.
 * For {@link #ORDER_DESCENDING}, the default score will be 0, for {@link #ORDER_ASCENDING}
 * the default score will be infinity.
 *
 * @param advancedRankingExpression a non-empty string representing the ranking expression.
 
 * This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.SearchSpec.Builder setRankingStrategy(@android.annotation.NonNull java.lang.String advancedRankingExpression) { throw new RuntimeException("Stub!"); }

/**
 * Sets the number of results per page in the returned object.
 *
 * <p>The default number of results per page is 10.
 
 * @param resultCountPerPage Value is between 0 and MAX_NUM_PER_PAGE inclusive
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.SearchSpec.Builder setResultCountPerPage(int resultCountPerPage) { throw new RuntimeException("Stub!"); }

/**
 * Sets the maximum number of results to return for each group, where groups are defined by
 * grouping type.
 *
 * <p>Calling this method will override any previous calls. So calling {@code
 * setResultGrouping(GROUPING_TYPE_PER_PACKAGE, 7)} and then calling {@code
 * setResultGrouping(GROUPING_TYPE_PER_PACKAGE, 2)} will result in only the latter, a limit
 * of two results per package, being applied. Or calling {@code setResultGrouping
 * (GROUPING_TYPE_PER_PACKAGE, 1)} and then calling {@code setResultGrouping
 * (GROUPING_TYPE_PER_PACKAGE | GROUPING_PER_NAMESPACE, 5)} will result in five results per
 * package per namespace.
 *
 * @param groupingTypeFlags One or more combination of grouping types.
 * Value is either <code>0</code> or a combination of {@link android.app.appsearch.SearchSpec#GROUPING_TYPE_PER_PACKAGE}, {@link android.app.appsearch.SearchSpec#GROUPING_TYPE_PER_NAMESPACE}, and {@link android.app.appsearch.SearchSpec#GROUPING_TYPE_PER_SCHEMA}
 * @param limit Number of results to return per {@code groupingTypeFlags}.
 * @throws java.lang.IllegalArgumentException if groupingTypeFlags is zero.
 
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.SearchSpec.Builder setResultGrouping(int groupingTypeFlags, int limit) { throw new RuntimeException("Stub!"); }

/**
 * Sets the ScorablePropertyRanking feature as enabled or disabled.
 *
 * <p>If enabled, 'getScorableProperty' function can be used in the advanced ranking
 * expression. For details, see {@link android.app.appsearch.SearchSpec.Builder#setRankingStrategy(java.lang.String) SearchSpec.Builder.setRankingStrategy(String)}.
 *
 * @param enabled Enables the feature if true, otherwise disables it.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.SearchSpec.Builder setScorablePropertyRankingEnabled(boolean enabled) { throw new RuntimeException("Stub!"); }

/**
 * Sets an optional log tag to indicate the source of this search.
 *
 * <p>Some AppSearch implementations may log a hash of this tag using statsd. This tag may
 * be used for tracing performance issues and crashes to a component of an app.
 *
 * <p>Call this method and give a unique value if you want to distinguish this search
 * scenario with other search scenarios during performance analysis.
 *
 * <p>Under no circumstances will AppSearch log the raw String value using statsd, but it
 * will be provided as-is to custom {@code AppSearchLogger} implementations you have
 * registered in your app.
 *
 * @param searchSourceLogTag A String to indicate the source caller of this search. It is
 *     used to label the search statsd for performance analysis. It is not the tag we are
 *     using in {@link android.util.Log}. The length of the teg should between 1 and 100.
 
 * This value cannot be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.SearchSpec.Builder setSearchSourceLogTag(@android.annotation.NonNull java.lang.String searchSourceLogTag) { throw new RuntimeException("Stub!"); }

/**
 * Sets the {@code snippetCount} such that the first {@code snippetCount} documents based on
 * the ranking strategy will have snippet information provided.
 *
 * <p>The list returned from {@link android.app.appsearch.SearchResult#getMatchInfos SearchResult.getMatchInfos} will contain at most this
 * many entries.
 *
 * <p>If set to 0 (default), snippeting is disabled and the list returned from {@link android.app.appsearch.SearchResult#getMatchInfos  } will be empty.
 
 * @param snippetCount Value is between 0 and MAX_SNIPPET_COUNT inclusive
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.SearchSpec.Builder setSnippetCount(int snippetCount) { throw new RuntimeException("Stub!"); }

/**
 * Sets {@code snippetCountPerProperty}. Only the first {@code snippetCountPerProperty}
 * snippets for each property of each {@link android.app.appsearch.GenericDocument GenericDocument} will contain snippet
 * information.
 *
 * <p>If set to 0, snippeting is disabled and the list returned from {@link android.app.appsearch.SearchResult#getMatchInfos  } will be empty.
 *
 * <p>The default behavior is to snippet all matches a property contains, up to the maximum
 * value of 10,000.
 
 * @param snippetCountPerProperty Value is between 0 and MAX_SNIPPET_PER_PROPERTY_COUNT inclusive
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.SearchSpec.Builder setSnippetCountPerProperty(int snippetCountPerProperty) { throw new RuntimeException("Stub!"); }

/**
 * Sets how the query terms should match {@code TermMatchCode} in the index.
 *
 * <p>If this method is not called, the default term match type is {@link android.app.appsearch.SearchSpec#TERM_MATCH_PREFIX  }.
 
 * @param termMatchType Value is {@link android.app.appsearch.SearchSpec#TERM_MATCH_EXACT_ONLY}, or {@link android.app.appsearch.SearchSpec#TERM_MATCH_PREFIX}
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.SearchSpec.Builder setTermMatch(int termMatchType) { throw new RuntimeException("Stub!"); }

/**
 * Sets the VERBATIM_SEARCH feature as enabled/disabled according to the enabled parameter.
 *
 * @param enabled Enables the feature if true, otherwise disables it
 *     <p>If disabled, disallows use of {@link android.app.appsearch.AppSearchSchema.StringPropertyConfig#TOKENIZER_TYPE_VERBATIM      } and all other verbatim
 *     search features within the query language that allows clients to search using the
 *     verbatim string operator.
 *     <p>For example, The verbatim string operator '"foo/bar" OR baz' will ensure that
 *     'foo/bar' is treated as a single 'verbatim' token.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.app.appsearch.SearchSpec.Builder setVerbatimSearchEnabled(boolean enabled) { throw new RuntimeException("Stub!"); }
}

}

