/*
 * Copyright 2018 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.bluetooth;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class BluetoothHearingAid implements android.bluetooth.BluetoothProfile {

BluetoothHearingAid() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.bluetooth.BluetoothHearingAid.AdvertisementServiceData getAdvertisementServiceData(@android.annotation.NonNull android.bluetooth.BluetoothDevice device) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.List<android.bluetooth.BluetoothDevice> getConnectedDevices() { throw new RuntimeException("Stub!"); }

public int getConnectionPolicy(@android.annotation.NonNull android.bluetooth.BluetoothDevice device) { throw new RuntimeException("Stub!"); }

public int getConnectionState(@android.annotation.NonNull android.bluetooth.BluetoothDevice device) { throw new RuntimeException("Stub!"); }

public int getDeviceMode(@android.annotation.NonNull android.bluetooth.BluetoothDevice device) { throw new RuntimeException("Stub!"); }

public int getDeviceSide(@android.annotation.NonNull android.bluetooth.BluetoothDevice device) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.List<android.bluetooth.BluetoothDevice> getDevicesMatchingConnectionStates(@android.annotation.NonNull int[] states) { throw new RuntimeException("Stub!"); }

public long getHiSyncId(@android.annotation.NonNull android.bluetooth.BluetoothDevice device) { throw new RuntimeException("Stub!"); }

public boolean setConnectionPolicy(@android.annotation.NonNull android.bluetooth.BluetoothDevice device, int connectionPolicy) { throw new RuntimeException("Stub!"); }

public void setVolume(int volume) { throw new RuntimeException("Stub!"); }

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.BROADCAST_INTENT_ACTION) public static final java.lang.String ACTION_ACTIVE_DEVICE_CHANGED = "android.bluetooth.hearingaid.profile.action.ACTIVE_DEVICE_CHANGED";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.BROADCAST_INTENT_ACTION) public static final java.lang.String ACTION_CONNECTION_STATE_CHANGED = "android.bluetooth.hearingaid.profile.action.CONNECTION_STATE_CHANGED";

public static final long HI_SYNC_ID_INVALID = 0L; // 0x0L

public static final int MODE_BINAURAL = 1; // 0x1

public static final int MODE_MONAURAL = 0; // 0x0

public static final int MODE_UNKNOWN = -1; // 0xffffffff

public static final int SIDE_LEFT = 0; // 0x0

public static final int SIDE_RIGHT = 1; // 0x1

public static final int SIDE_UNKNOWN = -1; // 0xffffffff
@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class AdvertisementServiceData implements android.os.Parcelable {

AdvertisementServiceData() { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

public int getDeviceMode() { throw new RuntimeException("Stub!"); }

public int getDeviceSide() { throw new RuntimeException("Stub!"); }

public int getTruncatedHiSyncId() { throw new RuntimeException("Stub!"); }

public boolean isCsipSupported() { throw new RuntimeException("Stub!"); }

public boolean isInPairWith(@android.annotation.Nullable android.bluetooth.BluetoothHearingAid.AdvertisementServiceData data) { throw new RuntimeException("Stub!"); }

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.bluetooth.BluetoothHearingAid.AdvertisementServiceData> CREATOR;
static { CREATOR = null; }
}

}

