/*
 * Copyright 2020 HIMSA II K/S - www.himsa.com.
 * Represented by EHIMA - www.ehima.com
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.bluetooth;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class BluetoothLeAudio implements java.lang.AutoCloseable, android.bluetooth.BluetoothProfile {

BluetoothLeAudio() { throw new RuntimeException("Stub!"); }

public void close() { throw new RuntimeException("Stub!"); }

protected void finalize() { throw new RuntimeException("Stub!"); }

public int getAudioLocation(@android.annotation.NonNull android.bluetooth.BluetoothDevice device) { throw new RuntimeException("Stub!"); }

public int getBroadcastToUnicastFallbackGroup() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.bluetooth.BluetoothLeAudioCodecStatus getCodecStatus(int groupId) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.List<android.bluetooth.BluetoothDevice> getConnectedDevices() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.bluetooth.BluetoothDevice getConnectedGroupLeadDevice(int groupId) { throw new RuntimeException("Stub!"); }

public int getConnectionPolicy(@android.annotation.Nullable android.bluetooth.BluetoothDevice device) { throw new RuntimeException("Stub!"); }

public int getConnectionState(@android.annotation.NonNull android.bluetooth.BluetoothDevice device) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.List<android.bluetooth.BluetoothDevice> getDevicesMatchingConnectionStates(@android.annotation.NonNull int[] states) { throw new RuntimeException("Stub!"); }

public int getGroupId(@android.annotation.NonNull android.bluetooth.BluetoothDevice device) { throw new RuntimeException("Stub!"); }

public boolean isInbandRingtoneEnabled(int groupId) { throw new RuntimeException("Stub!"); }

public void registerCallback(@android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.bluetooth.BluetoothLeAudio.Callback callback) { throw new RuntimeException("Stub!"); }

public void setBroadcastToUnicastFallbackGroup(int groupId) { throw new RuntimeException("Stub!"); }

public void setCodecConfigPreference(int groupId, @android.annotation.NonNull android.bluetooth.BluetoothLeAudioCodecConfig inputCodecConfig, @android.annotation.NonNull android.bluetooth.BluetoothLeAudioCodecConfig outputCodecConfig) { throw new RuntimeException("Stub!"); }

public boolean setConnectionPolicy(@android.annotation.NonNull android.bluetooth.BluetoothDevice device, int connectionPolicy) { throw new RuntimeException("Stub!"); }

public void setVolume(int volume) { throw new RuntimeException("Stub!"); }

public void unregisterCallback(@android.annotation.NonNull android.bluetooth.BluetoothLeAudio.Callback callback) { throw new RuntimeException("Stub!"); }

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.BROADCAST_INTENT_ACTION) public static final java.lang.String ACTION_LE_AUDIO_ACTIVE_DEVICE_CHANGED = "android.bluetooth.action.LE_AUDIO_ACTIVE_DEVICE_CHANGED";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.BROADCAST_INTENT_ACTION) public static final java.lang.String ACTION_LE_AUDIO_CONNECTION_STATE_CHANGED = "android.bluetooth.action.LE_AUDIO_CONNECTION_STATE_CHANGED";

public static final int AUDIO_LOCATION_BACK_CENTER = 256; // 0x100

public static final int AUDIO_LOCATION_BACK_LEFT = 16; // 0x10

public static final int AUDIO_LOCATION_BACK_RIGHT = 32; // 0x20

public static final int AUDIO_LOCATION_BOTTOM_FRONT_CENTER = 2097152; // 0x200000

public static final int AUDIO_LOCATION_BOTTOM_FRONT_LEFT = 4194304; // 0x400000

public static final int AUDIO_LOCATION_BOTTOM_FRONT_RIGHT = 8388608; // 0x800000

public static final int AUDIO_LOCATION_FRONT_CENTER = 4; // 0x4

public static final int AUDIO_LOCATION_FRONT_LEFT = 1; // 0x1

public static final int AUDIO_LOCATION_FRONT_LEFT_OF_CENTER = 64; // 0x40

public static final int AUDIO_LOCATION_FRONT_LEFT_WIDE = 16777216; // 0x1000000

public static final int AUDIO_LOCATION_FRONT_RIGHT = 2; // 0x2

public static final int AUDIO_LOCATION_FRONT_RIGHT_OF_CENTER = 128; // 0x80

public static final int AUDIO_LOCATION_FRONT_RIGHT_WIDE = 33554432; // 0x2000000

@Deprecated public static final int AUDIO_LOCATION_INVALID = 0; // 0x0

public static final int AUDIO_LOCATION_LEFT_SURROUND = 67108864; // 0x4000000

public static final int AUDIO_LOCATION_LOW_FREQ_EFFECTS_ONE = 8; // 0x8

public static final int AUDIO_LOCATION_LOW_FREQ_EFFECTS_TWO = 512; // 0x200

public static final int AUDIO_LOCATION_MONO = 0; // 0x0

public static final int AUDIO_LOCATION_RIGHT_SURROUND = 134217728; // 0x8000000

public static final int AUDIO_LOCATION_SIDE_LEFT = 1024; // 0x400

public static final int AUDIO_LOCATION_SIDE_RIGHT = 2048; // 0x800

public static final int AUDIO_LOCATION_TOP_BACK_CENTER = 1048576; // 0x100000

public static final int AUDIO_LOCATION_TOP_BACK_LEFT = 65536; // 0x10000

public static final int AUDIO_LOCATION_TOP_BACK_RIGHT = 131072; // 0x20000

public static final int AUDIO_LOCATION_TOP_CENTER = 32768; // 0x8000

public static final int AUDIO_LOCATION_TOP_FRONT_CENTER = 16384; // 0x4000

public static final int AUDIO_LOCATION_TOP_FRONT_LEFT = 4096; // 0x1000

public static final int AUDIO_LOCATION_TOP_FRONT_RIGHT = 8192; // 0x2000

public static final int AUDIO_LOCATION_TOP_SIDE_LEFT = 262144; // 0x40000

public static final int AUDIO_LOCATION_TOP_SIDE_RIGHT = 524288; // 0x80000

public static final int AUDIO_LOCATION_UNKNOWN = -2147483648; // 0x80000000

public static final java.lang.String EXTRA_LE_AUDIO_GROUP_ID = "android.bluetooth.extra.LE_AUDIO_GROUP_ID";

public static final int GROUP_ID_INVALID = -1; // 0xffffffff

public static final int GROUP_STREAM_STATUS_IDLE = 0; // 0x0

public static final int GROUP_STREAM_STATUS_STREAMING = 1; // 0x1
@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface Callback {

public default void onBroadcastToUnicastFallbackGroupChanged(int groupId) { throw new RuntimeException("Stub!"); }

public void onCodecConfigChanged(int groupId, @android.annotation.NonNull android.bluetooth.BluetoothLeAudioCodecStatus status);

public void onGroupNodeAdded(@android.annotation.NonNull android.bluetooth.BluetoothDevice device, int groupId);

public void onGroupNodeRemoved(@android.annotation.NonNull android.bluetooth.BluetoothDevice device, int groupId);

public void onGroupStatusChanged(int groupId, int groupStatus);

public default void onGroupStreamStatusChanged(int groupId, int groupStreamStatus) { throw new RuntimeException("Stub!"); }
}

}

