/*
 * Copyright 2021 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at:
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.bluetooth;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class BluetoothLeBroadcast implements java.lang.AutoCloseable, android.bluetooth.BluetoothProfile {

BluetoothLeBroadcast() { throw new RuntimeException("Stub!"); }

public void close() { throw new RuntimeException("Stub!"); }

protected void finalize() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.List<android.bluetooth.BluetoothLeBroadcastMetadata> getAllBroadcastMetadata() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.List<android.bluetooth.BluetoothDevice> getConnectedDevices() { throw new RuntimeException("Stub!"); }

public int getConnectionState(@android.annotation.NonNull android.bluetooth.BluetoothDevice device) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.List<android.bluetooth.BluetoothDevice> getDevicesMatchingConnectionStates(@android.annotation.NonNull int[] states) { throw new RuntimeException("Stub!"); }

public int getMaximumNumberOfBroadcasts() { throw new RuntimeException("Stub!"); }

public int getMaximumStreamsPerBroadcast() { throw new RuntimeException("Stub!"); }

public int getMaximumSubgroupsPerBroadcast() { throw new RuntimeException("Stub!"); }

public boolean isPlaying(int broadcastId) { throw new RuntimeException("Stub!"); }

public void registerCallback(@android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.bluetooth.BluetoothLeBroadcast.Callback callback) { throw new RuntimeException("Stub!"); }

public void startBroadcast(@android.annotation.NonNull android.bluetooth.BluetoothLeAudioContentMetadata contentMetadata, @android.annotation.Nullable byte[] broadcastCode) { throw new RuntimeException("Stub!"); }

public void startBroadcast(@android.annotation.NonNull android.bluetooth.BluetoothLeBroadcastSettings broadcastSettings) { throw new RuntimeException("Stub!"); }

public void stopBroadcast(int broadcastId) { throw new RuntimeException("Stub!"); }

public void unregisterCallback(@android.annotation.NonNull android.bluetooth.BluetoothLeBroadcast.Callback callback) { throw new RuntimeException("Stub!"); }

public void updateBroadcast(int broadcastId, @android.annotation.NonNull android.bluetooth.BluetoothLeAudioContentMetadata contentMetadata) { throw new RuntimeException("Stub!"); }

public void updateBroadcast(int broadcastId, @android.annotation.NonNull android.bluetooth.BluetoothLeBroadcastSettings broadcastSettings) { throw new RuntimeException("Stub!"); }
@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface Callback {

public void onBroadcastMetadataChanged(int broadcastId, @android.annotation.NonNull android.bluetooth.BluetoothLeBroadcastMetadata metadata);

public void onBroadcastStartFailed(int reason);

public void onBroadcastStarted(int reason, int broadcastId);

public void onBroadcastStopFailed(int reason);

public void onBroadcastStopped(int reason, int broadcastId);

public void onBroadcastUpdateFailed(int reason, int broadcastId);

public void onBroadcastUpdated(int reason, int broadcastId);

public void onPlaybackStarted(int reason, int broadcastId);

public void onPlaybackStopped(int reason, int broadcastId);
}

}

