/*
 * Copyright (C) 2016 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.bluetooth;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class BluetoothCodecConfig implements android.os.Parcelable {

BluetoothCodecConfig() { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

public boolean equals(@android.annotation.Nullable java.lang.Object o) { throw new RuntimeException("Stub!"); }

public int getBitsPerSample() { throw new RuntimeException("Stub!"); }

public int getChannelMode() { throw new RuntimeException("Stub!"); }

public int getCodecPriority() { throw new RuntimeException("Stub!"); }

public long getCodecSpecific1() { throw new RuntimeException("Stub!"); }

public long getCodecSpecific2() { throw new RuntimeException("Stub!"); }

public long getCodecSpecific3() { throw new RuntimeException("Stub!"); }

public long getCodecSpecific4() { throw new RuntimeException("Stub!"); }

@Deprecated
public int getCodecType() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.bluetooth.BluetoothCodecType getExtendedCodecType() { throw new RuntimeException("Stub!"); }

public int getSampleRate() { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }

public boolean isMandatoryCodec() { throw new RuntimeException("Stub!"); }

public java.lang.String toString() { throw new RuntimeException("Stub!"); }

public void writeToParcel(android.os.Parcel out, int flags) { throw new RuntimeException("Stub!"); }

public static final int BITS_PER_SAMPLE_16 = 1; // 0x1

public static final int BITS_PER_SAMPLE_24 = 2; // 0x2

public static final int BITS_PER_SAMPLE_32 = 4; // 0x4

public static final int BITS_PER_SAMPLE_NONE = 0; // 0x0

public static final int CHANNEL_MODE_MONO = 1; // 0x1

public static final int CHANNEL_MODE_NONE = 0; // 0x0

public static final int CHANNEL_MODE_STEREO = 2; // 0x2

public static final int CODEC_PRIORITY_DEFAULT = 0; // 0x0

public static final int CODEC_PRIORITY_DISABLED = -1; // 0xffffffff

public static final int CODEC_PRIORITY_HIGHEST = 1000000; // 0xf4240

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.bluetooth.BluetoothCodecConfig> CREATOR;
static { CREATOR = null; }

public static final int SAMPLE_RATE_176400 = 16; // 0x10

public static final int SAMPLE_RATE_192000 = 32; // 0x20

public static final int SAMPLE_RATE_44100 = 1; // 0x1

public static final int SAMPLE_RATE_48000 = 2; // 0x2

public static final int SAMPLE_RATE_88200 = 4; // 0x4

public static final int SAMPLE_RATE_96000 = 8; // 0x8

public static final int SAMPLE_RATE_NONE = 0; // 0x0

@Deprecated public static final int SOURCE_CODEC_TYPE_AAC = 1; // 0x1

@Deprecated public static final int SOURCE_CODEC_TYPE_APTX = 2; // 0x2

@Deprecated public static final int SOURCE_CODEC_TYPE_APTX_HD = 3; // 0x3

@Deprecated public static final int SOURCE_CODEC_TYPE_INVALID = 1000000; // 0xf4240

@Deprecated public static final int SOURCE_CODEC_TYPE_LC3 = 5; // 0x5

@Deprecated public static final int SOURCE_CODEC_TYPE_LDAC = 4; // 0x4

@Deprecated public static final int SOURCE_CODEC_TYPE_OPUS = 6; // 0x6

@Deprecated public static final int SOURCE_CODEC_TYPE_SBC = 0; // 0x0
@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

public Builder() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.bluetooth.BluetoothCodecConfig build() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.bluetooth.BluetoothCodecConfig.Builder setBitsPerSample(int bitsPerSample) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.bluetooth.BluetoothCodecConfig.Builder setChannelMode(int channelMode) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.bluetooth.BluetoothCodecConfig.Builder setCodecPriority(int codecPriority) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.bluetooth.BluetoothCodecConfig.Builder setCodecSpecific1(long codecSpecific1) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.bluetooth.BluetoothCodecConfig.Builder setCodecSpecific2(long codecSpecific2) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.bluetooth.BluetoothCodecConfig.Builder setCodecSpecific3(long codecSpecific3) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.bluetooth.BluetoothCodecConfig.Builder setCodecSpecific4(long codecSpecific4) { throw new RuntimeException("Stub!"); }

@Deprecated
@android.annotation.NonNull
public android.bluetooth.BluetoothCodecConfig.Builder setCodecType(int codecType) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.bluetooth.BluetoothCodecConfig.Builder setExtendedCodecType(@android.annotation.Nullable android.bluetooth.BluetoothCodecType codecType) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.bluetooth.BluetoothCodecConfig.Builder setSampleRate(int sampleRate) { throw new RuntimeException("Stub!"); }
}

}

