/*
 * Copyright (C) 2021 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.bluetooth;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class BluetoothLeAudioCodecConfig implements android.os.Parcelable {

BluetoothLeAudioCodecConfig() { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

public boolean equals(@android.annotation.Nullable java.lang.Object o) { throw new RuntimeException("Stub!"); }

public int getBitsPerSample() { throw new RuntimeException("Stub!"); }

public int getChannelCount() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.lang.String getCodecName() { throw new RuntimeException("Stub!"); }

public int getCodecPriority() { throw new RuntimeException("Stub!"); }

public int getCodecType() { throw new RuntimeException("Stub!"); }

public int getFrameDuration() { throw new RuntimeException("Stub!"); }

public int getMaxOctetsPerFrame() { throw new RuntimeException("Stub!"); }

public int getMinOctetsPerFrame() { throw new RuntimeException("Stub!"); }

public int getOctetsPerFrame() { throw new RuntimeException("Stub!"); }

public int getSampleRate() { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }

public java.lang.String toString() { throw new RuntimeException("Stub!"); }

public void writeToParcel(@android.annotation.NonNull android.os.Parcel out, int flags) { throw new RuntimeException("Stub!"); }

public static final int BITS_PER_SAMPLE_16 = 1; // 0x1

public static final int BITS_PER_SAMPLE_24 = 2; // 0x2

public static final int BITS_PER_SAMPLE_32 = 8; // 0x8

public static final int BITS_PER_SAMPLE_NONE = 0; // 0x0

public static final int CHANNEL_COUNT_1 = 1; // 0x1

public static final int CHANNEL_COUNT_2 = 2; // 0x2

public static final int CHANNEL_COUNT_NONE = 0; // 0x0

public static final int CODEC_PRIORITY_DEFAULT = 0; // 0x0

public static final int CODEC_PRIORITY_DISABLED = -1; // 0xffffffff

public static final int CODEC_PRIORITY_HIGHEST = 1000000; // 0xf4240

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.bluetooth.BluetoothLeAudioCodecConfig> CREATOR;
static { CREATOR = null; }

public static final int FRAME_DURATION_10000 = 2; // 0x2

public static final int FRAME_DURATION_7500 = 1; // 0x1

public static final int FRAME_DURATION_NONE = 0; // 0x0

public static final int SAMPLE_RATE_11025 = 2; // 0x2

public static final int SAMPLE_RATE_16000 = 4; // 0x4

public static final int SAMPLE_RATE_176400 = 1024; // 0x400

public static final int SAMPLE_RATE_192000 = 2048; // 0x800

public static final int SAMPLE_RATE_22050 = 8; // 0x8

public static final int SAMPLE_RATE_24000 = 16; // 0x10

public static final int SAMPLE_RATE_32000 = 32; // 0x20

public static final int SAMPLE_RATE_384000 = 4096; // 0x1000

public static final int SAMPLE_RATE_44100 = 64; // 0x40

public static final int SAMPLE_RATE_48000 = 128; // 0x80

public static final int SAMPLE_RATE_8000 = 1; // 0x1

public static final int SAMPLE_RATE_88200 = 256; // 0x100

public static final int SAMPLE_RATE_96000 = 512; // 0x200

public static final int SAMPLE_RATE_NONE = 0; // 0x0

public static final int SOURCE_CODEC_TYPE_INVALID = 1000000; // 0xf4240

public static final int SOURCE_CODEC_TYPE_LC3 = 0; // 0x0

public static final int SOURCE_CODEC_TYPE_OPUS = 1; // 0x1
@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

public Builder() { throw new RuntimeException("Stub!"); }

public Builder(@android.annotation.NonNull android.bluetooth.BluetoothLeAudioCodecConfig config) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.bluetooth.BluetoothLeAudioCodecConfig build() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.bluetooth.BluetoothLeAudioCodecConfig.Builder setBitsPerSample(int bitsPerSample) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.bluetooth.BluetoothLeAudioCodecConfig.Builder setChannelCount(int channelCount) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.bluetooth.BluetoothLeAudioCodecConfig.Builder setCodecPriority(int codecPriority) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.bluetooth.BluetoothLeAudioCodecConfig.Builder setCodecType(int codecType) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.bluetooth.BluetoothLeAudioCodecConfig.Builder setFrameDuration(int frameDuration) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.bluetooth.BluetoothLeAudioCodecConfig.Builder setMaxOctetsPerFrame(int maxOctetsPerFrame) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.bluetooth.BluetoothLeAudioCodecConfig.Builder setMinOctetsPerFrame(int minOctetsPerFrame) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.bluetooth.BluetoothLeAudioCodecConfig.Builder setOctetsPerFrame(int octetsPerFrame) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.bluetooth.BluetoothLeAudioCodecConfig.Builder setSampleRate(int sampleRate) { throw new RuntimeException("Stub!"); }
}

}

