/*
 * Copyright (C) 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.bluetooth;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public class BluetoothSocketException extends java.io.IOException {

public BluetoothSocketException(int code) { throw new RuntimeException("Stub!"); }

public BluetoothSocketException(int code, @android.annotation.NonNull java.lang.String msg) { throw new RuntimeException("Stub!"); }

public int getErrorCode() { throw new RuntimeException("Stub!"); }

public static final int BLUETOOTH_OFF_FAILURE = 15; // 0xf

public static final int L2CAP_ACL_FAILURE = 2; // 0x2

public static final int L2CAP_CLIENT_SECURITY_FAILURE = 3; // 0x3

public static final int L2CAP_INSUFFICIENT_AUTHENTICATION = 4; // 0x4

public static final int L2CAP_INSUFFICIENT_AUTHORIZATION = 5; // 0x5

public static final int L2CAP_INSUFFICIENT_ENCRYPTION = 7; // 0x7

public static final int L2CAP_INSUFFICIENT_ENCRYPT_KEY_SIZE = 6; // 0x6

public static final int L2CAP_INVALID_PARAMETERS = 11; // 0xb

public static final int L2CAP_INVALID_SOURCE_CID = 8; // 0x8

public static final int L2CAP_NO_PSM_AVAILABLE = 13; // 0xd

public static final int L2CAP_NO_RESOURCES = 12; // 0xc

public static final int L2CAP_SOURCE_CID_ALREADY_ALLOCATED = 9; // 0x9

public static final int L2CAP_TIMEOUT = 14; // 0xe

public static final int L2CAP_UNACCEPTABLE_PARAMETERS = 10; // 0xa

public static final int L2CAP_UNKNOWN = 1; // 0x1

public static final int NULL_DEVICE = 19; // 0x13

public static final int RPC_FAILURE = 20; // 0x14

public static final int SOCKET_CLOSED = 17; // 0x11

public static final int SOCKET_CONNECTION_FAILURE = 18; // 0x12

public static final int SOCKET_MANAGER_FAILURE = 16; // 0x10

public static final int UNIX_FILE_SOCKET_CREATION_FAILURE = 21; // 0x15

public static final int UNSPECIFIED = 0; // 0x0
}

