/*
 * Copyright (C) 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at:
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.bluetooth;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class BluetoothLeBroadcastMetadata implements android.os.Parcelable {

BluetoothLeBroadcastMetadata() { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

public boolean equals(@android.annotation.Nullable java.lang.Object o) { throw new RuntimeException("Stub!"); }

public int getAudioConfigQuality() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public byte[] getBroadcastCode() { throw new RuntimeException("Stub!"); }

public int getBroadcastId() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public java.lang.String getBroadcastName() { throw new RuntimeException("Stub!"); }

public int getPaSyncInterval() { throw new RuntimeException("Stub!"); }

public int getPresentationDelayMicros() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.bluetooth.BluetoothLeAudioContentMetadata getPublicBroadcastMetadata() { throw new RuntimeException("Stub!"); }

public int getRssi() { throw new RuntimeException("Stub!"); }

public int getSourceAddressType() { throw new RuntimeException("Stub!"); }

public int getSourceAdvertisingSid() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.bluetooth.BluetoothDevice getSourceDevice() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.List<android.bluetooth.BluetoothLeBroadcastSubgroup> getSubgroups() { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }

public boolean isEncrypted() { throw new RuntimeException("Stub!"); }

public boolean isPublicBroadcast() { throw new RuntimeException("Stub!"); }

public java.lang.String toString() { throw new RuntimeException("Stub!"); }

public void writeToParcel(android.os.Parcel out, int flags) { throw new RuntimeException("Stub!"); }

public static final int AUDIO_CONFIG_QUALITY_HIGH = 2; // 0x2

public static final int AUDIO_CONFIG_QUALITY_NONE = 0; // 0x0

public static final int AUDIO_CONFIG_QUALITY_STANDARD = 1; // 0x1

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.bluetooth.BluetoothLeBroadcastMetadata> CREATOR;
static { CREATOR = null; }

public static final int PA_SYNC_INTERVAL_UNKNOWN = 65535; // 0xffff

public static final int RSSI_UNKNOWN = 127; // 0x7f
@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

public Builder() { throw new RuntimeException("Stub!"); }

public Builder(@android.annotation.NonNull android.bluetooth.BluetoothLeBroadcastMetadata original) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.bluetooth.BluetoothLeBroadcastMetadata.Builder addSubgroup(@android.annotation.NonNull android.bluetooth.BluetoothLeBroadcastSubgroup subgroup) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.bluetooth.BluetoothLeBroadcastMetadata build() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.bluetooth.BluetoothLeBroadcastMetadata.Builder clearSubgroup() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.bluetooth.BluetoothLeBroadcastMetadata.Builder setAudioConfigQuality(int audioConfigQuality) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.bluetooth.BluetoothLeBroadcastMetadata.Builder setBroadcastCode(@android.annotation.Nullable byte[] broadcastCode) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.bluetooth.BluetoothLeBroadcastMetadata.Builder setBroadcastId(int broadcastId) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.bluetooth.BluetoothLeBroadcastMetadata.Builder setBroadcastName(@android.annotation.Nullable java.lang.String broadcastName) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.bluetooth.BluetoothLeBroadcastMetadata.Builder setEncrypted(boolean isEncrypted) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.bluetooth.BluetoothLeBroadcastMetadata.Builder setPaSyncInterval(int paSyncInterval) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.bluetooth.BluetoothLeBroadcastMetadata.Builder setPresentationDelayMicros(int presentationDelayMicros) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.bluetooth.BluetoothLeBroadcastMetadata.Builder setPublicBroadcast(boolean isPublicBroadcast) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.bluetooth.BluetoothLeBroadcastMetadata.Builder setPublicBroadcastMetadata(@android.annotation.Nullable android.bluetooth.BluetoothLeAudioContentMetadata publicBroadcastMetadata) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.bluetooth.BluetoothLeBroadcastMetadata.Builder setRssi(int rssi) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.bluetooth.BluetoothLeBroadcastMetadata.Builder setSourceAdvertisingSid(int sourceAdvertisingSid) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.bluetooth.BluetoothLeBroadcastMetadata.Builder setSourceDevice(@android.annotation.NonNull android.bluetooth.BluetoothDevice sourceDevice, int sourceAddressType) { throw new RuntimeException("Stub!"); }
}

}

