/*
 * Copyright (C) 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.bluetooth;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class BluetoothSocketSettings {

BluetoothSocketSettings() { throw new RuntimeException("Stub!"); }

public int getDataPath() { throw new RuntimeException("Stub!"); }

public long getEndpointId() { throw new RuntimeException("Stub!"); }

public long getHubId() { throw new RuntimeException("Stub!"); }

public int getL2capPsm() { throw new RuntimeException("Stub!"); }

public int getRequestedMaximumPacketSize() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public java.lang.String getRfcommServiceName() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public java.util.UUID getRfcommUuid() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.lang.String getSocketName() { throw new RuntimeException("Stub!"); }

public int getSocketType() { throw new RuntimeException("Stub!"); }

public boolean isAuthenticationRequired() { throw new RuntimeException("Stub!"); }

public boolean isEncryptionRequired() { throw new RuntimeException("Stub!"); }

public java.lang.String toString() { throw new RuntimeException("Stub!"); }

public static final int DATA_PATH_HARDWARE_OFFLOAD = 1; // 0x1

public static final int DATA_PATH_NO_OFFLOAD = 0; // 0x0
@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

public Builder() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.bluetooth.BluetoothSocketSettings build() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.bluetooth.BluetoothSocketSettings.Builder setAuthenticationRequired(boolean authenticationRequired) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.bluetooth.BluetoothSocketSettings.Builder setDataPath(int dataPath) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.bluetooth.BluetoothSocketSettings.Builder setEncryptionRequired(boolean encryptionRequired) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.bluetooth.BluetoothSocketSettings.Builder setEndpointId(long endpointId) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.bluetooth.BluetoothSocketSettings.Builder setHubId(long hubId) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.bluetooth.BluetoothSocketSettings.Builder setL2capPsm(int l2capPsm) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.bluetooth.BluetoothSocketSettings.Builder setRequestedMaximumPacketSize(int maximumPacketSize) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.bluetooth.BluetoothSocketSettings.Builder setRfcommServiceName(@android.annotation.NonNull java.lang.String rfcommServiceName) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.bluetooth.BluetoothSocketSettings.Builder setRfcommUuid(@android.annotation.NonNull java.util.UUID rfcommUuid) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.bluetooth.BluetoothSocketSettings.Builder setSocketName(@android.annotation.NonNull java.lang.String socketName) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.bluetooth.BluetoothSocketSettings.Builder setSocketType(int socketType) { throw new RuntimeException("Stub!"); }
}

}

