/*
 * Copyright (C) 2021 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.bluetooth;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class BluetoothStatusCodes {

BluetoothStatusCodes() { throw new RuntimeException("Stub!"); }

public static final int ALLOWED = 400; // 0x190

public static final int ERROR_ALREADY_IN_TARGET_STATE = 26; // 0x1a

public static final int ERROR_ANOTHER_ACTIVE_OOB_REQUEST = 1000; // 0x3e8

public static final int ERROR_ANOTHER_ACTIVE_REQUEST = 29; // 0x1d

public static final int ERROR_AUDIO_DEVICE_ALREADY_CONNECTED = 1116; // 0x45c

public static final int ERROR_AUDIO_DEVICE_ALREADY_DISCONNECTED = 1117; // 0x45d

public static final int ERROR_AUDIO_ROUTE_BLOCKED = 1118; // 0x45e

public static final int ERROR_BAD_PARAMETERS = 21; // 0x15

public static final int ERROR_BLUETOOTH_NOT_ALLOWED = 2; // 0x2

public static final int ERROR_BLUETOOTH_NOT_ENABLED = 1; // 0x1

public static final int ERROR_CALLBACK_NOT_REGISTERED = 28; // 0x1c

public static final int ERROR_CALL_ACTIVE = 1119; // 0x45f

public static final int ERROR_CSIP_GROUP_LOCKED_BY_OTHER = 1208; // 0x4b8

public static final int ERROR_CSIP_INVALID_GROUP_ID = 1207; // 0x4b7

public static final int ERROR_CSIP_LOCKED_GROUP_MEMBER_LOST = 1209; // 0x4b9

public static final int ERROR_DEVICE_NOT_BONDED = 3; // 0x3

public static final int ERROR_DISTANCE_MEASUREMENT_INTERNAL = 1301; // 0x515

public static final int ERROR_GATT_WRITE_NOT_ALLOWED = 200; // 0xc8

public static final int ERROR_GATT_WRITE_REQUEST_BUSY = 201; // 0xc9

public static final int ERROR_HAP_INVALID_PRESET_INDEX = 1211; // 0x4bb

public static final int ERROR_HAP_PRESET_NAME_TOO_LONG = 1210; // 0x4ba

public static final int ERROR_HARDWARE_GENERIC = 20; // 0x14

public static final int ERROR_LE_BROADCAST_ASSISTANT_DUPLICATE_ADDITION = 1203; // 0x4b3

public static final int ERROR_LE_BROADCAST_ASSISTANT_INVALID_SOURCE_ID = 1202; // 0x4b2

public static final int ERROR_LE_BROADCAST_INVALID_BROADCAST_ID = 1200; // 0x4b0

public static final int ERROR_LE_BROADCAST_INVALID_CODE = 1201; // 0x4b1

public static final int ERROR_LE_CONTENT_METADATA_INVALID_LANGUAGE = 1205; // 0x4b5

public static final int ERROR_LE_CONTENT_METADATA_INVALID_OTHER = 1206; // 0x4b6

public static final int ERROR_LE_CONTENT_METADATA_INVALID_PROGRAM_INFO = 1204; // 0x4b4

public static final int ERROR_LOCAL_NOT_ENOUGH_RESOURCES = 22; // 0x16

public static final int ERROR_MISSING_BLUETOOTH_CONNECT_PERMISSION = 6; // 0x6

public static final int ERROR_NOT_ACTIVE_DEVICE = 12; // 0xc

public static final int ERROR_NOT_DUAL_MODE_AUDIO_DEVICE = 3000; // 0xbb8

public static final int ERROR_NO_ACTIVE_DEVICES = 13; // 0xd

public static final int ERROR_NO_LE_CONNECTION = 1300; // 0x514

public static final int ERROR_PROFILE_NOT_CONNECTED = 14; // 0xe

public static final int ERROR_PROFILE_SERVICE_NOT_BOUND = 9; // 0x9

public static final int ERROR_REMOTE_LINK_ERROR = 25; // 0x19

public static final int ERROR_REMOTE_NOT_ENOUGH_RESOURCES = 23; // 0x17

public static final int ERROR_REMOTE_OPERATION_NOT_SUPPORTED = 27; // 0x1b

public static final int ERROR_REMOTE_OPERATION_REJECTED = 24; // 0x18

public static final int ERROR_TIMEOUT = 15; // 0xf

public static final int ERROR_UNKNOWN = 2147483647; // 0x7fffffff

public static final int FEATURE_NOT_CONFIGURED = 30; // 0x1e

public static final int FEATURE_NOT_SUPPORTED = 11; // 0xb

public static final int FEATURE_SUPPORTED = 10; // 0xa

public static final int NOT_ALLOWED = 401; // 0x191

public static final int REASON_LOCAL_APP_REQUEST = 16; // 0x10

public static final int REASON_LOCAL_STACK_REQUEST = 17; // 0x11

public static final int REASON_REMOTE_REQUEST = 18; // 0x12

public static final int REASON_SYSTEM_POLICY = 19; // 0x13

public static final int RFCOMM_LISTENER_FAILED_TO_CLOSE_SERVER_SOCKET = 2004; // 0x7d4

public static final int RFCOMM_LISTENER_FAILED_TO_CREATE_SERVER_SOCKET = 2003; // 0x7d3

public static final int RFCOMM_LISTENER_NO_SOCKET_AVAILABLE = 2005; // 0x7d5

public static final int RFCOMM_LISTENER_OPERATION_FAILED_DIFFERENT_APP = 2002; // 0x7d2

public static final int RFCOMM_LISTENER_OPERATION_FAILED_NO_MATCHING_SERVICE_RECORD = 2001; // 0x7d1

public static final int RFCOMM_LISTENER_START_FAILED_UUID_IN_USE = 2000; // 0x7d0

public static final int SUCCESS = 0; // 0x0
}

