/*
 * Copyright (C) 2017 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.bluetooth.le;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class AdvertisingSetParameters implements android.os.Parcelable {

AdvertisingSetParameters() { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

public int getInterval() { throw new RuntimeException("Stub!"); }

public int getOwnAddressType() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public java.lang.String getPeerAddress() { throw new RuntimeException("Stub!"); }

public int getPeerAddressType() { throw new RuntimeException("Stub!"); }

public int getPrimaryPhy() { throw new RuntimeException("Stub!"); }

public int getSecondaryPhy() { throw new RuntimeException("Stub!"); }

public int getTxPowerLevel() { throw new RuntimeException("Stub!"); }

public boolean includeTxPower() { throw new RuntimeException("Stub!"); }

public boolean isAnonymous() { throw new RuntimeException("Stub!"); }

public boolean isConnectable() { throw new RuntimeException("Stub!"); }

public boolean isDirected() { throw new RuntimeException("Stub!"); }

public boolean isDiscoverable() { throw new RuntimeException("Stub!"); }

public boolean isHighDutyCycle() { throw new RuntimeException("Stub!"); }

public boolean isLegacy() { throw new RuntimeException("Stub!"); }

public boolean isScannable() { throw new RuntimeException("Stub!"); }

public java.lang.String toString() { throw new RuntimeException("Stub!"); }

public void writeToParcel(android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

public static final int ADDRESS_TYPE_DEFAULT = -1; // 0xffffffff

public static final int ADDRESS_TYPE_PUBLIC = 0; // 0x0

public static final int ADDRESS_TYPE_RANDOM = 1; // 0x1

public static final int ADDRESS_TYPE_RANDOM_NON_RESOLVABLE = 2; // 0x2

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.bluetooth.le.AdvertisingSetParameters> CREATOR;
static { CREATOR = null; }

public static final int INTERVAL_HIGH = 1600; // 0x640

public static final int INTERVAL_LOW = 160; // 0xa0

public static final int INTERVAL_MAX = 16777215; // 0xffffff

public static final int INTERVAL_MEDIUM = 400; // 0x190

public static final int INTERVAL_MIN = 160; // 0xa0

public static final int TX_POWER_HIGH = 1; // 0x1

public static final int TX_POWER_LOW = -15; // 0xfffffff1

public static final int TX_POWER_MAX = 1; // 0x1

public static final int TX_POWER_MEDIUM = -7; // 0xfffffff9

public static final int TX_POWER_MIN = -127; // 0xffffff81

public static final int TX_POWER_ULTRA_LOW = -21; // 0xffffffeb
@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

public Builder() { throw new RuntimeException("Stub!"); }

public android.bluetooth.le.AdvertisingSetParameters build() { throw new RuntimeException("Stub!"); }

public android.bluetooth.le.AdvertisingSetParameters.Builder setAnonymous(boolean isAnonymous) { throw new RuntimeException("Stub!"); }

public android.bluetooth.le.AdvertisingSetParameters.Builder setConnectable(boolean connectable) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.bluetooth.le.AdvertisingSetParameters.Builder setDirected(boolean isDirected) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.bluetooth.le.AdvertisingSetParameters.Builder setDiscoverable(boolean discoverable) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.bluetooth.le.AdvertisingSetParameters.Builder setHighDutyCycle(boolean isHighDutyCycle) { throw new RuntimeException("Stub!"); }

public android.bluetooth.le.AdvertisingSetParameters.Builder setIncludeTxPower(boolean includeTxPower) { throw new RuntimeException("Stub!"); }

public android.bluetooth.le.AdvertisingSetParameters.Builder setInterval(int interval) { throw new RuntimeException("Stub!"); }

public android.bluetooth.le.AdvertisingSetParameters.Builder setLegacyMode(boolean isLegacy) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.bluetooth.le.AdvertisingSetParameters.Builder setOwnAddressType(int ownAddressType) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.bluetooth.le.AdvertisingSetParameters.Builder setPeerAddress(@android.annotation.NonNull java.lang.String peerAddress) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.bluetooth.le.AdvertisingSetParameters.Builder setPeerAddressType(int peerAddressType) { throw new RuntimeException("Stub!"); }

public android.bluetooth.le.AdvertisingSetParameters.Builder setPrimaryPhy(int primaryPhy) { throw new RuntimeException("Stub!"); }

public android.bluetooth.le.AdvertisingSetParameters.Builder setScannable(boolean scannable) { throw new RuntimeException("Stub!"); }

public android.bluetooth.le.AdvertisingSetParameters.Builder setSecondaryPhy(int secondaryPhy) { throw new RuntimeException("Stub!"); }

public android.bluetooth.le.AdvertisingSetParameters.Builder setTxPowerLevel(int txPowerLevel) { throw new RuntimeException("Stub!"); }
}

}

