/*
 * Copyright (C) 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.bluetooth;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public class AudioInputControl {

AudioInputControl() { throw new RuntimeException("Stub!"); }

public int getAudioInputStatus() { throw new RuntimeException("Stub!"); }

public int getAudioInputType() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.lang.String getDescription() { throw new RuntimeException("Stub!"); }

public int getGainMode() { throw new RuntimeException("Stub!"); }

public int getGainSetting() { throw new RuntimeException("Stub!"); }

public int getGainSettingMax() { throw new RuntimeException("Stub!"); }

public int getGainSettingMin() { throw new RuntimeException("Stub!"); }

public int getGainSettingUnit() { throw new RuntimeException("Stub!"); }

public int getMute() { throw new RuntimeException("Stub!"); }

public boolean isDescriptionWritable() { throw new RuntimeException("Stub!"); }

public void registerCallback(@android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.bluetooth.AudioInputControl.AudioInputCallback callback) { throw new RuntimeException("Stub!"); }

public boolean setDescription(@android.annotation.NonNull java.lang.String description) { throw new RuntimeException("Stub!"); }

public boolean setGainMode(int gainMode) { throw new RuntimeException("Stub!"); }

public boolean setGainSetting(int gainSetting) { throw new RuntimeException("Stub!"); }

public boolean setMute(int mute) { throw new RuntimeException("Stub!"); }

public void unregisterCallback(@android.annotation.NonNull android.bluetooth.AudioInputControl.AudioInputCallback callback) { throw new RuntimeException("Stub!"); }

public static final int AUDIO_INPUT_STATUS_ACTIVE = 1; // 0x1

public static final int AUDIO_INPUT_STATUS_INACTIVE = 0; // 0x0

public static final int AUDIO_INPUT_STATUS_UNKNOWN = -1; // 0xffffffff

public static final int AUDIO_INPUT_TYPE_AMBIENT = 7; // 0x7

public static final int AUDIO_INPUT_TYPE_ANALOG = 3; // 0x3

public static final int AUDIO_INPUT_TYPE_BLUETOOTH = 1; // 0x1

public static final int AUDIO_INPUT_TYPE_DIGITAL = 4; // 0x4

public static final int AUDIO_INPUT_TYPE_MICROPHONE = 2; // 0x2

public static final int AUDIO_INPUT_TYPE_RADIO = 5; // 0x5

public static final int AUDIO_INPUT_TYPE_STREAMING = 6; // 0x6

public static final int AUDIO_INPUT_TYPE_UNSPECIFIED = 0; // 0x0

public static final int GAIN_MODE_AUTOMATIC = 3; // 0x3

public static final int GAIN_MODE_AUTOMATIC_ONLY = 1; // 0x1

public static final int GAIN_MODE_MANUAL = 2; // 0x2

public static final int GAIN_MODE_MANUAL_ONLY = 0; // 0x0

public static final int MUTE_DISABLED = 2; // 0x2

public static final int MUTE_MUTED = 1; // 0x1

public static final int MUTE_NOT_MUTED = 0; // 0x0
@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface AudioInputCallback {

public default void onAudioInputStatusChanged(int status) { throw new RuntimeException("Stub!"); }

public default void onDescriptionChanged(@android.annotation.NonNull java.lang.String description) { throw new RuntimeException("Stub!"); }

public default void onGainModeChanged(int gainMode) { throw new RuntimeException("Stub!"); }

public default void onGainSettingChanged(int gainSetting) { throw new RuntimeException("Stub!"); }

public default void onMuteChanged(int mute) { throw new RuntimeException("Stub!"); }

public default void onSetGainModeFailed() { throw new RuntimeException("Stub!"); }

public default void onSetGainSettingFailed() { throw new RuntimeException("Stub!"); }

public default void onSetMuteFailed() { throw new RuntimeException("Stub!"); }
}

}

