/*
 * Copyright 2009-2016 The Android Open Source Project
 * Copyright 2015 Samsung LSI
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.bluetooth;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class BluetoothAdapter {

BluetoothAdapter() { throw new RuntimeException("Stub!"); }

public boolean addOnMetadataChangedListener(@android.annotation.NonNull android.bluetooth.BluetoothDevice device, @android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.bluetooth.BluetoothAdapter.OnMetadataChangedListener listener) { throw new RuntimeException("Stub!"); }

public boolean cancelDiscovery() { throw new RuntimeException("Stub!"); }

public static boolean checkBluetoothAddress(java.lang.String address) { throw new RuntimeException("Stub!"); }

public boolean clearBluetooth() { throw new RuntimeException("Stub!"); }

public void closeProfileProxy(int unusedProfile, android.bluetooth.BluetoothProfile proxy) { throw new RuntimeException("Stub!"); }

@Deprecated
public boolean disable() { throw new RuntimeException("Stub!"); }

public boolean disable(boolean persist) { throw new RuntimeException("Stub!"); }

public boolean disableBLE() { throw new RuntimeException("Stub!"); }

@Deprecated
public boolean enable() { throw new RuntimeException("Stub!"); }

public boolean enableBLE() { throw new RuntimeException("Stub!"); }

public boolean enableNoAutoConnect() { throw new RuntimeException("Stub!"); }

protected void finalize() throws java.lang.Throwable { throw new RuntimeException("Stub!"); }

public void generateLocalOobData(int transport, @android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.bluetooth.BluetoothAdapter.OobDataCallback callback) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.List<android.bluetooth.BluetoothDevice> getActiveDevices(int profile) { throw new RuntimeException("Stub!"); }

public java.lang.String getAddress() { throw new RuntimeException("Stub!"); }

public int getBluetoothHciSnoopLoggingMode() { throw new RuntimeException("Stub!"); }

public android.bluetooth.le.BluetoothLeAdvertiser getBluetoothLeAdvertiser() { throw new RuntimeException("Stub!"); }

public android.bluetooth.le.BluetoothLeScanner getBluetoothLeScanner() { throw new RuntimeException("Stub!"); }

public java.util.Set<android.bluetooth.BluetoothDevice> getBondedDevices() { throw new RuntimeException("Stub!"); }

public int getConnectionState() { throw new RuntimeException("Stub!"); }

@Deprecated
public static synchronized android.bluetooth.BluetoothAdapter getDefaultAdapter() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public java.time.Duration getDiscoverableTimeout() { throw new RuntimeException("Stub!"); }

public long getDiscoveryEndMillis() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.bluetooth.le.DistanceMeasurementManager getDistanceMeasurementManager() { throw new RuntimeException("Stub!"); }

public int getLeMaximumAdvertisingDataLength() { throw new RuntimeException("Stub!"); }

public int getMaxConnectedAudioDevices() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.List<android.bluetooth.BluetoothDevice> getMostRecentlyConnectedDevices() { throw new RuntimeException("Stub!"); }

public java.lang.String getName() { throw new RuntimeException("Stub!"); }

public int getOffloadedTransportDiscoveryDataScanSupported() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.os.Bundle getPreferredAudioProfiles(@android.annotation.NonNull android.bluetooth.BluetoothDevice device) { throw new RuntimeException("Stub!"); }

public int getProfileConnectionState(int profile) { throw new RuntimeException("Stub!"); }

public boolean getProfileProxy(android.content.Context context, android.bluetooth.BluetoothProfile.ServiceListener listener, int profile) { throw new RuntimeException("Stub!"); }

public android.bluetooth.BluetoothDevice getRemoteDevice(byte[] address) { throw new RuntimeException("Stub!"); }

public android.bluetooth.BluetoothDevice getRemoteDevice(java.lang.String address) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.bluetooth.BluetoothDevice getRemoteLeDevice(@android.annotation.NonNull java.lang.String address, int addressType) { throw new RuntimeException("Stub!"); }

public int getScanMode() { throw new RuntimeException("Stub!"); }

public int getState() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.List<java.lang.Integer> getSupportedProfiles() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.List<android.os.ParcelUuid> getUuidsList() { throw new RuntimeException("Stub!"); }

public boolean isAutoOnEnabled() { throw new RuntimeException("Stub!"); }

public boolean isAutoOnSupported() { throw new RuntimeException("Stub!"); }

public boolean isBleScanAlwaysAvailable() { throw new RuntimeException("Stub!"); }

public boolean isDiscovering() { throw new RuntimeException("Stub!"); }

public int isDistanceMeasurementSupported() { throw new RuntimeException("Stub!"); }

public boolean isEnabled() { throw new RuntimeException("Stub!"); }

public boolean isLe2MPhySupported() { throw new RuntimeException("Stub!"); }

public int isLeAudioBroadcastAssistantSupported() { throw new RuntimeException("Stub!"); }

public int isLeAudioBroadcastSourceSupported() { throw new RuntimeException("Stub!"); }

public int isLeAudioSupported() { throw new RuntimeException("Stub!"); }

public boolean isLeCocSocketOffloadSupported() { throw new RuntimeException("Stub!"); }

public boolean isLeCodedPhySupported() { throw new RuntimeException("Stub!"); }

public boolean isLeEnabled() { throw new RuntimeException("Stub!"); }

public boolean isLeExtendedAdvertisingSupported() { throw new RuntimeException("Stub!"); }

public boolean isLePeriodicAdvertisingSupported() { throw new RuntimeException("Stub!"); }

public boolean isMultipleAdvertisementSupported() { throw new RuntimeException("Stub!"); }

public boolean isOffloadedFilteringSupported() { throw new RuntimeException("Stub!"); }

public boolean isOffloadedScanBatchingSupported() { throw new RuntimeException("Stub!"); }

public boolean isRfcommSocketOffloadSupported() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.bluetooth.BluetoothServerSocket listenUsingInsecureL2capChannel() throws java.io.IOException { throw new RuntimeException("Stub!"); }

public android.bluetooth.BluetoothServerSocket listenUsingInsecureRfcommWithServiceRecord(java.lang.String name, java.util.UUID uuid) throws java.io.IOException { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.bluetooth.BluetoothServerSocket listenUsingL2capChannel() throws java.io.IOException { throw new RuntimeException("Stub!"); }

public android.bluetooth.BluetoothServerSocket listenUsingRfcommWithServiceRecord(java.lang.String name, java.util.UUID uuid) throws java.io.IOException { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.bluetooth.BluetoothServerSocket listenUsingSocketSettings(@android.annotation.NonNull android.bluetooth.BluetoothSocketSettings settings) throws java.io.IOException { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public static java.lang.String nameForState(int state) { throw new RuntimeException("Stub!"); }

public int notifyActiveDeviceChangeApplied(@android.annotation.NonNull android.bluetooth.BluetoothDevice device) { throw new RuntimeException("Stub!"); }

public boolean registerBluetoothConnectionCallback(@android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.bluetooth.BluetoothAdapter.BluetoothConnectionCallback callback) { throw new RuntimeException("Stub!"); }

public void registerBluetoothHciVendorSpecificCallback(@android.annotation.NonNull java.util.Set<java.lang.Integer> eventCodeSet, @android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.bluetooth.BluetoothAdapter.BluetoothHciVendorSpecificCallback callback) { throw new RuntimeException("Stub!"); }

public int registerBluetoothQualityReportReadyCallback(@android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.bluetooth.BluetoothAdapter.BluetoothQualityReportReadyCallback callback) { throw new RuntimeException("Stub!"); }

public int registerPreferredAudioProfilesChangedCallback(@android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.bluetooth.BluetoothAdapter.PreferredAudioProfilesChangedCallback callback) { throw new RuntimeException("Stub!"); }

public boolean removeActiveDevice(int profiles) { throw new RuntimeException("Stub!"); }

public boolean removeOnMetadataChangedListener(@android.annotation.NonNull android.bluetooth.BluetoothDevice device, @android.annotation.NonNull android.bluetooth.BluetoothAdapter.OnMetadataChangedListener listener) { throw new RuntimeException("Stub!"); }

public void requestControllerActivityEnergyInfo(@android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.bluetooth.BluetoothAdapter.OnBluetoothActivityEnergyInfoCallback callback) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.bluetooth.BluetoothSocket retrieveConnectedRfcommSocket(@android.annotation.NonNull java.util.UUID uuid) { throw new RuntimeException("Stub!"); }

public void sendBluetoothHciVendorSpecificCommand(int ocf, @android.annotation.NonNull byte[] parameters) { throw new RuntimeException("Stub!"); }

public boolean setActiveDevice(@android.annotation.NonNull android.bluetooth.BluetoothDevice device, int profiles) { throw new RuntimeException("Stub!"); }

public void setAutoOnEnabled(boolean status) { throw new RuntimeException("Stub!"); }

public int setBluetoothHciSnoopLoggingMode(int mode) { throw new RuntimeException("Stub!"); }

public int setDiscoverableTimeout(@android.annotation.NonNull java.time.Duration timeout) { throw new RuntimeException("Stub!"); }

public boolean setName(java.lang.String name) { throw new RuntimeException("Stub!"); }

public int setPreferredAudioProfiles(@android.annotation.NonNull android.bluetooth.BluetoothDevice device, @android.annotation.NonNull android.os.Bundle modeToProfileBundle) { throw new RuntimeException("Stub!"); }

public int setScanMode(int mode) { throw new RuntimeException("Stub!"); }

public boolean startDiscovery() { throw new RuntimeException("Stub!"); }

@Deprecated
public boolean startLeScan(android.bluetooth.BluetoothAdapter.LeScanCallback callback) { throw new RuntimeException("Stub!"); }

@Deprecated
public boolean startLeScan(java.util.UUID[] serviceUuids, android.bluetooth.BluetoothAdapter.LeScanCallback callback) { throw new RuntimeException("Stub!"); }

public int startRfcommServer(@android.annotation.NonNull java.lang.String name, @android.annotation.NonNull java.util.UUID uuid, @android.annotation.NonNull android.app.PendingIntent pendingIntent) { throw new RuntimeException("Stub!"); }

@Deprecated
public void stopLeScan(android.bluetooth.BluetoothAdapter.LeScanCallback callback) { throw new RuntimeException("Stub!"); }

public int stopRfcommServer(@android.annotation.NonNull java.util.UUID uuid) { throw new RuntimeException("Stub!"); }

public boolean unregisterBluetoothConnectionCallback(@android.annotation.NonNull android.bluetooth.BluetoothAdapter.BluetoothConnectionCallback callback) { throw new RuntimeException("Stub!"); }

public void unregisterBluetoothHciVendorSpecificCallback(@android.annotation.NonNull android.bluetooth.BluetoothAdapter.BluetoothHciVendorSpecificCallback callback) { throw new RuntimeException("Stub!"); }

public int unregisterBluetoothQualityReportReadyCallback(@android.annotation.NonNull android.bluetooth.BluetoothAdapter.BluetoothQualityReportReadyCallback callback) { throw new RuntimeException("Stub!"); }

public int unregisterPreferredAudioProfilesChangedCallback(@android.annotation.NonNull android.bluetooth.BluetoothAdapter.PreferredAudioProfilesChangedCallback callback) { throw new RuntimeException("Stub!"); }

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.BROADCAST_INTENT_ACTION) public static final java.lang.String ACTION_AUTO_ON_STATE_CHANGED = "android.bluetooth.action.AUTO_ON_STATE_CHANGED";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.BROADCAST_INTENT_ACTION) public static final java.lang.String ACTION_BLE_STATE_CHANGED = "android.bluetooth.adapter.action.BLE_STATE_CHANGED";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.BROADCAST_INTENT_ACTION) public static final java.lang.String ACTION_CONNECTION_STATE_CHANGED = "android.bluetooth.adapter.action.CONNECTION_STATE_CHANGED";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.BROADCAST_INTENT_ACTION) public static final java.lang.String ACTION_DISCOVERY_FINISHED = "android.bluetooth.adapter.action.DISCOVERY_FINISHED";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.BROADCAST_INTENT_ACTION) public static final java.lang.String ACTION_DISCOVERY_STARTED = "android.bluetooth.adapter.action.DISCOVERY_STARTED";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.BROADCAST_INTENT_ACTION) public static final java.lang.String ACTION_LOCAL_NAME_CHANGED = "android.bluetooth.adapter.action.LOCAL_NAME_CHANGED";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.ACTIVITY_INTENT_ACTION) public static final java.lang.String ACTION_REQUEST_BLE_SCAN_ALWAYS_AVAILABLE = "android.bluetooth.adapter.action.REQUEST_BLE_SCAN_ALWAYS_AVAILABLE";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.ACTIVITY_INTENT_ACTION) public static final java.lang.String ACTION_REQUEST_DISABLE = "android.bluetooth.adapter.action.REQUEST_DISABLE";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.ACTIVITY_INTENT_ACTION) public static final java.lang.String ACTION_REQUEST_DISCOVERABLE = "android.bluetooth.adapter.action.REQUEST_DISCOVERABLE";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.ACTIVITY_INTENT_ACTION) public static final java.lang.String ACTION_REQUEST_ENABLE = "android.bluetooth.adapter.action.REQUEST_ENABLE";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.BROADCAST_INTENT_ACTION) public static final java.lang.String ACTION_SCAN_MODE_CHANGED = "android.bluetooth.adapter.action.SCAN_MODE_CHANGED";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.BROADCAST_INTENT_ACTION) public static final java.lang.String ACTION_STATE_CHANGED = "android.bluetooth.adapter.action.STATE_CHANGED";

public static final int ACTIVE_DEVICE_ALL = 2; // 0x2

public static final int ACTIVE_DEVICE_AUDIO = 0; // 0x0

public static final int ACTIVE_DEVICE_PHONE_CALL = 1; // 0x1

public static final java.lang.String AUDIO_MODE_DUPLEX = "audio_mode_duplex";

public static final java.lang.String AUDIO_MODE_OUTPUT_ONLY = "audio_mode_output_only";

public static final int AUTO_ON_STATE_DISABLED = 1; // 0x1

public static final int AUTO_ON_STATE_ENABLED = 2; // 0x2

public static final int BT_SNOOP_LOG_MODE_DISABLED = 0; // 0x0

public static final int BT_SNOOP_LOG_MODE_FILTERED = 1; // 0x1

public static final int BT_SNOOP_LOG_MODE_FULL = 2; // 0x2

public static final int ERROR = -2147483648; // 0x80000000

public static final java.lang.String EXTRA_AUTO_ON_STATE = "android.bluetooth.extra.AUTO_ON_STATE";

public static final java.lang.String EXTRA_CONNECTION_STATE = "android.bluetooth.adapter.extra.CONNECTION_STATE";

public static final java.lang.String EXTRA_DISCOVERABLE_DURATION = "android.bluetooth.adapter.extra.DISCOVERABLE_DURATION";

public static final java.lang.String EXTRA_LOCAL_NAME = "android.bluetooth.adapter.extra.LOCAL_NAME";

public static final java.lang.String EXTRA_PREVIOUS_CONNECTION_STATE = "android.bluetooth.adapter.extra.PREVIOUS_CONNECTION_STATE";

public static final java.lang.String EXTRA_PREVIOUS_SCAN_MODE = "android.bluetooth.adapter.extra.PREVIOUS_SCAN_MODE";

public static final java.lang.String EXTRA_PREVIOUS_STATE = "android.bluetooth.adapter.extra.PREVIOUS_STATE";

public static final java.lang.String EXTRA_RFCOMM_LISTENER_ID = "android.bluetooth.adapter.extra.RFCOMM_LISTENER_ID";

public static final java.lang.String EXTRA_SCAN_MODE = "android.bluetooth.adapter.extra.SCAN_MODE";

public static final java.lang.String EXTRA_STATE = "android.bluetooth.adapter.extra.STATE";

public static final int SCAN_MODE_CONNECTABLE = 21; // 0x15

public static final int SCAN_MODE_CONNECTABLE_DISCOVERABLE = 23; // 0x17

public static final int SCAN_MODE_NONE = 20; // 0x14

public static final int STATE_BLE_ON = 15; // 0xf

public static final int STATE_CONNECTED = 2; // 0x2

public static final int STATE_CONNECTING = 1; // 0x1

public static final int STATE_DISCONNECTED = 0; // 0x0

public static final int STATE_DISCONNECTING = 3; // 0x3

public static final int STATE_OFF = 10; // 0xa

public static final int STATE_ON = 12; // 0xc

public static final int STATE_TURNING_OFF = 13; // 0xd

public static final int STATE_TURNING_ON = 11; // 0xb
@SuppressWarnings({"unchecked", "deprecation", "all"})
public abstract static class BluetoothConnectionCallback {

public BluetoothConnectionCallback() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public static java.lang.String disconnectReasonToString(int reason) { throw new RuntimeException("Stub!"); }

public void onDeviceConnected(@android.annotation.NonNull android.bluetooth.BluetoothDevice device) { throw new RuntimeException("Stub!"); }

public void onDeviceDisconnected(@android.annotation.NonNull android.bluetooth.BluetoothDevice device, int reason) { throw new RuntimeException("Stub!"); }
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface BluetoothHciVendorSpecificCallback {

public void onCommandComplete(int ocf, @android.annotation.NonNull byte[] returnParameters);

public void onCommandStatus(int ocf, int status);

public void onEvent(int code, @android.annotation.NonNull byte[] data);
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface BluetoothQualityReportReadyCallback {

public void onBluetoothQualityReportReady(@android.annotation.NonNull android.bluetooth.BluetoothDevice device, @android.annotation.NonNull android.bluetooth.BluetoothQualityReport bluetoothQualityReport, int status);
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface LeScanCallback {

public void onLeScan(android.bluetooth.BluetoothDevice device, int rssi, byte[] scanRecord);
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface OnBluetoothActivityEnergyInfoCallback {

public void onBluetoothActivityEnergyInfoAvailable(@android.annotation.NonNull android.bluetooth.BluetoothActivityEnergyInfo info);

public void onBluetoothActivityEnergyInfoError(int error);
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface OnMetadataChangedListener {

public void onMetadataChanged(@android.annotation.NonNull android.bluetooth.BluetoothDevice device, int key, @android.annotation.Nullable byte[] value);
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface OobDataCallback {

public void onError(int errorCode);

public void onOobData(int transport, @android.annotation.NonNull android.bluetooth.OobData oobData);
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface PreferredAudioProfilesChangedCallback {

public void onPreferredAudioProfilesChanged(@android.annotation.NonNull android.bluetooth.BluetoothDevice device, @android.annotation.NonNull android.os.Bundle preferredAudioProfiles, int status);
}

}

