/*
 * Copyright (C) 2009 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.bluetooth;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class BluetoothDevice implements android.os.Parcelable {

BluetoothDevice() { throw new RuntimeException("Stub!"); }

public boolean canBondWithoutDialog() { throw new RuntimeException("Stub!"); }

public boolean cancelBondProcess() { throw new RuntimeException("Stub!"); }

public int connect() { throw new RuntimeException("Stub!"); }

public android.bluetooth.BluetoothGatt connectGatt(android.content.Context context, boolean autoConnect, android.bluetooth.BluetoothGattCallback callback) { throw new RuntimeException("Stub!"); }

public android.bluetooth.BluetoothGatt connectGatt(android.content.Context context, boolean autoConnect, android.bluetooth.BluetoothGattCallback callback, int transport) { throw new RuntimeException("Stub!"); }

public android.bluetooth.BluetoothGatt connectGatt(android.content.Context context, boolean autoConnect, android.bluetooth.BluetoothGattCallback callback, int transport, int phy) { throw new RuntimeException("Stub!"); }

public android.bluetooth.BluetoothGatt connectGatt(android.content.Context context, boolean autoConnect, android.bluetooth.BluetoothGattCallback callback, int transport, int phy, android.os.Handler handler) { throw new RuntimeException("Stub!"); }

public boolean createBond() { throw new RuntimeException("Stub!"); }

public boolean createBond(int transport) { throw new RuntimeException("Stub!"); }

public boolean createBondOutOfBand(int transport, @android.annotation.Nullable android.bluetooth.OobData remoteP192Data, @android.annotation.Nullable android.bluetooth.OobData remoteP256Data) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.bluetooth.BluetoothSocket createInsecureL2capChannel(int psm) throws java.io.IOException { throw new RuntimeException("Stub!"); }

public android.bluetooth.BluetoothSocket createInsecureRfcommSocketToServiceRecord(java.util.UUID uuid) throws java.io.IOException { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.bluetooth.BluetoothSocket createL2capChannel(int psm) throws java.io.IOException { throw new RuntimeException("Stub!"); }

public android.bluetooth.BluetoothSocket createRfcommSocketToServiceRecord(java.util.UUID uuid) throws java.io.IOException { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.bluetooth.BluetoothSocket createUsingSocketSettings(@android.annotation.NonNull android.bluetooth.BluetoothSocketSettings settings) throws java.io.IOException { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

public int disconnect() { throw new RuntimeException("Stub!"); }

public boolean equals(@android.annotation.Nullable java.lang.Object o) { throw new RuntimeException("Stub!"); }

public boolean fetchUuidsWithSdp() { throw new RuntimeException("Stub!"); }

public boolean fetchUuidsWithSdp(int transport) { throw new RuntimeException("Stub!"); }

public int getActiveAudioDevicePolicy() { throw new RuntimeException("Stub!"); }

public java.lang.String getAddress() { throw new RuntimeException("Stub!"); }

public int getAddressType() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public java.lang.String getAlias() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.lang.String getAnonymizedAddress() { throw new RuntimeException("Stub!"); }

public int getBatteryLevel() { throw new RuntimeException("Stub!"); }

public android.bluetooth.BluetoothClass getBluetoothClass() { throw new RuntimeException("Stub!"); }

public int getBondState() { throw new RuntimeException("Stub!"); }

public int getConnectionHandle(int transport) { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public java.lang.String getIdentityAddress() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.bluetooth.BluetoothDevice.BluetoothAddress getIdentityAddressWithType() { throw new RuntimeException("Stub!"); }

public int getMessageAccessPermission() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public byte[] getMetadata(int key) { throw new RuntimeException("Stub!"); }

public java.lang.String getName() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public java.lang.String getPackageNameOfBondingApplication() { throw new RuntimeException("Stub!"); }

public int getPhonebookAccessPermission() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.bluetooth.BluetoothSinkAudioPolicy getRequestedAudioPolicyAsSink() { throw new RuntimeException("Stub!"); }

public int getSimAccessPermission() { throw new RuntimeException("Stub!"); }

public int getType() { throw new RuntimeException("Stub!"); }

public android.os.ParcelUuid[] getUuids() { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }

public boolean isBondingInitiatedLocally() { throw new RuntimeException("Stub!"); }

public boolean isConnected() { throw new RuntimeException("Stub!"); }

public boolean isEncrypted() { throw new RuntimeException("Stub!"); }

public boolean isInSilenceMode() { throw new RuntimeException("Stub!"); }

public boolean isMicrophonePreferredForCalls() { throw new RuntimeException("Stub!"); }

public int isRequestAudioPolicyAsSinkSupported() { throw new RuntimeException("Stub!"); }

public void prepareToEnterProcess(@android.annotation.NonNull android.content.AttributionSource attributionSource) { throw new RuntimeException("Stub!"); }

public boolean removeBond() { throw new RuntimeException("Stub!"); }

public int requestAudioPolicyAsSink(@android.annotation.NonNull android.bluetooth.BluetoothSinkAudioPolicy policies) { throw new RuntimeException("Stub!"); }

public int setActiveAudioDevicePolicy(int activeAudioDevicePolicy) { throw new RuntimeException("Stub!"); }

public int setAlias(@android.annotation.Nullable java.lang.String alias) { throw new RuntimeException("Stub!"); }

public boolean setLowLatencyAudioAllowed(boolean allowed) { throw new RuntimeException("Stub!"); }

public boolean setMessageAccessPermission(int value) { throw new RuntimeException("Stub!"); }

public boolean setMetadata(int key, @android.annotation.NonNull byte[] value) { throw new RuntimeException("Stub!"); }

public int setMicrophonePreferredForCalls(boolean enabled) { throw new RuntimeException("Stub!"); }

public boolean setPairingConfirmation(boolean confirm) { throw new RuntimeException("Stub!"); }

public boolean setPhonebookAccessPermission(int value) { throw new RuntimeException("Stub!"); }

public boolean setPin(byte[] pin) { throw new RuntimeException("Stub!"); }

public boolean setPin(@android.annotation.NonNull java.lang.String pin) { throw new RuntimeException("Stub!"); }

public boolean setSilenceMode(boolean silence) { throw new RuntimeException("Stub!"); }

public boolean setSimAccessPermission(int value) { throw new RuntimeException("Stub!"); }

public java.lang.String toString() { throw new RuntimeException("Stub!"); }

public void writeToParcel(android.os.Parcel out, int flags) { throw new RuntimeException("Stub!"); }

public static final int ACCESS_ALLOWED = 1; // 0x1

public static final int ACCESS_REJECTED = 2; // 0x2

public static final int ACCESS_UNKNOWN = 0; // 0x0

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.BROADCAST_INTENT_ACTION) public static final java.lang.String ACTION_ACL_CONNECTED = "android.bluetooth.device.action.ACL_CONNECTED";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.BROADCAST_INTENT_ACTION) public static final java.lang.String ACTION_ACL_DISCONNECTED = "android.bluetooth.device.action.ACL_DISCONNECTED";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.BROADCAST_INTENT_ACTION) public static final java.lang.String ACTION_ACL_DISCONNECT_REQUESTED = "android.bluetooth.device.action.ACL_DISCONNECT_REQUESTED";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.BROADCAST_INTENT_ACTION) public static final java.lang.String ACTION_ALIAS_CHANGED = "android.bluetooth.device.action.ALIAS_CHANGED";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.BROADCAST_INTENT_ACTION) public static final java.lang.String ACTION_BATTERY_LEVEL_CHANGED = "android.bluetooth.device.action.BATTERY_LEVEL_CHANGED";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.BROADCAST_INTENT_ACTION) public static final java.lang.String ACTION_BOND_STATE_CHANGED = "android.bluetooth.device.action.BOND_STATE_CHANGED";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.BROADCAST_INTENT_ACTION) public static final java.lang.String ACTION_CLASS_CHANGED = "android.bluetooth.device.action.CLASS_CHANGED";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.BROADCAST_INTENT_ACTION) public static final java.lang.String ACTION_CONNECTION_ACCESS_CANCEL = "android.bluetooth.device.action.CONNECTION_ACCESS_CANCEL";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.BROADCAST_INTENT_ACTION) public static final java.lang.String ACTION_CONNECTION_ACCESS_REPLY = "android.bluetooth.device.action.CONNECTION_ACCESS_REPLY";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.BROADCAST_INTENT_ACTION) public static final java.lang.String ACTION_CONNECTION_ACCESS_REQUEST = "android.bluetooth.device.action.CONNECTION_ACCESS_REQUEST";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.BROADCAST_INTENT_ACTION) public static final java.lang.String ACTION_ENCRYPTION_CHANGE = "android.bluetooth.device.action.ENCRYPTION_CHANGE";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.BROADCAST_INTENT_ACTION) public static final java.lang.String ACTION_FOUND = "android.bluetooth.device.action.FOUND";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.BROADCAST_INTENT_ACTION) public static final java.lang.String ACTION_KEY_MISSING = "android.bluetooth.device.action.KEY_MISSING";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.BROADCAST_INTENT_ACTION) public static final java.lang.String ACTION_NAME_CHANGED = "android.bluetooth.device.action.NAME_CHANGED";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.BROADCAST_INTENT_ACTION) public static final java.lang.String ACTION_PAIRING_CANCEL = "android.bluetooth.device.action.PAIRING_CANCEL";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.BROADCAST_INTENT_ACTION) public static final java.lang.String ACTION_PAIRING_REQUEST = "android.bluetooth.device.action.PAIRING_REQUEST";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.BROADCAST_INTENT_ACTION) public static final java.lang.String ACTION_SILENCE_MODE_CHANGED = "android.bluetooth.device.action.SILENCE_MODE_CHANGED";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.BROADCAST_INTENT_ACTION) public static final java.lang.String ACTION_SWITCH_BUFFER_SIZE = "android.bluetooth.device.action.SWITCH_BUFFER_SIZE";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.BROADCAST_INTENT_ACTION) public static final java.lang.String ACTION_UUID = "android.bluetooth.device.action.UUID";

public static final int ACTIVE_AUDIO_DEVICE_POLICY_ALL_PROFILES_ACTIVE_UPON_CONNECTION = 1; // 0x1

public static final int ACTIVE_AUDIO_DEVICE_POLICY_ALL_PROFILES_INACTIVE_UPON_CONNECTION = 2; // 0x2

public static final int ACTIVE_AUDIO_DEVICE_POLICY_DEFAULT = 0; // 0x0

public static final int ADDRESS_TYPE_ANONYMOUS = 255; // 0xff

public static final int ADDRESS_TYPE_PUBLIC = 0; // 0x0

public static final int ADDRESS_TYPE_RANDOM = 1; // 0x1

public static final int ADDRESS_TYPE_UNKNOWN = 65535; // 0xffff

public static final int BATTERY_LEVEL_BLUETOOTH_OFF = -100; // 0xffffff9c

public static final int BATTERY_LEVEL_UNKNOWN = -1; // 0xffffffff

public static final int BOND_BONDED = 12; // 0xc

public static final int BOND_BONDING = 11; // 0xb

public static final int BOND_NONE = 10; // 0xa

public static final int CONNECTION_ACCESS_NO = 2; // 0x2

public static final int CONNECTION_ACCESS_YES = 1; // 0x1

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.bluetooth.BluetoothDevice> CREATOR;
static { CREATOR = null; }

public static final java.lang.String DEVICE_TYPE_CARKIT = "Carkit";

public static final int DEVICE_TYPE_CLASSIC = 1; // 0x1

public static final java.lang.String DEVICE_TYPE_DEFAULT = "Default";

public static final int DEVICE_TYPE_DUAL = 3; // 0x3

public static final java.lang.String DEVICE_TYPE_HEADSET = "Headset";

public static final java.lang.String DEVICE_TYPE_HEARING_AID = "HearingAid";

public static final int DEVICE_TYPE_LE = 2; // 0x2

public static final java.lang.String DEVICE_TYPE_SPEAKER = "Speaker";

public static final java.lang.String DEVICE_TYPE_STYLUS = "Stylus";

public static final int DEVICE_TYPE_UNKNOWN = 0; // 0x0

public static final java.lang.String DEVICE_TYPE_UNTETHERED_HEADSET = "Untethered Headset";

public static final java.lang.String DEVICE_TYPE_WATCH = "Watch";

public static final int ENCRYPTION_ALGORITHM_AES = 2; // 0x2

public static final int ENCRYPTION_ALGORITHM_E0 = 1; // 0x1

public static final int ENCRYPTION_ALGORITHM_NONE = 0; // 0x0

public static final int ERROR = -2147483648; // 0x80000000

public static final java.lang.String EXTRA_ACCESS_REQUEST_TYPE = "android.bluetooth.device.extra.ACCESS_REQUEST_TYPE";

public static final java.lang.String EXTRA_ALWAYS_ALLOWED = "android.bluetooth.device.extra.ALWAYS_ALLOWED";

public static final java.lang.String EXTRA_BATTERY_LEVEL = "android.bluetooth.device.extra.BATTERY_LEVEL";

public static final java.lang.String EXTRA_BOND_STATE = "android.bluetooth.device.extra.BOND_STATE";

public static final java.lang.String EXTRA_CLASS = "android.bluetooth.device.extra.CLASS";

public static final java.lang.String EXTRA_CONNECTION_ACCESS_RESULT = "android.bluetooth.device.extra.CONNECTION_ACCESS_RESULT";

public static final java.lang.String EXTRA_DEVICE = "android.bluetooth.device.extra.DEVICE";

public static final java.lang.String EXTRA_ENCRYPTION_ALGORITHM = "android.bluetooth.device.extra.EXTRA_ENCRYPTION_ALGORITHM";

public static final java.lang.String EXTRA_ENCRYPTION_ENABLED = "android.bluetooth.device.extra.ENCRYPTION_ENABLED";

public static final java.lang.String EXTRA_ENCRYPTION_STATUS = "android.bluetooth.device.extra.ENCRYPTION_STATUS";

public static final java.lang.String EXTRA_IS_COORDINATED_SET_MEMBER = "android.bluetooth.extra.IS_COORDINATED_SET_MEMBER";

public static final java.lang.String EXTRA_KEY_SIZE = "android.bluetooth.device.extra.KEY_SIZE";

public static final java.lang.String EXTRA_LOW_LATENCY_BUFFER_SIZE = "android.bluetooth.device.extra.LOW_LATENCY_BUFFER_SIZE";

public static final java.lang.String EXTRA_NAME = "android.bluetooth.device.extra.NAME";

public static final java.lang.String EXTRA_PAIRING_INITIATOR = "android.bluetooth.device.extra.PAIRING_INITIATOR";

public static final int EXTRA_PAIRING_INITIATOR_BACKGROUND = 2; // 0x2

public static final int EXTRA_PAIRING_INITIATOR_FOREGROUND = 1; // 0x1

public static final java.lang.String EXTRA_PAIRING_KEY = "android.bluetooth.device.extra.PAIRING_KEY";

public static final java.lang.String EXTRA_PAIRING_VARIANT = "android.bluetooth.device.extra.PAIRING_VARIANT";

public static final java.lang.String EXTRA_PREVIOUS_BOND_STATE = "android.bluetooth.device.extra.PREVIOUS_BOND_STATE";

public static final java.lang.String EXTRA_RSSI = "android.bluetooth.device.extra.RSSI";

public static final java.lang.String EXTRA_TRANSPORT = "android.bluetooth.device.extra.TRANSPORT";

public static final java.lang.String EXTRA_UNBOND_REASON = "android.bluetooth.device.extra.REASON";

public static final java.lang.String EXTRA_UUID = "android.bluetooth.device.extra.UUID";

public static final int METADATA_COMPANION_APP = 4; // 0x4

public static final int METADATA_DEVICE_TYPE = 17; // 0x11

public static final int METADATA_ENHANCED_SETTINGS_UI_URI = 16; // 0x10

public static final int METADATA_EXCLUSIVE_MANAGER = 29; // 0x1d

public static final int METADATA_HARDWARE_VERSION = 3; // 0x3

public static final int METADATA_IS_UNTETHERED_HEADSET = 6; // 0x6

public static final int METADATA_LE_AUDIO = 26; // 0x1a

public static final int METADATA_MAIN_BATTERY = 18; // 0x12

public static final int METADATA_MAIN_CHARGING = 19; // 0x13

public static final int METADATA_MAIN_ICON = 5; // 0x5

public static final int METADATA_MAIN_LOW_BATTERY_THRESHOLD = 20; // 0x14

public static final int METADATA_MANUFACTURER_NAME = 0; // 0x0

public static final int METADATA_MAX_LENGTH = 2048; // 0x800

public static final int METADATA_MODEL_NAME = 1; // 0x1

public static final int METADATA_SOFTWARE_VERSION = 2; // 0x2

public static final int METADATA_UNTETHERED_CASE_BATTERY = 12; // 0xc

public static final int METADATA_UNTETHERED_CASE_CHARGING = 15; // 0xf

public static final int METADATA_UNTETHERED_CASE_ICON = 9; // 0x9

public static final int METADATA_UNTETHERED_CASE_LOW_BATTERY_THRESHOLD = 23; // 0x17

public static final int METADATA_UNTETHERED_LEFT_BATTERY = 10; // 0xa

public static final int METADATA_UNTETHERED_LEFT_CHARGING = 13; // 0xd

public static final int METADATA_UNTETHERED_LEFT_ICON = 7; // 0x7

public static final int METADATA_UNTETHERED_LEFT_LOW_BATTERY_THRESHOLD = 21; // 0x15

public static final int METADATA_UNTETHERED_RIGHT_BATTERY = 11; // 0xb

public static final int METADATA_UNTETHERED_RIGHT_CHARGING = 14; // 0xe

public static final int METADATA_UNTETHERED_RIGHT_ICON = 8; // 0x8

public static final int METADATA_UNTETHERED_RIGHT_LOW_BATTERY_THRESHOLD = 22; // 0x16

public static final int PAIRING_VARIANT_CONSENT = 3; // 0x3

public static final int PAIRING_VARIANT_DISPLAY_PASSKEY = 4; // 0x4

public static final int PAIRING_VARIANT_DISPLAY_PIN = 5; // 0x5

public static final int PAIRING_VARIANT_OOB_CONSENT = 6; // 0x6

public static final int PAIRING_VARIANT_PASSKEY = 1; // 0x1

public static final int PAIRING_VARIANT_PASSKEY_CONFIRMATION = 2; // 0x2

public static final int PAIRING_VARIANT_PIN = 0; // 0x0

public static final int PAIRING_VARIANT_PIN_16_DIGITS = 7; // 0x7

public static final int PHY_LE_1M = 1; // 0x1

public static final int PHY_LE_1M_MASK = 1; // 0x1

public static final int PHY_LE_2M = 2; // 0x2

public static final int PHY_LE_2M_MASK = 2; // 0x2

public static final int PHY_LE_CODED = 3; // 0x3

public static final int PHY_LE_CODED_MASK = 4; // 0x4

public static final int PHY_OPTION_NO_PREFERRED = 0; // 0x0

public static final int PHY_OPTION_S2 = 1; // 0x1

public static final int PHY_OPTION_S8 = 2; // 0x2

public static final int REQUEST_TYPE_MESSAGE_ACCESS = 3; // 0x3

public static final int REQUEST_TYPE_PHONEBOOK_ACCESS = 2; // 0x2

public static final int REQUEST_TYPE_PROFILE_CONNECTION = 1; // 0x1

public static final int REQUEST_TYPE_SIM_ACCESS = 4; // 0x4

public static final int TRANSPORT_AUTO = 0; // 0x0

public static final int TRANSPORT_BREDR = 1; // 0x1

public static final int TRANSPORT_LE = 2; // 0x2

public static final int UNBOND_REASON_AUTH_CANCELED = 3; // 0x3

public static final int UNBOND_REASON_AUTH_FAILED = 1; // 0x1

public static final int UNBOND_REASON_AUTH_REJECTED = 2; // 0x2

public static final int UNBOND_REASON_AUTH_TIMEOUT = 6; // 0x6

public static final int UNBOND_REASON_DISCOVERY_IN_PROGRESS = 5; // 0x5

public static final int UNBOND_REASON_REMOTE_AUTH_CANCELED = 8; // 0x8

public static final int UNBOND_REASON_REMOTE_DEVICE_DOWN = 4; // 0x4

public static final int UNBOND_REASON_REMOVED = 9; // 0x9

public static final int UNBOND_REASON_REPEATED_ATTEMPTS = 7; // 0x7
@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class BluetoothAddress implements android.os.Parcelable {

public BluetoothAddress(@android.annotation.Nullable java.lang.String address, int addressType) { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public java.lang.String getAddress() { throw new RuntimeException("Stub!"); }

public int getAddressType() { throw new RuntimeException("Stub!"); }

public void writeToParcel(@android.annotation.NonNull android.os.Parcel out, int flags) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.bluetooth.BluetoothDevice.BluetoothAddress> CREATOR;
static { CREATOR = null; }
}

}

