/*
 * Copyright 2021 HIMSA II K/S - www.himsa.com.
 * Represented by EHIMA - www.ehima.com
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.bluetooth;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class BluetoothHapClient implements java.lang.AutoCloseable, android.bluetooth.BluetoothProfile {

BluetoothHapClient() { throw new RuntimeException("Stub!"); }

public void close() { throw new RuntimeException("Stub!"); }

protected void finalize() { throw new RuntimeException("Stub!"); }

public int getActivePresetIndex(@android.annotation.NonNull android.bluetooth.BluetoothDevice device) { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.bluetooth.BluetoothHapPresetInfo getActivePresetInfo(@android.annotation.NonNull android.bluetooth.BluetoothDevice device) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.List<android.bluetooth.BluetoothHapPresetInfo> getAllPresetInfo(@android.annotation.NonNull android.bluetooth.BluetoothDevice device) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.List<android.bluetooth.BluetoothDevice> getConnectedDevices() { throw new RuntimeException("Stub!"); }

public int getConnectionPolicy(@android.annotation.Nullable android.bluetooth.BluetoothDevice device) { throw new RuntimeException("Stub!"); }

public int getConnectionState(@android.annotation.NonNull android.bluetooth.BluetoothDevice device) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.List<android.bluetooth.BluetoothDevice> getDevicesMatchingConnectionStates(@android.annotation.NonNull int[] states) { throw new RuntimeException("Stub!"); }

public int getHapGroup(@android.annotation.NonNull android.bluetooth.BluetoothDevice device) { throw new RuntimeException("Stub!"); }

public int getHearingAidType(@android.annotation.NonNull android.bluetooth.BluetoothDevice device) { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.bluetooth.BluetoothHapPresetInfo getPresetInfo(@android.annotation.NonNull android.bluetooth.BluetoothDevice device, int presetIndex) { throw new RuntimeException("Stub!"); }

public void registerCallback(@android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.bluetooth.BluetoothHapClient.Callback callback) { throw new RuntimeException("Stub!"); }

public void selectPreset(@android.annotation.NonNull android.bluetooth.BluetoothDevice device, int presetIndex) { throw new RuntimeException("Stub!"); }

public void selectPresetForGroup(int groupId, int presetIndex) { throw new RuntimeException("Stub!"); }

public boolean setConnectionPolicy(@android.annotation.NonNull android.bluetooth.BluetoothDevice device, int connectionPolicy) { throw new RuntimeException("Stub!"); }

public void setPresetName(@android.annotation.NonNull android.bluetooth.BluetoothDevice device, int presetIndex, @android.annotation.NonNull java.lang.String name) { throw new RuntimeException("Stub!"); }

public void setPresetNameForGroup(int groupId, int presetIndex, @android.annotation.NonNull java.lang.String name) { throw new RuntimeException("Stub!"); }

public boolean supportsDynamicPresets(@android.annotation.NonNull android.bluetooth.BluetoothDevice device) { throw new RuntimeException("Stub!"); }

public boolean supportsIndependentPresets(@android.annotation.NonNull android.bluetooth.BluetoothDevice device) { throw new RuntimeException("Stub!"); }

public boolean supportsSynchronizedPresets(@android.annotation.NonNull android.bluetooth.BluetoothDevice device) { throw new RuntimeException("Stub!"); }

public boolean supportsWritablePresets(@android.annotation.NonNull android.bluetooth.BluetoothDevice device) { throw new RuntimeException("Stub!"); }

public void switchToNextPreset(@android.annotation.NonNull android.bluetooth.BluetoothDevice device) { throw new RuntimeException("Stub!"); }

public void switchToNextPresetForGroup(int groupId) { throw new RuntimeException("Stub!"); }

public void switchToPreviousPreset(@android.annotation.NonNull android.bluetooth.BluetoothDevice device) { throw new RuntimeException("Stub!"); }

public void switchToPreviousPresetForGroup(int groupId) { throw new RuntimeException("Stub!"); }

public void unregisterCallback(@android.annotation.NonNull android.bluetooth.BluetoothHapClient.Callback callback) { throw new RuntimeException("Stub!"); }

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.BROADCAST_INTENT_ACTION) public static final java.lang.String ACTION_HAP_CONNECTION_STATE_CHANGED = "android.bluetooth.action.HAP_CONNECTION_STATE_CHANGED";

public static final int PRESET_INDEX_UNAVAILABLE = 0; // 0x0

public static final int TYPE_BANDED = 2; // 0x2

public static final int TYPE_BINAURAL = 0; // 0x0

public static final int TYPE_MONAURAL = 1; // 0x1

public static final int TYPE_RFU = 3; // 0x3
@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface Callback {

public void onPresetInfoChanged(@android.annotation.NonNull android.bluetooth.BluetoothDevice device, @android.annotation.NonNull java.util.List<android.bluetooth.BluetoothHapPresetInfo> presetInfoList, int reason);

public void onPresetSelected(@android.annotation.NonNull android.bluetooth.BluetoothDevice device, int presetIndex, int reason);

public void onPresetSelectionFailed(@android.annotation.NonNull android.bluetooth.BluetoothDevice device, int reason);

public void onPresetSelectionForGroupFailed(int hapGroupId, int reason);

public void onSetPresetNameFailed(@android.annotation.NonNull android.bluetooth.BluetoothDevice device, int reason);

public void onSetPresetNameForGroupFailed(int hapGroupId, int reason);
}

}

