/*
 * Copyright (C) 2019 The Linux Foundation
 * Copyright (C) 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.bluetooth;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class BluetoothQualityReport implements android.os.Parcelable {

BluetoothQualityReport() { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.bluetooth.BluetoothClass getBluetoothClass() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.bluetooth.BluetoothQualityReport.BqrCommon getBqrCommon() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.os.Parcelable getBqrEvent() { throw new RuntimeException("Stub!"); }

public int getLmpSubVersion() { throw new RuntimeException("Stub!"); }

public int getLmpVersion() { throw new RuntimeException("Stub!"); }

public int getManufacturerId() { throw new RuntimeException("Stub!"); }

public int getQualityReportId() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public java.lang.String getRemoteAddress() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public java.lang.String getRemoteName() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public static java.lang.String qualityReportIdToString(int id) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.lang.String toString() { throw new RuntimeException("Stub!"); }

public void writeToParcel(@android.annotation.NonNull android.os.Parcel out, int flags) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.bluetooth.BluetoothQualityReport> CREATOR;
static { CREATOR = null; }

public static final int QUALITY_REPORT_ID_A2DP_CHOPPY = 3; // 0x3

public static final int QUALITY_REPORT_ID_APPROACH_LSTO = 2; // 0x2

public static final int QUALITY_REPORT_ID_CONN_FAIL = 8; // 0x8

public static final int QUALITY_REPORT_ID_ENERGY_MONITOR = 6; // 0x6

public static final int QUALITY_REPORT_ID_MONITOR = 1; // 0x1

public static final int QUALITY_REPORT_ID_RF_STATS = 9; // 0x9

public static final int QUALITY_REPORT_ID_SCO_CHOPPY = 4; // 0x4
@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class BqrCommon implements android.os.Parcelable {

BqrCommon() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public static java.lang.String connectionRoleToString(int connectionRole) { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

public int getAfhSelectUnidealChannelCount() { throw new RuntimeException("Stub!"); }

public int getCalFailedItemCount() { throw new RuntimeException("Stub!"); }

public int getCoexInfoMask() { throw new RuntimeException("Stub!"); }

public int getConnectionHandle() { throw new RuntimeException("Stub!"); }

public int getConnectionRole() { throw new RuntimeException("Stub!"); }

public long getCrcErrorPackets() { throw new RuntimeException("Stub!"); }

public long getFlowOffCount() { throw new RuntimeException("Stub!"); }

public long getLastFlowOnTimestamp() { throw new RuntimeException("Stub!"); }

public long getLastTxAckTimestamp() { throw new RuntimeException("Stub!"); }

public int getLsto() { throw new RuntimeException("Stub!"); }

public long getNakCount() { throw new RuntimeException("Stub!"); }

public long getNoRxCount() { throw new RuntimeException("Stub!"); }

public long getOverflowCount() { throw new RuntimeException("Stub!"); }

public int getPacketType() { throw new RuntimeException("Stub!"); }

public long getPiconetClock() { throw new RuntimeException("Stub!"); }

public long getRetransmissionCount() { throw new RuntimeException("Stub!"); }

public int getRssi() { throw new RuntimeException("Stub!"); }

public long getRxDupPackets() { throw new RuntimeException("Stub!"); }

public long getRxUnRecvPackets() { throw new RuntimeException("Stub!"); }

public int getSnr() { throw new RuntimeException("Stub!"); }

public long getTxFlushPackets() { throw new RuntimeException("Stub!"); }

public long getTxLastSubeventPackets() { throw new RuntimeException("Stub!"); }

public int getTxPowerLevel() { throw new RuntimeException("Stub!"); }

public long getTxTotalPackets() { throw new RuntimeException("Stub!"); }

public long getTxUnackPackets() { throw new RuntimeException("Stub!"); }

public long getUnderflowCount() { throw new RuntimeException("Stub!"); }

public int getUnusedAfhChannelCount() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public static java.lang.String packetTypeToString(int packetType) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.lang.String toString() { throw new RuntimeException("Stub!"); }

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

public static final int CONNECTION_ROLE_CENTRAL = 0; // 0x0

public static final int CONNECTION_ROLE_PERIPHERAL = 1; // 0x1

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.bluetooth.BluetoothQualityReport.BqrCommon> CREATOR;
static { CREATOR = null; }
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class BqrConnectFail implements android.os.Parcelable {

BqrConnectFail() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public static java.lang.String connectFailIdToString(int id) { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

public int getFailReason() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.lang.String toString() { throw new RuntimeException("Stub!"); }

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

public static final int CONNECT_FAIL_ID_ACL_ALREADY_EXIST = 11; // 0xb

public static final int CONNECT_FAIL_ID_CONNECTION_TIMEOUT = 8; // 0x8

public static final int CONNECT_FAIL_ID_CONTROLLER_BUSY = 58; // 0x3a

public static final int CONNECT_FAIL_ID_NO_ERROR = 0; // 0x0

public static final int CONNECT_FAIL_ID_PAGE_TIMEOUT = 4; // 0x4

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.bluetooth.BluetoothQualityReport.BqrConnectFail> CREATOR;
static { CREATOR = null; }
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class BqrEnergyMonitor implements android.os.Parcelable {

BqrEnergyMonitor() { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

public long getActiveStateEnterCount() { throw new RuntimeException("Stub!"); }

public long getActiveStateTotalTimeMillis() { throw new RuntimeException("Stub!"); }

public int getAverageCurrentConsumptionMicroamps() { throw new RuntimeException("Stub!"); }

public int getBredrAverageTxPowerLeveldBm() { throw new RuntimeException("Stub!"); }

public long getBredrRxStateEnterCount() { throw new RuntimeException("Stub!"); }

public long getBredrRxTotalTimeMillis() { throw new RuntimeException("Stub!"); }

public long getBredrTxStateEnterCount() { throw new RuntimeException("Stub!"); }

public long getBredrTxTotalTimeMillis() { throw new RuntimeException("Stub!"); }

public long getIdleStateEnterCount() { throw new RuntimeException("Stub!"); }

public long getIdleStateTotalTimeMillis() { throw new RuntimeException("Stub!"); }

public int getLeAverageTxPowerLeveldBm() { throw new RuntimeException("Stub!"); }

public long getLeRxStateEnterCount() { throw new RuntimeException("Stub!"); }

public long getLeRxTotalTimeMillis() { throw new RuntimeException("Stub!"); }

public long getLeTsTotalTimeMillis() { throw new RuntimeException("Stub!"); }

public long getLeTxStateEnterCount() { throw new RuntimeException("Stub!"); }

public long getPowerDataTotalTimeMillis() { throw new RuntimeException("Stub!"); }

public long getRxDualChainActiveDurationMillis() { throw new RuntimeException("Stub!"); }

public long getRxSingleChainActiveDurationMillis() { throw new RuntimeException("Stub!"); }

public long getTxExternalPaDualChainActiveDurationMillis() { throw new RuntimeException("Stub!"); }

public long getTxExternalPaSingleChainActiveDurationMillis() { throw new RuntimeException("Stub!"); }

public long getTxInternalPaDualChainActiveDurationMillis() { throw new RuntimeException("Stub!"); }

public long getTxInternalPaSingleChainActiveDurationMillis() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.lang.String toString() { throw new RuntimeException("Stub!"); }

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.bluetooth.BluetoothQualityReport.BqrEnergyMonitor> CREATOR;
static { CREATOR = null; }
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class BqrRfStats implements android.os.Parcelable {

BqrRfStats() { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

public int getExtensionInfo() { throw new RuntimeException("Stub!"); }

public long getPacketsWithRssi50To55dBm() { throw new RuntimeException("Stub!"); }

public long getPacketsWithRssi55To60dBm() { throw new RuntimeException("Stub!"); }

public long getPacketsWithRssi60To65dBm() { throw new RuntimeException("Stub!"); }

public long getPacketsWithRssi65To70dBm() { throw new RuntimeException("Stub!"); }

public long getPacketsWithRssi70To75dBm() { throw new RuntimeException("Stub!"); }

public long getPacketsWithRssi75To80dBm() { throw new RuntimeException("Stub!"); }

public long getPacketsWithRssi80To85dBm() { throw new RuntimeException("Stub!"); }

public long getPacketsWithRssi85To90dBm() { throw new RuntimeException("Stub!"); }

public long getPacketsWithRssiAboveMinus50dBm() { throw new RuntimeException("Stub!"); }

public long getPacketsWithRssiBelowMinus90dBm() { throw new RuntimeException("Stub!"); }

public long getPacketsWithRssiDelta2To5dBm() { throw new RuntimeException("Stub!"); }

public long getPacketsWithRssiDelta5To8dBm() { throw new RuntimeException("Stub!"); }

public long getPacketsWithRssiDelta8To11dBm() { throw new RuntimeException("Stub!"); }

public long getPacketsWithRssiDeltaAbove11dBm() { throw new RuntimeException("Stub!"); }

public long getPacketsWithRssiDeltaBelow2dBm() { throw new RuntimeException("Stub!"); }

public long getPerformanceDurationMillis() { throw new RuntimeException("Stub!"); }

public long getTxPowerExternalPaBeamformingCount() { throw new RuntimeException("Stub!"); }

public long getTxPowerExternalPaDiversityCount() { throw new RuntimeException("Stub!"); }

public long getTxPowerInternalPaBeamformingCount() { throw new RuntimeException("Stub!"); }

public long getTxPowerInternalPaDiversityCount() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.lang.String toString() { throw new RuntimeException("Stub!"); }

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.bluetooth.BluetoothQualityReport.BqrRfStats> CREATOR;
static { CREATOR = null; }
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class BqrVsA2dpChoppy implements android.os.Parcelable {

BqrVsA2dpChoppy() { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

public int getAclTxQueueLength() { throw new RuntimeException("Stub!"); }

public long getArrivalTime() { throw new RuntimeException("Stub!"); }

public int getGlitchCount() { throw new RuntimeException("Stub!"); }

public int getLinkQuality() { throw new RuntimeException("Stub!"); }

public int getRxCxmDenials() { throw new RuntimeException("Stub!"); }

public long getScheduleTime() { throw new RuntimeException("Stub!"); }

public int getTxCxmDenials() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public static java.lang.String linkQualityToString(int linkQuality) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.lang.String toString() { throw new RuntimeException("Stub!"); }

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.bluetooth.BluetoothQualityReport.BqrVsA2dpChoppy> CREATOR;
static { CREATOR = null; }
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class BqrVsLsto implements android.os.Parcelable {

BqrVsLsto() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public static java.lang.String connStateToString(int connectionState) { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

public long getBasebandStats() { throw new RuntimeException("Stub!"); }

public int getConnState() { throw new RuntimeException("Stub!"); }

public int getCxmDenials() { throw new RuntimeException("Stub!"); }

public long getLastTxAckTimestamp() { throw new RuntimeException("Stub!"); }

public long getNativeClock() { throw new RuntimeException("Stub!"); }

public int getRfLoss() { throw new RuntimeException("Stub!"); }

public long getSlotsUsed() { throw new RuntimeException("Stub!"); }

public int getTxSkipped() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.lang.String toString() { throw new RuntimeException("Stub!"); }

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.bluetooth.BluetoothQualityReport.BqrVsLsto> CREATOR;
static { CREATOR = null; }
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class BqrVsScoChoppy implements android.os.Parcelable {

BqrVsScoChoppy() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public static java.lang.String airFormatToString(int airFormat) { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

public int getAirFormat() { throw new RuntimeException("Stub!"); }

public int getGlitchCount() { throw new RuntimeException("Stub!"); }

public int getGoodRxFrameCount() { throw new RuntimeException("Stub!"); }

public int getInstanceCount() { throw new RuntimeException("Stub!"); }

public int getIntervalEsco() { throw new RuntimeException("Stub!"); }

public int getLateDispatch() { throw new RuntimeException("Stub!"); }

public int getLpaIntrMiss() { throw new RuntimeException("Stub!"); }

public int getMicIntrMiss() { throw new RuntimeException("Stub!"); }

public int getMissedInstanceCount() { throw new RuntimeException("Stub!"); }

public int getPlcDiscardCount() { throw new RuntimeException("Stub!"); }

public int getPlcFillCount() { throw new RuntimeException("Stub!"); }

public int getRxCxmDenials() { throw new RuntimeException("Stub!"); }

public int getRxRetransmitSlotCount() { throw new RuntimeException("Stub!"); }

public int getSprIntrMiss() { throw new RuntimeException("Stub!"); }

public int getTxAbortCount() { throw new RuntimeException("Stub!"); }

public int getTxCxmDenials() { throw new RuntimeException("Stub!"); }

public int getTxRetransmitSlotCount() { throw new RuntimeException("Stub!"); }

public int getWindowEsco() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.lang.String toString() { throw new RuntimeException("Stub!"); }

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.bluetooth.BluetoothQualityReport.BqrVsScoChoppy> CREATOR;
static { CREATOR = null; }
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

public Builder(@android.annotation.NonNull byte[] rawData) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.bluetooth.BluetoothQualityReport build() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.bluetooth.BluetoothQualityReport.Builder setBluetoothClass(@android.annotation.Nullable android.bluetooth.BluetoothClass bluetoothClass) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.bluetooth.BluetoothQualityReport.Builder setLmpSubVersion(int lmpSubVer) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.bluetooth.BluetoothQualityReport.Builder setLmpVersion(int lmpVer) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.bluetooth.BluetoothQualityReport.Builder setManufacturerId(int manufacturerId) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.bluetooth.BluetoothQualityReport.Builder setRemoteAddress(@android.annotation.Nullable java.lang.String remoteAddr) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.bluetooth.BluetoothQualityReport.Builder setRemoteName(@android.annotation.Nullable java.lang.String remoteName) { throw new RuntimeException("Stub!"); }
}

}

