/*
 * Copyright (C) 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.bluetooth.le;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class DistanceMeasurementResult implements android.os.Parcelable {

DistanceMeasurementResult() { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

public double getAltitudeAngle() { throw new RuntimeException("Stub!"); }

public double getAzimuthAngle() { throw new RuntimeException("Stub!"); }

public double getConfidenceLevel() { throw new RuntimeException("Stub!"); }

public double getDelaySpreadMeters() { throw new RuntimeException("Stub!"); }

public int getDetectedAttackLevel() { throw new RuntimeException("Stub!"); }

public double getErrorAltitudeAngle() { throw new RuntimeException("Stub!"); }

public double getErrorAzimuthAngle() { throw new RuntimeException("Stub!"); }

public double getErrorMeters() { throw new RuntimeException("Stub!"); }

public long getMeasurementTimestampNanos() { throw new RuntimeException("Stub!"); }

public double getResultMeters() { throw new RuntimeException("Stub!"); }

public double getVelocityMetersPerSecond() { throw new RuntimeException("Stub!"); }

public java.lang.String toString() { throw new RuntimeException("Stub!"); }

public void writeToParcel(android.os.Parcel out, int flags) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.bluetooth.le.DistanceMeasurementResult> CREATOR;
static { CREATOR = null; }

public static final int NADM_ATTACK_IS_EXTREMELY_LIKELY = 6; // 0x6

public static final int NADM_ATTACK_IS_EXTREMELY_UNLIKELY = 0; // 0x0

public static final int NADM_ATTACK_IS_LIKELY = 4; // 0x4

public static final int NADM_ATTACK_IS_POSSIBLE = 3; // 0x3

public static final int NADM_ATTACK_IS_UNLIKELY = 2; // 0x2

public static final int NADM_ATTACK_IS_VERY_LIKELY = 5; // 0x5

public static final int NADM_ATTACK_IS_VERY_UNLIKELY = 1; // 0x1

public static final int NADM_UNKNOWN = 255; // 0xff
@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

public Builder(double meters, double errorMeters) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.bluetooth.le.DistanceMeasurementResult build() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.bluetooth.le.DistanceMeasurementResult.Builder setAltitudeAngle(double angle) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.bluetooth.le.DistanceMeasurementResult.Builder setAzimuthAngle(double angle) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.bluetooth.le.DistanceMeasurementResult.Builder setConfidenceLevel(double confidenceLevel) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.bluetooth.le.DistanceMeasurementResult.Builder setDelaySpreadMeters(double delaySpreadMeters) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.bluetooth.le.DistanceMeasurementResult.Builder setDetectedAttackLevel(int detectedAttackLevel) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.bluetooth.le.DistanceMeasurementResult.Builder setErrorAltitudeAngle(double angle) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.bluetooth.le.DistanceMeasurementResult.Builder setErrorAzimuthAngle(double angle) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.bluetooth.le.DistanceMeasurementResult.Builder setMeasurementTimestampNanos(long measurementTimestampNanos) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.bluetooth.le.DistanceMeasurementResult.Builder setVelocityMetersPerSecond(double velocityMetersPerSecond) { throw new RuntimeException("Stub!"); }
}

}

