/*
 * Copyright (C) 2021 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.net.nsd;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class NsdManager {

NsdManager() { throw new RuntimeException("Stub!"); }

public void registerOffloadEngine(@android.annotation.NonNull java.lang.String ifaceName, long offloadType, long offloadCapability, @android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.net.nsd.OffloadEngine engine) { throw new RuntimeException("Stub!"); }

public void unregisterOffloadEngine(@android.annotation.NonNull android.net.nsd.OffloadEngine engine) { throw new RuntimeException("Stub!"); }

public void registerService(android.net.nsd.NsdServiceInfo serviceInfo, int protocolType, android.net.nsd.NsdManager.RegistrationListener listener) { throw new RuntimeException("Stub!"); }

public void registerService(@android.annotation.NonNull android.net.nsd.NsdServiceInfo serviceInfo, int protocolType, @android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.net.nsd.NsdManager.RegistrationListener listener) { throw new RuntimeException("Stub!"); }

public void unregisterService(android.net.nsd.NsdManager.RegistrationListener listener) { throw new RuntimeException("Stub!"); }

public void discoverServices(java.lang.String serviceType, int protocolType, android.net.nsd.NsdManager.DiscoveryListener listener) { throw new RuntimeException("Stub!"); }

public void discoverServices(@android.annotation.NonNull java.lang.String serviceType, int protocolType, @android.annotation.Nullable android.net.Network network, @android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.net.nsd.NsdManager.DiscoveryListener listener) { throw new RuntimeException("Stub!"); }

public void discoverServices(@android.annotation.NonNull java.lang.String serviceType, int protocolType, @android.annotation.NonNull android.net.NetworkRequest networkRequest, @android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.net.nsd.NsdManager.DiscoveryListener listener) { throw new RuntimeException("Stub!"); }

public void stopServiceDiscovery(android.net.nsd.NsdManager.DiscoveryListener listener) { throw new RuntimeException("Stub!"); }

@Deprecated
public void resolveService(android.net.nsd.NsdServiceInfo serviceInfo, android.net.nsd.NsdManager.ResolveListener listener) { throw new RuntimeException("Stub!"); }

@Deprecated
public void resolveService(@android.annotation.NonNull android.net.nsd.NsdServiceInfo serviceInfo, @android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.net.nsd.NsdManager.ResolveListener listener) { throw new RuntimeException("Stub!"); }

public void stopServiceResolution(@android.annotation.NonNull android.net.nsd.NsdManager.ResolveListener listener) { throw new RuntimeException("Stub!"); }

public void registerServiceInfoCallback(@android.annotation.NonNull android.net.nsd.NsdServiceInfo serviceInfo, @android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.net.nsd.NsdManager.ServiceInfoCallback listener) { throw new RuntimeException("Stub!"); }

public void unregisterServiceInfoCallback(@android.annotation.NonNull android.net.nsd.NsdManager.ServiceInfoCallback listener) { throw new RuntimeException("Stub!"); }

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.BROADCAST_INTENT_ACTION) public static final java.lang.String ACTION_NSD_STATE_CHANGED = "android.net.nsd.STATE_CHANGED";

public static final java.lang.String EXTRA_NSD_STATE = "nsd_state";

public static final int FAILURE_ALREADY_ACTIVE = 3; // 0x3

public static final int FAILURE_BAD_PARAMETERS = 6; // 0x6

public static final int FAILURE_INTERNAL_ERROR = 0; // 0x0

public static final int FAILURE_MAX_LIMIT = 4; // 0x4

public static final int FAILURE_OPERATION_NOT_RUNNING = 5; // 0x5

public static final int NSD_STATE_DISABLED = 1; // 0x1

public static final int NSD_STATE_ENABLED = 2; // 0x2

public static final int PROTOCOL_DNS_SD = 1; // 0x1
@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface DiscoveryListener {

public void onStartDiscoveryFailed(java.lang.String serviceType, int errorCode);

public void onStopDiscoveryFailed(java.lang.String serviceType, int errorCode);

public void onDiscoveryStarted(java.lang.String serviceType);

public void onDiscoveryStopped(java.lang.String serviceType);

public void onServiceFound(android.net.nsd.NsdServiceInfo serviceInfo);

public void onServiceLost(android.net.nsd.NsdServiceInfo serviceInfo);
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface RegistrationListener {

public void onRegistrationFailed(android.net.nsd.NsdServiceInfo serviceInfo, int errorCode);

public void onUnregistrationFailed(android.net.nsd.NsdServiceInfo serviceInfo, int errorCode);

public void onServiceRegistered(android.net.nsd.NsdServiceInfo serviceInfo);

public void onServiceUnregistered(android.net.nsd.NsdServiceInfo serviceInfo);
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface ResolveListener {

public void onResolveFailed(android.net.nsd.NsdServiceInfo serviceInfo, int errorCode);

public void onServiceResolved(android.net.nsd.NsdServiceInfo serviceInfo);

public default void onResolutionStopped(@android.annotation.NonNull android.net.nsd.NsdServiceInfo serviceInfo) { throw new RuntimeException("Stub!"); }

public default void onStopResolutionFailed(@android.annotation.NonNull android.net.nsd.NsdServiceInfo serviceInfo, int errorCode) { throw new RuntimeException("Stub!"); }
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface ServiceInfoCallback {

public void onServiceInfoCallbackRegistrationFailed(int errorCode);

public void onServiceUpdated(@android.annotation.NonNull android.net.nsd.NsdServiceInfo serviceInfo);

public void onServiceLost();

public void onServiceInfoCallbackUnregistered();
}

}

