/*
 * Copyright (C) 2021 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.nearby;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class ScanRequest implements android.os.Parcelable {

ScanRequest() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public static java.lang.String scanModeToString(int scanMode) { throw new RuntimeException("Stub!"); }

public static boolean isValidScanType(int scanType) { throw new RuntimeException("Stub!"); }

public static boolean isValidScanMode(int scanMode) { throw new RuntimeException("Stub!"); }

public int getScanType() { throw new RuntimeException("Stub!"); }

public int getScanMode() { throw new RuntimeException("Stub!"); }

public boolean isBleEnabled() { throw new RuntimeException("Stub!"); }

public boolean isOffloadOnly() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.List<android.nearby.ScanFilter> getScanFilters() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.os.WorkSource getWorkSource() { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

public java.lang.String toString() { throw new RuntimeException("Stub!"); }

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

public boolean equals(java.lang.Object other) { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.nearby.ScanRequest> CREATOR;
static { CREATOR = null; }

public static final int SCAN_MODE_BALANCED = 1; // 0x1

public static final int SCAN_MODE_LOW_LATENCY = 2; // 0x2

public static final int SCAN_MODE_LOW_POWER = 0; // 0x0

public static final int SCAN_MODE_NO_POWER = -1; // 0xffffffff

public static final int SCAN_TYPE_FAST_PAIR = 1; // 0x1

public static final int SCAN_TYPE_NEARBY_PRESENCE = 2; // 0x2
@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

public Builder() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.nearby.ScanRequest.Builder setScanType(int scanType) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.nearby.ScanRequest.Builder setScanMode(int scanMode) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.nearby.ScanRequest.Builder setBleEnabled(boolean bleEnabled) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.nearby.ScanRequest.Builder setOffloadOnly(boolean offloadOnly) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.nearby.ScanRequest.Builder setWorkSource(@android.annotation.Nullable android.os.WorkSource workSource) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.nearby.ScanRequest.Builder addScanFilter(@android.annotation.NonNull android.nearby.ScanFilter scanFilter) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.nearby.ScanRequest build() { throw new RuntimeException("Stub!"); }
}

}

