/*
 * Copyright (C) 2019 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package android.net;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public class TetheringManager {

public TetheringManager(@android.annotation.NonNull android.content.Context context, @android.annotation.NonNull java.util.function.Supplier<android.os.IBinder> connectorSupplier) { throw new RuntimeException("Stub!"); }

protected void finalize() throws java.lang.Throwable { throw new RuntimeException("Stub!"); }

@Deprecated
public int tether(@android.annotation.NonNull java.lang.String iface) { throw new RuntimeException("Stub!"); }

@Deprecated
public int untether(@android.annotation.NonNull java.lang.String iface) { throw new RuntimeException("Stub!"); }

@Deprecated
public int setUsbTethering(boolean enable) { throw new RuntimeException("Stub!"); }

public void startTethering(@android.annotation.NonNull android.net.TetheringManager.TetheringRequest request, @android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.net.TetheringManager.StartTetheringCallback callback) { throw new RuntimeException("Stub!"); }

public void startTethering(int type, @android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.net.TetheringManager.StartTetheringCallback callback) { throw new RuntimeException("Stub!"); }

public void stopTethering(int type) { throw new RuntimeException("Stub!"); }

public void requestLatestTetheringEntitlementResult(int type, boolean showEntitlementUi, @android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.net.TetheringManager.OnTetheringEntitlementResultListener listener) { throw new RuntimeException("Stub!"); }

public void requestLatestTetheringEntitlementResult(int type, @android.annotation.NonNull android.os.ResultReceiver receiver, boolean showEntitlementUi) { throw new RuntimeException("Stub!"); }

public void registerTetheringEventCallback(@android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.net.TetheringManager.TetheringEventCallback callback) { throw new RuntimeException("Stub!"); }

public void unregisterTetheringEventCallback(@android.annotation.NonNull android.net.TetheringManager.TetheringEventCallback callback) { throw new RuntimeException("Stub!"); }

public int getLastTetherError(@android.annotation.NonNull java.lang.String iface) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.lang.String[] getTetherableUsbRegexs() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.lang.String[] getTetherableWifiRegexs() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.lang.String[] getTetherableBluetoothRegexs() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.lang.String[] getTetherableIfaces() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.lang.String[] getTetheredIfaces() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.lang.String[] getTetheringErroredIfaces() { throw new RuntimeException("Stub!"); }

public boolean isTetheringSupported() { throw new RuntimeException("Stub!"); }

public boolean isTetheringSupported(@android.annotation.NonNull java.lang.String callerPkg) { throw new RuntimeException("Stub!"); }

public void stopAllTethering() { throw new RuntimeException("Stub!"); }

@Deprecated public static final java.lang.String ACTION_TETHER_STATE_CHANGED = "android.net.conn.TETHER_STATE_CHANGED";

public static final int CONNECTIVITY_SCOPE_GLOBAL = 1; // 0x1

public static final int CONNECTIVITY_SCOPE_LOCAL = 2; // 0x2

public static final java.lang.String EXTRA_ACTIVE_LOCAL_ONLY = "android.net.extra.ACTIVE_LOCAL_ONLY";

public static final java.lang.String EXTRA_ACTIVE_TETHER = "tetherArray";

public static final java.lang.String EXTRA_AVAILABLE_TETHER = "availableArray";

public static final java.lang.String EXTRA_ERRORED_TETHER = "erroredArray";

public static final int TETHERING_BLUETOOTH = 2; // 0x2

public static final int TETHERING_ETHERNET = 5; // 0x5

public static final int TETHERING_INVALID = -1; // 0xffffffff

public static final int TETHERING_NCM = 4; // 0x4

public static final int TETHERING_USB = 1; // 0x1

public static final int TETHERING_WIFI = 0; // 0x0

public static final int TETHERING_WIFI_P2P = 3; // 0x3

public static final int TETHER_ERROR_DHCPSERVER_ERROR = 12; // 0xc

public static final int TETHER_ERROR_DISABLE_FORWARDING_ERROR = 9; // 0x9

public static final int TETHER_ERROR_ENABLE_FORWARDING_ERROR = 8; // 0x8

public static final int TETHER_ERROR_ENTITLEMENT_UNKNOWN = 13; // 0xd

public static final int TETHER_ERROR_IFACE_CFG_ERROR = 10; // 0xa

public static final int TETHER_ERROR_INTERNAL_ERROR = 5; // 0x5

public static final int TETHER_ERROR_NO_ACCESS_TETHERING_PERMISSION = 15; // 0xf

public static final int TETHER_ERROR_NO_CHANGE_TETHERING_PERMISSION = 14; // 0xe

public static final int TETHER_ERROR_NO_ERROR = 0; // 0x0

public static final int TETHER_ERROR_PROVISIONING_FAILED = 11; // 0xb

public static final int TETHER_ERROR_SERVICE_UNAVAIL = 2; // 0x2

public static final int TETHER_ERROR_TETHER_IFACE_ERROR = 6; // 0x6

public static final int TETHER_ERROR_UNAVAIL_IFACE = 4; // 0x4

public static final int TETHER_ERROR_UNKNOWN_IFACE = 1; // 0x1

public static final int TETHER_ERROR_UNKNOWN_TYPE = 16; // 0x10

public static final int TETHER_ERROR_UNSUPPORTED = 3; // 0x3

public static final int TETHER_ERROR_UNTETHER_IFACE_ERROR = 7; // 0x7

public static final int TETHER_HARDWARE_OFFLOAD_FAILED = 2; // 0x2

public static final int TETHER_HARDWARE_OFFLOAD_STARTED = 1; // 0x1

public static final int TETHER_HARDWARE_OFFLOAD_STOPPED = 0; // 0x0
@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface OnTetheringEntitlementResultListener {

public void onTetheringEntitlementResult(int result);
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface StartTetheringCallback {

public default void onTetheringStarted() { throw new RuntimeException("Stub!"); }

public default void onTetheringFailed(int error) { throw new RuntimeException("Stub!"); }
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface TetheredInterfaceCallback {

public void onAvailable(@android.annotation.NonNull java.lang.String iface);

public void onUnavailable();
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface TetheredInterfaceRequest {

public void release();
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface TetheringEventCallback {

public default void onTetheringSupported(boolean supported) { throw new RuntimeException("Stub!"); }

public default void onUpstreamChanged(@android.annotation.Nullable android.net.Network network) { throw new RuntimeException("Stub!"); }

@Deprecated
public default void onTetherableInterfaceRegexpsChanged(@android.annotation.NonNull android.net.TetheringManager.TetheringInterfaceRegexps reg) { throw new RuntimeException("Stub!"); }

public default void onTetherableInterfacesChanged(@android.annotation.NonNull java.util.List<java.lang.String> interfaces) { throw new RuntimeException("Stub!"); }

public default void onTetherableInterfacesChanged(@android.annotation.NonNull java.util.Set<android.net.TetheringInterface> interfaces) { throw new RuntimeException("Stub!"); }

public default void onTetheredInterfacesChanged(@android.annotation.NonNull java.util.List<java.lang.String> interfaces) { throw new RuntimeException("Stub!"); }

public default void onTetheredInterfacesChanged(@android.annotation.NonNull java.util.Set<android.net.TetheringInterface> interfaces) { throw new RuntimeException("Stub!"); }

public default void onLocalOnlyInterfacesChanged(@android.annotation.NonNull java.util.List<java.lang.String> interfaces) { throw new RuntimeException("Stub!"); }

public default void onLocalOnlyInterfacesChanged(@android.annotation.NonNull java.util.Set<android.net.TetheringInterface> interfaces) { throw new RuntimeException("Stub!"); }

public default void onError(@android.annotation.NonNull java.lang.String ifName, int error) { throw new RuntimeException("Stub!"); }

public default void onError(@android.annotation.NonNull android.net.TetheringInterface iface, int error) { throw new RuntimeException("Stub!"); }

public default void onClientsChanged(@android.annotation.NonNull java.util.Collection<android.net.TetheredClient> clients) { throw new RuntimeException("Stub!"); }

public default void onOffloadStatusChanged(int status) { throw new RuntimeException("Stub!"); }
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
@Deprecated
public static class TetheringInterfaceRegexps {

TetheringInterfaceRegexps() { throw new RuntimeException("Stub!"); }

@Deprecated
@android.annotation.NonNull
public java.util.List<java.lang.String> getTetherableBluetoothRegexs() { throw new RuntimeException("Stub!"); }

@Deprecated
@android.annotation.NonNull
public java.util.List<java.lang.String> getTetherableUsbRegexs() { throw new RuntimeException("Stub!"); }

@Deprecated
@android.annotation.NonNull
public java.util.List<java.lang.String> getTetherableWifiRegexs() { throw new RuntimeException("Stub!"); }

@Deprecated
public int hashCode() { throw new RuntimeException("Stub!"); }

@Deprecated
public boolean equals(@android.annotation.Nullable java.lang.Object obj) { throw new RuntimeException("Stub!"); }
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class TetheringRequest implements android.os.Parcelable {

TetheringRequest() { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.net.LinkAddress getLocalIpv4Address() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.net.LinkAddress getClientStaticIpv4Address() { throw new RuntimeException("Stub!"); }

public int getTetheringType() { throw new RuntimeException("Stub!"); }

public int getConnectivityScope() { throw new RuntimeException("Stub!"); }

public boolean isExemptFromEntitlementCheck() { throw new RuntimeException("Stub!"); }

public boolean getShouldShowEntitlementUi() { throw new RuntimeException("Stub!"); }

public java.lang.String toString() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.net.TetheringManager.TetheringRequest> CREATOR;
static { CREATOR = null; }
@SuppressWarnings({"unchecked", "deprecation", "all"})
public static class Builder {

public Builder(int type) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.TetheringManager.TetheringRequest.Builder setStaticIpv4Addresses(@android.annotation.NonNull android.net.LinkAddress localIPv4Address, @android.annotation.NonNull android.net.LinkAddress clientAddress) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.TetheringManager.TetheringRequest.Builder setExemptFromEntitlementCheck(boolean exempt) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.TetheringManager.TetheringRequest.Builder setShouldShowEntitlementUi(boolean showUi) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.TetheringManager.TetheringRequest.Builder setConnectivityScope(int scope) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.TetheringManager.TetheringRequest build() { throw new RuntimeException("Stub!"); }
}

}

}

