// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.


package android.net.http;


/**
 * Configuration options for QUIC.
 *
 * <p>The settings in this class are only relevant if QUIC is enabled. Use
 * {@link android.net.http.HttpEngine.Builder#setEnableQuic(boolean) HttpEngine.Builder#setEnableQuic(boolean)} to enable / disable QUIC for
 * the HTTP engine.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public class QuicOptions {

QuicOptions() { throw new RuntimeException("Stub!"); }

/**
 * See {@link android.net.http.QuicOptions.Builder#addAllowedQuicHost Builder#addAllowedQuicHost}
 */

@android.annotation.NonNull
public java.util.Set<java.lang.String> getAllowedQuicHosts() { throw new RuntimeException("Stub!"); }

/**
 * See {@link android.net.http.QuicOptions.Builder#setInMemoryServerConfigsCacheSize Builder#setInMemoryServerConfigsCacheSize}
 */

public boolean hasInMemoryServerConfigsCacheSize() { throw new RuntimeException("Stub!"); }

/**
 * See {@link android.net.http.QuicOptions.Builder#setInMemoryServerConfigsCacheSize Builder#setInMemoryServerConfigsCacheSize}
 */

public int getInMemoryServerConfigsCacheSize() { throw new RuntimeException("Stub!"); }

/**
 * See {@link android.net.http.QuicOptions.Builder#setHandshakeUserAgent Builder#setHandshakeUserAgent}
 */

@android.annotation.Nullable
public java.lang.String getHandshakeUserAgent() { throw new RuntimeException("Stub!"); }

/**
 * See {@link android.net.http.QuicOptions.Builder#setIdleConnectionTimeout Builder#setIdleConnectionTimeout}
 */

@android.annotation.Nullable
public java.time.Duration getIdleConnectionTimeout() { throw new RuntimeException("Stub!"); }
/**
 * Builder for {@link android.net.http.QuicOptions QuicOptions}.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

public Builder() { throw new RuntimeException("Stub!"); }

/**
 * Adds a host to the QUIC allowlist.
 *
 * <p>If no hosts are specified, the per-host allowlist functionality is disabled.
 * Otherwise, the HTTP stack will only use QUIC when talking to hosts on the allowlist.
 *
 * @return the builder for chaining
 */

@android.annotation.NonNull
public android.net.http.QuicOptions.Builder addAllowedQuicHost(@android.annotation.NonNull java.lang.String quicHost) { throw new RuntimeException("Stub!"); }

/**
 * Sets how many server configurations (metadata like list of alt svc, whether QUIC is
 * supported, etc.) should be held in memory.
 *
 * <p>If the storage path is set ({@link android.net.http.HttpEngine.Builder#setStoragePath(java.lang.String) HttpEngine.Builder#setStoragePath(String)},
 * the HTTP stack will also persist the server configurations on disk.
 *
 * @return the builder for chaining
 */

@android.annotation.NonNull
public android.net.http.QuicOptions.Builder setInMemoryServerConfigsCacheSize(int inMemoryServerConfigsCacheSize) { throw new RuntimeException("Stub!"); }

/**
 * Sets the user agent to be used outside of HTTP requests (for example for QUIC
 * handshakes).
 *
 * <p>To set the default user agent for HTTP requests, use
 * {@link android.net.http.HttpEngine.Builder#setUserAgent(java.lang.String) HttpEngine.Builder#setUserAgent(String)} instead.
 *
 * @return the builder for chaining
 */

@android.annotation.NonNull
public android.net.http.QuicOptions.Builder setHandshakeUserAgent(@android.annotation.NonNull java.lang.String handshakeUserAgent) { throw new RuntimeException("Stub!"); }

/**
 * Sets the maximum idle time for a connection. The actual value for the idle timeout is
 * the minimum of this value and the server's and is negotiated during the handshake. Thus,
 * it only applies after the handshake has completed. If no activity is detected
 * on the connection for the set duration, the connection is closed.
 *
 * <p>See <a href="https://www.rfc-editor.org/rfc/rfc9114.html#name-idle-connections">RFC
 * 9114, section 5.1 </a> for more details.
 *
 * @return the builder for chaining
 */

@android.annotation.NonNull
public android.net.http.QuicOptions.Builder setIdleConnectionTimeout(@android.annotation.NonNull java.time.Duration idleConnectionTimeout) { throw new RuntimeException("Stub!"); }

/**
 * Creates and returns the final {@link android.net.http.QuicOptions QuicOptions} instance, based on the values
 * in this builder.
 */

@android.annotation.NonNull
public android.net.http.QuicOptions build() { throw new RuntimeException("Stub!"); }
}

}

