/*
 * Copyright (C) 2014 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.net;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class NetworkCapabilities implements android.os.Parcelable {

public NetworkCapabilities() { throw new RuntimeException("Stub!"); }

public NetworkCapabilities(android.net.NetworkCapabilities nc) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public int[] getEnterpriseIds() { throw new RuntimeException("Stub!"); }

public boolean hasEnterpriseId(int enterpriseId) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public int[] getCapabilities() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public java.util.List<android.net.Network> getUnderlyingNetworks() { throw new RuntimeException("Stub!"); }

public boolean hasCapability(int capability) { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public static java.lang.String getCapabilityCarrierName(int capability) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public int[] getTransportTypes() { throw new RuntimeException("Stub!"); }

public boolean hasTransport(int transportType) { throw new RuntimeException("Stub!"); }

public int getOwnerUid() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public int[] getAdministratorUids() { throw new RuntimeException("Stub!"); }

public int getLinkUpstreamBandwidthKbps() { throw new RuntimeException("Stub!"); }

public int getLinkDownstreamBandwidthKbps() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.net.NetworkSpecifier getNetworkSpecifier() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.net.TransportInfo getTransportInfo() { throw new RuntimeException("Stub!"); }

public int getSignalStrength() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public java.lang.String getSsid() { throw new RuntimeException("Stub!"); }

public boolean satisfiedByNetworkCapabilities(@android.annotation.Nullable android.net.NetworkCapabilities nc) { throw new RuntimeException("Stub!"); }

public boolean equals(@android.annotation.Nullable java.lang.Object obj) { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

public void writeToParcel(android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.lang.String toString() { throw new RuntimeException("Stub!"); }

public boolean isPrivateDnsBroken() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.Set<java.lang.Integer> getSubscriptionIds() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.net.NetworkCapabilities> CREATOR;
static { CREATOR = null; }

public static final int NET_CAPABILITY_BIP = 31; // 0x1f

public static final int NET_CAPABILITY_CAPTIVE_PORTAL = 17; // 0x11

public static final int NET_CAPABILITY_CBS = 5; // 0x5

public static final int NET_CAPABILITY_DUN = 2; // 0x2

public static final int NET_CAPABILITY_EIMS = 10; // 0xa

public static final int NET_CAPABILITY_ENTERPRISE = 29; // 0x1d

public static final int NET_CAPABILITY_FOREGROUND = 19; // 0x13

public static final int NET_CAPABILITY_FOTA = 3; // 0x3

public static final int NET_CAPABILITY_HEAD_UNIT = 32; // 0x20

public static final int NET_CAPABILITY_IA = 7; // 0x7

public static final int NET_CAPABILITY_IMS = 4; // 0x4

public static final int NET_CAPABILITY_INTERNET = 12; // 0xc

public static final int NET_CAPABILITY_LOCAL_NETWORK = 36; // 0x24

public static final int NET_CAPABILITY_MCX = 23; // 0x17

public static final int NET_CAPABILITY_MMS = 0; // 0x0

public static final int NET_CAPABILITY_MMTEL = 33; // 0x21

public static final int NET_CAPABILITY_NOT_CONGESTED = 20; // 0x14

public static final int NET_CAPABILITY_NOT_METERED = 11; // 0xb

public static final int NET_CAPABILITY_NOT_RESTRICTED = 13; // 0xd

public static final int NET_CAPABILITY_NOT_ROAMING = 18; // 0x12

public static final int NET_CAPABILITY_NOT_SUSPENDED = 21; // 0x15

public static final int NET_CAPABILITY_NOT_VCN_MANAGED = 28; // 0x1c

public static final int NET_CAPABILITY_NOT_VPN = 15; // 0xf

public static final int NET_CAPABILITY_OEM_PAID = 22; // 0x16

public static final int NET_CAPABILITY_OEM_PRIVATE = 26; // 0x1a

public static final int NET_CAPABILITY_PARTIAL_CONNECTIVITY = 24; // 0x18

public static final int NET_CAPABILITY_PRIORITIZE_BANDWIDTH = 35; // 0x23

public static final int NET_CAPABILITY_PRIORITIZE_LATENCY = 34; // 0x22

public static final int NET_CAPABILITY_RCS = 8; // 0x8

public static final int NET_CAPABILITY_SUPL = 1; // 0x1

public static final int NET_CAPABILITY_TEMPORARILY_NOT_METERED = 25; // 0x19

public static final int NET_CAPABILITY_TRUSTED = 14; // 0xe

public static final int NET_CAPABILITY_VALIDATED = 16; // 0x10

public static final int NET_CAPABILITY_VEHICLE_INTERNAL = 27; // 0x1b

public static final int NET_CAPABILITY_VSIM = 30; // 0x1e

public static final int NET_CAPABILITY_WIFI_P2P = 6; // 0x6

public static final int NET_CAPABILITY_XCAP = 9; // 0x9

public static final int NET_ENTERPRISE_ID_1 = 1; // 0x1

public static final int NET_ENTERPRISE_ID_2 = 2; // 0x2

public static final int NET_ENTERPRISE_ID_3 = 3; // 0x3

public static final int NET_ENTERPRISE_ID_4 = 4; // 0x4

public static final int NET_ENTERPRISE_ID_5 = 5; // 0x5

public static final int SIGNAL_STRENGTH_UNSPECIFIED = -2147483648; // 0x80000000

public static final int TRANSPORT_BLUETOOTH = 2; // 0x2

public static final int TRANSPORT_CELLULAR = 0; // 0x0

public static final int TRANSPORT_ETHERNET = 3; // 0x3

public static final int TRANSPORT_LOWPAN = 6; // 0x6

public static final int TRANSPORT_SATELLITE = 10; // 0xa

public static final int TRANSPORT_THREAD = 9; // 0x9

public static final int TRANSPORT_USB = 8; // 0x8

public static final int TRANSPORT_VPN = 4; // 0x4

public static final int TRANSPORT_WIFI = 1; // 0x1

public static final int TRANSPORT_WIFI_AWARE = 5; // 0x5
@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

public Builder() { throw new RuntimeException("Stub!"); }

public Builder(@android.annotation.NonNull android.net.NetworkCapabilities nc) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public static android.net.NetworkCapabilities.Builder withoutDefaultCapabilities() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.NetworkCapabilities.Builder addTransportType(int transportType) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.NetworkCapabilities.Builder removeTransportType(int transportType) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.NetworkCapabilities.Builder addCapability(int capability) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.NetworkCapabilities.Builder removeCapability(int capability) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.NetworkCapabilities.Builder addEnterpriseId(int enterpriseId) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.NetworkCapabilities.Builder removeEnterpriseId(int enterpriseId) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.NetworkCapabilities.Builder setOwnerUid(int ownerUid) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.NetworkCapabilities.Builder setAdministratorUids(@android.annotation.NonNull int[] administratorUids) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.NetworkCapabilities.Builder setLinkUpstreamBandwidthKbps(int upKbps) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.NetworkCapabilities.Builder setLinkDownstreamBandwidthKbps(int downKbps) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.NetworkCapabilities.Builder setNetworkSpecifier(@android.annotation.Nullable android.net.NetworkSpecifier specifier) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.NetworkCapabilities.Builder setTransportInfo(@android.annotation.Nullable android.net.TransportInfo info) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.NetworkCapabilities.Builder setSignalStrength(int signalStrength) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.NetworkCapabilities.Builder setSsid(@android.annotation.Nullable java.lang.String ssid) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.NetworkCapabilities.Builder setRequestorUid(int uid) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.NetworkCapabilities.Builder setRequestorPackageName(@android.annotation.Nullable java.lang.String packageName) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.NetworkCapabilities.Builder setSubscriptionIds(@android.annotation.NonNull java.util.Set<java.lang.Integer> subIds) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.NetworkCapabilities.Builder setUnderlyingNetworks(@android.annotation.Nullable java.util.List<android.net.Network> networks) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.NetworkCapabilities build() { throw new RuntimeException("Stub!"); }
}

}

