/*
 * Copyright (C) 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.net.nsd;

import android.net.Network;

/**
 * Encapsulates parameters for {@link android.net.nsd.NsdManager#discoverServices NsdManager#discoverServices}.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class DiscoveryRequest implements android.os.Parcelable {

DiscoveryRequest() { throw new RuntimeException("Stub!"); }

/**
 * Returns the service type in format of dot-joint string of two labels.
 *
 * For example, "_ipp._tcp" for internet printer and "_matter._tcp" for <a
 * href="https://csa-iot.org/all-solutions/matter">Matter</a> operational device.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.lang.String getServiceType() { throw new RuntimeException("Stub!"); }

/**
 * Returns the subtype without the trailing "._sub" label or {@code null} if no subtype is
 * specified.
 *
 * For example, the return value will be "_printer" for subtype "_printer._sub".
 */

@android.annotation.Nullable
public java.lang.String getSubtype() { throw new RuntimeException("Stub!"); }

/**
 * Returns the {@link android.net.Network Network} on which the query should be sent or {@code null} if no
 * network is specified.
 */

@android.annotation.Nullable
public android.net.Network getNetwork() { throw new RuntimeException("Stub!"); }

public java.lang.String toString() { throw new RuntimeException("Stub!"); }

public boolean equals(java.lang.Object other) { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param dest This value cannot be {@code null}.
 */

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.net.nsd.DiscoveryRequest> CREATOR;
static { CREATOR = null; }
/** The builder for creating new {@link android.net.nsd.DiscoveryRequest DiscoveryRequest} objects. */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

/**
 * Creates a new default {@link android.net.nsd.DiscoveryRequest.Builder Builder} object with given service type.
 *
 * @throws java.lang.IllegalArgumentException if {@code serviceType} is {@code null} or an empty
 * string

 * @param serviceType This value cannot be {@code null}.
 */

public Builder(@android.annotation.NonNull java.lang.String serviceType) { throw new RuntimeException("Stub!"); }

/**
 * Sets the optional subtype of the services to be discovered.
 *
 * If a non-empty {@code subtype} is specified, it must start with underscore ('_') and
 * have the trailing "._sub" removed. Otherwise, {@link android.net.nsd.NsdManager#discoverServices NsdManager#discoverServices} will
 * fail with {@link android.net.nsd.NsdManager#FAILURE_BAD_PARAMETER NsdManager#FAILURE_BAD_PARAMETER}. For example, {@code subtype} should
 * be "_printer" for DNS name "_printer._sub._http._tcp". In this case, only services with
 * this {@code subtype} will be queried, rather than all services of the base service type.
 *
 * Note that a non-empty service type must be specified with {@link #setServiceType} if a
 * non-empty subtype is specified by this method.
 
 * @param subtype This value may be {@code null}.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.nsd.DiscoveryRequest.Builder setSubtype(@android.annotation.Nullable java.lang.String subtype) { throw new RuntimeException("Stub!"); }

/**
 * Sets the {@link android.net.Network Network} on which the discovery queries should be sent.
 *
 * @param network the discovery network or {@code null} if the query should be sent on
 * all supported networks

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.nsd.DiscoveryRequest.Builder setNetwork(@android.annotation.Nullable android.net.Network network) { throw new RuntimeException("Stub!"); }

/**
 * Creates a new {@link android.net.nsd.DiscoveryRequest DiscoveryRequest} object.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.nsd.DiscoveryRequest build() { throw new RuntimeException("Stub!"); }
}

}

