/*
 * Copyright (C) 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.net.thread;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class ThreadNetworkController {

ThreadNetworkController() { throw new RuntimeException("Stub!"); }

public void setEnabled(boolean enabled, @android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.os.OutcomeReceiver<java.lang.Void,android.net.thread.ThreadNetworkException> receiver) { throw new RuntimeException("Stub!"); }

public int getThreadVersion() { throw new RuntimeException("Stub!"); }

public void createRandomizedDataset(@android.annotation.NonNull java.lang.String networkName, @android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.os.OutcomeReceiver<android.net.thread.ActiveOperationalDataset,android.net.thread.ThreadNetworkException> receiver) { throw new RuntimeException("Stub!"); }

public static boolean isAttached(int deviceRole) { throw new RuntimeException("Stub!"); }

public void registerStateCallback(@android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.net.thread.ThreadNetworkController.StateCallback callback) { throw new RuntimeException("Stub!"); }

public void unregisterStateCallback(@android.annotation.NonNull android.net.thread.ThreadNetworkController.StateCallback callback) { throw new RuntimeException("Stub!"); }

public void registerOperationalDatasetCallback(@android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.net.thread.ThreadNetworkController.OperationalDatasetCallback callback) { throw new RuntimeException("Stub!"); }

public void unregisterOperationalDatasetCallback(@android.annotation.NonNull android.net.thread.ThreadNetworkController.OperationalDatasetCallback callback) { throw new RuntimeException("Stub!"); }

public void join(@android.annotation.NonNull android.net.thread.ActiveOperationalDataset activeDataset, @android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.os.OutcomeReceiver<java.lang.Void,android.net.thread.ThreadNetworkException> receiver) { throw new RuntimeException("Stub!"); }

public void scheduleMigration(@android.annotation.NonNull android.net.thread.PendingOperationalDataset pendingDataset, @android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.os.OutcomeReceiver<java.lang.Void,android.net.thread.ThreadNetworkException> receiver) { throw new RuntimeException("Stub!"); }

public void leave(@android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.os.OutcomeReceiver<java.lang.Void,android.net.thread.ThreadNetworkException> receiver) { throw new RuntimeException("Stub!"); }

public static final int DEVICE_ROLE_CHILD = 2; // 0x2

public static final int DEVICE_ROLE_DETACHED = 1; // 0x1

public static final int DEVICE_ROLE_LEADER = 4; // 0x4

public static final int DEVICE_ROLE_ROUTER = 3; // 0x3

public static final int DEVICE_ROLE_STOPPED = 0; // 0x0

public static final int MAX_POWER_CHANNEL_DISABLED = -2147483648; // 0x80000000

public static final int STATE_DISABLED = 0; // 0x0

public static final int STATE_DISABLING = 2; // 0x2

public static final int STATE_ENABLED = 1; // 0x1

public static final int THREAD_VERSION_1_3 = 4; // 0x4
@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface OperationalDatasetCallback {

public void onActiveOperationalDatasetChanged(@android.annotation.Nullable android.net.thread.ActiveOperationalDataset activeDataset);

public default void onPendingOperationalDatasetChanged(@android.annotation.Nullable android.net.thread.PendingOperationalDataset pendingDataset) { throw new RuntimeException("Stub!"); }
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface StateCallback {

public void onDeviceRoleChanged(int deviceRole);

public default void onPartitionIdChanged(long partitionId) { throw new RuntimeException("Stub!"); }

public default void onThreadEnableStateChanged(int enabledState) { throw new RuntimeException("Stub!"); }
}

}

