// Copyright 2015 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.


package android.net.http;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public abstract class BidirectionalStream {

public BidirectionalStream() { throw new RuntimeException("Stub!"); }

public abstract void cancel();

public abstract void flush();

@android.annotation.NonNull
public abstract android.net.http.HeaderBlock getHeaders();

@android.annotation.NonNull
public abstract java.lang.String getHttpMethod();

public abstract int getPriority();

public abstract int getTrafficStatsTag();

public abstract int getTrafficStatsUid();

public abstract boolean hasTrafficStatsTag();

public abstract boolean hasTrafficStatsUid();

public abstract boolean isDelayRequestHeadersUntilFirstFlushEnabled();

public abstract boolean isDone();

public abstract void read(@android.annotation.NonNull java.nio.ByteBuffer buffer);

public abstract void start();

public abstract void write(@android.annotation.NonNull java.nio.ByteBuffer buffer, boolean endOfStream);

public static final int STREAM_PRIORITY_HIGHEST = 4; // 0x4

public static final int STREAM_PRIORITY_IDLE = 0; // 0x0

public static final int STREAM_PRIORITY_LOW = 2; // 0x2

public static final int STREAM_PRIORITY_LOWEST = 1; // 0x1

public static final int STREAM_PRIORITY_MEDIUM = 3; // 0x3
@SuppressWarnings({"unchecked", "deprecation", "all"})
public abstract static class Builder {

public Builder() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public abstract android.net.http.BidirectionalStream.Builder addHeader(@android.annotation.NonNull java.lang.String header, @android.annotation.NonNull java.lang.String value);

@android.annotation.NonNull
public abstract android.net.http.BidirectionalStream build();

@android.annotation.NonNull
public abstract android.net.http.BidirectionalStream.Builder setDelayRequestHeadersUntilFirstFlushEnabled(boolean delayRequestHeadersUntilFirstFlush);

@android.annotation.NonNull
public abstract android.net.http.BidirectionalStream.Builder setHttpMethod(@android.annotation.NonNull java.lang.String method);

@android.annotation.NonNull
public abstract android.net.http.BidirectionalStream.Builder setPriority(int priority);

@android.annotation.NonNull
public abstract android.net.http.BidirectionalStream.Builder setTrafficStatsTag(int tag);

@android.annotation.NonNull
public abstract android.net.http.BidirectionalStream.Builder setTrafficStatsUid(int uid);
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface Callback {

public void onCanceled(@android.annotation.NonNull android.net.http.BidirectionalStream stream, @android.annotation.Nullable android.net.http.UrlResponseInfo info);

public void onFailed(@android.annotation.NonNull android.net.http.BidirectionalStream stream, @android.annotation.Nullable android.net.http.UrlResponseInfo info, @android.annotation.NonNull android.net.http.HttpException error);

public void onReadCompleted(@android.annotation.NonNull android.net.http.BidirectionalStream stream, @android.annotation.NonNull android.net.http.UrlResponseInfo info, @android.annotation.NonNull java.nio.ByteBuffer buffer, boolean endOfStream);

public void onResponseHeadersReceived(@android.annotation.NonNull android.net.http.BidirectionalStream stream, @android.annotation.NonNull android.net.http.UrlResponseInfo info);

public void onResponseTrailersReceived(@android.annotation.NonNull android.net.http.BidirectionalStream stream, @android.annotation.NonNull android.net.http.UrlResponseInfo info, @android.annotation.NonNull android.net.http.HeaderBlock trailers);

public void onStreamReady(@android.annotation.NonNull android.net.http.BidirectionalStream stream);

public void onSucceeded(@android.annotation.NonNull android.net.http.BidirectionalStream stream, @android.annotation.NonNull android.net.http.UrlResponseInfo info);

public void onWriteCompleted(@android.annotation.NonNull android.net.http.BidirectionalStream stream, @android.annotation.NonNull android.net.http.UrlResponseInfo info, @android.annotation.NonNull java.nio.ByteBuffer buffer, boolean endOfStream);
}

}

