/*
 * Copyright (C) 2008 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package android.net;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public class ConnectivityManager {

ConnectivityManager() { throw new RuntimeException("Stub!"); }

public void addDefaultNetworkActiveListener(android.net.ConnectivityManager.OnNetworkActiveListener l) { throw new RuntimeException("Stub!"); }

public boolean bindProcessToNetwork(@android.annotation.Nullable android.net.Network network) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.SocketKeepalive createNattKeepalive(@android.annotation.NonNull android.net.Network network, @android.annotation.NonNull android.os.ParcelFileDescriptor pfd, @android.annotation.NonNull java.net.InetAddress source, @android.annotation.NonNull java.net.InetAddress destination, @android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.net.SocketKeepalive.Callback callback) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.SocketKeepalive createSocketKeepalive(@android.annotation.NonNull android.net.Network network, @android.annotation.NonNull android.net.IpSecManager.UdpEncapsulationSocket socket, @android.annotation.NonNull java.net.InetAddress source, @android.annotation.NonNull java.net.InetAddress destination, @android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.net.SocketKeepalive.Callback callback) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.SocketKeepalive createSocketKeepalive(@android.annotation.NonNull android.net.Network network, @android.annotation.NonNull java.net.Socket socket, @android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.net.SocketKeepalive.Callback callback) { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.net.Network getActiveNetwork() { throw new RuntimeException("Stub!"); }

@Deprecated
@android.annotation.Nullable
public android.net.NetworkInfo getActiveNetworkInfo() { throw new RuntimeException("Stub!"); }

@Deprecated
@android.annotation.NonNull
public android.net.NetworkInfo[] getAllNetworkInfo() { throw new RuntimeException("Stub!"); }

@Deprecated
@android.annotation.NonNull
public android.net.Network[] getAllNetworks() { throw new RuntimeException("Stub!"); }

@Deprecated
public boolean getBackgroundDataSetting() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.net.Network getBoundNetworkForProcess() { throw new RuntimeException("Stub!"); }

@Deprecated
public java.lang.String getCaptivePortalServerUrl() { throw new RuntimeException("Stub!"); }

public int getConnectionOwnerUid(int protocol, @android.annotation.NonNull java.net.InetSocketAddress local, @android.annotation.NonNull java.net.InetSocketAddress remote) { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.net.ProxyInfo getDefaultProxy() { throw new RuntimeException("Stub!"); }

@Deprecated
public void getLatestTetheringEntitlementResult(int type, boolean showEntitlementUi, @android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.net.ConnectivityManager.OnTetheringEntitlementResultListener listener) { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.net.LinkProperties getLinkProperties(@android.annotation.Nullable android.net.Network network) { throw new RuntimeException("Stub!"); }

public int getMultipathPreference(@android.annotation.Nullable android.net.Network network) { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.net.NetworkCapabilities getNetworkCapabilities(@android.annotation.Nullable android.net.Network network) { throw new RuntimeException("Stub!"); }

@Deprecated
@android.annotation.Nullable
public android.net.NetworkInfo getNetworkInfo(@android.annotation.Nullable android.net.Network network) { throw new RuntimeException("Stub!"); }

@Deprecated
@android.annotation.Nullable
public android.net.NetworkInfo getNetworkInfo(int networkType) { throw new RuntimeException("Stub!"); }

@Deprecated
public int getNetworkPreference() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public byte[] getNetworkWatchlistConfigHash() { throw new RuntimeException("Stub!"); }

@Deprecated
@android.annotation.Nullable
public static android.net.Network getProcessDefaultNetwork() { throw new RuntimeException("Stub!"); }

public int getRestrictBackgroundStatus() { throw new RuntimeException("Stub!"); }

public boolean isActiveNetworkMetered() { throw new RuntimeException("Stub!"); }

public boolean isDefaultNetworkActive() { throw new RuntimeException("Stub!"); }

@Deprecated
public static boolean isNetworkTypeValid(int networkType) { throw new RuntimeException("Stub!"); }

@Deprecated
public boolean isTetheringSupported() { throw new RuntimeException("Stub!"); }

public void registerBestMatchingNetworkCallback(@android.annotation.NonNull android.net.NetworkRequest request, @android.annotation.NonNull android.net.ConnectivityManager.NetworkCallback networkCallback, @android.annotation.NonNull android.os.Handler handler) { throw new RuntimeException("Stub!"); }

public void registerDefaultNetworkCallback(@android.annotation.NonNull android.net.ConnectivityManager.NetworkCallback networkCallback) { throw new RuntimeException("Stub!"); }

public void registerDefaultNetworkCallback(@android.annotation.NonNull android.net.ConnectivityManager.NetworkCallback networkCallback, @android.annotation.NonNull android.os.Handler handler) { throw new RuntimeException("Stub!"); }

public void registerNetworkCallback(@android.annotation.NonNull android.net.NetworkRequest request, @android.annotation.NonNull android.app.PendingIntent operation) { throw new RuntimeException("Stub!"); }

public void registerNetworkCallback(@android.annotation.NonNull android.net.NetworkRequest request, @android.annotation.NonNull android.net.ConnectivityManager.NetworkCallback networkCallback) { throw new RuntimeException("Stub!"); }

public void registerNetworkCallback(@android.annotation.NonNull android.net.NetworkRequest request, @android.annotation.NonNull android.net.ConnectivityManager.NetworkCallback networkCallback, @android.annotation.NonNull android.os.Handler handler) { throw new RuntimeException("Stub!"); }

public int registerNetworkProvider(@android.annotation.NonNull android.net.NetworkProvider provider) { throw new RuntimeException("Stub!"); }

public void registerQosCallback(@android.annotation.NonNull android.net.QosSocketInfo socketInfo, @android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.net.QosCallback callback) { throw new RuntimeException("Stub!"); }

@Deprecated
public void registerTetheringEventCallback(@android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.net.ConnectivityManager.OnTetheringEventCallback callback) { throw new RuntimeException("Stub!"); }

public void releaseNetworkRequest(@android.annotation.NonNull android.app.PendingIntent operation) { throw new RuntimeException("Stub!"); }

public void removeDefaultNetworkActiveListener(@android.annotation.NonNull android.net.ConnectivityManager.OnNetworkActiveListener l) { throw new RuntimeException("Stub!"); }

@Deprecated
public void reportBadNetwork(@android.annotation.Nullable android.net.Network network) { throw new RuntimeException("Stub!"); }

public void reportNetworkConnectivity(@android.annotation.Nullable android.net.Network network, boolean hasConnectivity) { throw new RuntimeException("Stub!"); }

public boolean requestBandwidthUpdate(@android.annotation.NonNull android.net.Network network) { throw new RuntimeException("Stub!"); }

public void requestNetwork(@android.annotation.NonNull android.net.NetworkRequest request, @android.annotation.NonNull android.app.PendingIntent operation) { throw new RuntimeException("Stub!"); }

public void requestNetwork(@android.annotation.NonNull android.net.NetworkRequest request, @android.annotation.NonNull android.net.ConnectivityManager.NetworkCallback networkCallback) { throw new RuntimeException("Stub!"); }

public void requestNetwork(@android.annotation.NonNull android.net.NetworkRequest request, @android.annotation.NonNull android.net.ConnectivityManager.NetworkCallback networkCallback, @android.annotation.NonNull android.os.Handler handler) { throw new RuntimeException("Stub!"); }

public void requestNetwork(@android.annotation.NonNull android.net.NetworkRequest request, @android.annotation.NonNull android.net.ConnectivityManager.NetworkCallback networkCallback, @android.annotation.NonNull android.os.Handler handler, int timeoutMs) { throw new RuntimeException("Stub!"); }

public void requestNetwork(@android.annotation.NonNull android.net.NetworkRequest request, @android.annotation.NonNull android.net.ConnectivityManager.NetworkCallback networkCallback, int timeoutMs) { throw new RuntimeException("Stub!"); }

public void requestNetwork(@android.annotation.NonNull android.net.NetworkRequest request, int timeoutMs, int legacyType, @android.annotation.NonNull android.os.Handler handler, @android.annotation.NonNull android.net.ConnectivityManager.NetworkCallback networkCallback) { throw new RuntimeException("Stub!"); }

public void setAirplaneMode(boolean enable) { throw new RuntimeException("Stub!"); }

@Deprecated
public void setNetworkPreference(int preference) { throw new RuntimeException("Stub!"); }

public void setOemNetworkPreference(@android.annotation.NonNull android.net.OemNetworkPreferences preference, @android.annotation.Nullable java.util.concurrent.Executor executor, @android.annotation.Nullable java.lang.Runnable listener) { throw new RuntimeException("Stub!"); }

@Deprecated
public static boolean setProcessDefaultNetwork(@android.annotation.Nullable android.net.Network network) { throw new RuntimeException("Stub!"); }

public boolean shouldAvoidBadWifi() { throw new RuntimeException("Stub!"); }

public void startCaptivePortalApp(@android.annotation.NonNull android.net.Network network, @android.annotation.NonNull android.os.Bundle appExtras) { throw new RuntimeException("Stub!"); }

@Deprecated
public void startTethering(int type, boolean showProvisioningUi, android.net.ConnectivityManager.OnStartTetheringCallback callback) { throw new RuntimeException("Stub!"); }

@Deprecated
public void startTethering(int type, boolean showProvisioningUi, android.net.ConnectivityManager.OnStartTetheringCallback callback, android.os.Handler handler) { throw new RuntimeException("Stub!"); }

@Deprecated
public void stopTethering(int type) { throw new RuntimeException("Stub!"); }

public void unregisterNetworkCallback(@android.annotation.NonNull android.app.PendingIntent operation) { throw new RuntimeException("Stub!"); }

public void unregisterNetworkCallback(@android.annotation.NonNull android.net.ConnectivityManager.NetworkCallback networkCallback) { throw new RuntimeException("Stub!"); }

public void unregisterNetworkProvider(@android.annotation.NonNull android.net.NetworkProvider provider) { throw new RuntimeException("Stub!"); }

public void unregisterQosCallback(@android.annotation.NonNull android.net.QosCallback callback) { throw new RuntimeException("Stub!"); }

@Deprecated
public void unregisterTetheringEventCallback(@android.annotation.NonNull android.net.ConnectivityManager.OnTetheringEventCallback callback) { throw new RuntimeException("Stub!"); }

@Deprecated @android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.BROADCAST_INTENT_ACTION) public static final java.lang.String ACTION_BACKGROUND_DATA_SETTING_CHANGED = "android.net.conn.BACKGROUND_DATA_SETTING_CHANGED";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.ACTIVITY_INTENT_ACTION) public static final java.lang.String ACTION_CAPTIVE_PORTAL_SIGN_IN = "android.net.conn.CAPTIVE_PORTAL";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.BROADCAST_INTENT_ACTION) public static final java.lang.String ACTION_RESTRICT_BACKGROUND_CHANGED = "android.net.conn.RESTRICT_BACKGROUND_CHANGED";

@Deprecated @android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.BROADCAST_INTENT_ACTION) public static final java.lang.String CONNECTIVITY_ACTION = "android.net.conn.CONNECTIVITY_CHANGE";

@Deprecated public static final int DEFAULT_NETWORK_PREFERENCE = 1; // 0x1

public static final java.lang.String EXTRA_CAPTIVE_PORTAL = "android.net.extra.CAPTIVE_PORTAL";

public static final java.lang.String EXTRA_CAPTIVE_PORTAL_PROBE_SPEC = "android.net.extra.CAPTIVE_PORTAL_PROBE_SPEC";

public static final java.lang.String EXTRA_CAPTIVE_PORTAL_URL = "android.net.extra.CAPTIVE_PORTAL_URL";

public static final java.lang.String EXTRA_CAPTIVE_PORTAL_USER_AGENT = "android.net.extra.CAPTIVE_PORTAL_USER_AGENT";

@Deprecated public static final java.lang.String EXTRA_EXTRA_INFO = "extraInfo";

@Deprecated public static final java.lang.String EXTRA_IS_FAILOVER = "isFailover";

public static final java.lang.String EXTRA_NETWORK = "android.net.extra.NETWORK";

@Deprecated public static final java.lang.String EXTRA_NETWORK_INFO = "networkInfo";

public static final java.lang.String EXTRA_NETWORK_REQUEST = "android.net.extra.NETWORK_REQUEST";

@Deprecated public static final java.lang.String EXTRA_NETWORK_TYPE = "networkType";

public static final java.lang.String EXTRA_NO_CONNECTIVITY = "noConnectivity";

@Deprecated public static final java.lang.String EXTRA_OTHER_NETWORK_INFO = "otherNetwork";

public static final java.lang.String EXTRA_REASON = "reason";

public static final int MULTIPATH_PREFERENCE_HANDOVER = 1; // 0x1

public static final int MULTIPATH_PREFERENCE_PERFORMANCE = 4; // 0x4

public static final int MULTIPATH_PREFERENCE_RELIABILITY = 2; // 0x2

public static final int RESTRICT_BACKGROUND_STATUS_DISABLED = 1; // 0x1

public static final int RESTRICT_BACKGROUND_STATUS_ENABLED = 3; // 0x3

public static final int RESTRICT_BACKGROUND_STATUS_WHITELISTED = 2; // 0x2

public static final int TETHERING_BLUETOOTH = 2; // 0x2

public static final int TETHERING_USB = 1; // 0x1

public static final int TETHERING_WIFI = 0; // 0x0

@Deprecated public static final int TETHER_ERROR_ENTITLEMENT_UNKONWN = 13; // 0xd

@Deprecated public static final int TETHER_ERROR_NO_ERROR = 0; // 0x0

@Deprecated public static final int TETHER_ERROR_PROVISION_FAILED = 11; // 0xb

@Deprecated public static final int TYPE_BLUETOOTH = 7; // 0x7

@Deprecated public static final int TYPE_DUMMY = 8; // 0x8

@Deprecated public static final int TYPE_ETHERNET = 9; // 0x9

@Deprecated public static final int TYPE_MOBILE = 0; // 0x0

@Deprecated public static final int TYPE_MOBILE_DUN = 4; // 0x4

@Deprecated public static final int TYPE_MOBILE_HIPRI = 5; // 0x5

@Deprecated public static final int TYPE_MOBILE_MMS = 2; // 0x2

@Deprecated public static final int TYPE_MOBILE_SUPL = 3; // 0x3

public static final int TYPE_NONE = -1; // 0xffffffff

@Deprecated public static final int TYPE_PROXY = 16; // 0x10

@Deprecated public static final int TYPE_VPN = 17; // 0x11

@Deprecated public static final int TYPE_WIFI = 1; // 0x1

@Deprecated public static final int TYPE_WIFI_P2P = 13; // 0xd

@Deprecated public static final int TYPE_WIMAX = 6; // 0x6
@SuppressWarnings({"unchecked", "deprecation", "all"})
public static class NetworkCallback {

public NetworkCallback() { throw new RuntimeException("Stub!"); }

public NetworkCallback(int flags) { throw new RuntimeException("Stub!"); }

public void onAvailable(@android.annotation.NonNull android.net.Network network) { throw new RuntimeException("Stub!"); }

public void onBlockedStatusChanged(@android.annotation.NonNull android.net.Network network, boolean blocked) { throw new RuntimeException("Stub!"); }

public void onCapabilitiesChanged(@android.annotation.NonNull android.net.Network network, @android.annotation.NonNull android.net.NetworkCapabilities networkCapabilities) { throw new RuntimeException("Stub!"); }

public void onLinkPropertiesChanged(@android.annotation.NonNull android.net.Network network, @android.annotation.NonNull android.net.LinkProperties linkProperties) { throw new RuntimeException("Stub!"); }

public void onLosing(@android.annotation.NonNull android.net.Network network, int maxMsToLive) { throw new RuntimeException("Stub!"); }

public void onLost(@android.annotation.NonNull android.net.Network network) { throw new RuntimeException("Stub!"); }

public void onUnavailable() { throw new RuntimeException("Stub!"); }

public static final int FLAG_INCLUDE_LOCATION_INFO = 1; // 0x1
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface OnNetworkActiveListener {

public void onNetworkActive();
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
@Deprecated
public abstract static class OnStartTetheringCallback {

@Deprecated
public OnStartTetheringCallback() { throw new RuntimeException("Stub!"); }

@Deprecated
public void onTetheringFailed() { throw new RuntimeException("Stub!"); }

@Deprecated
public void onTetheringStarted() { throw new RuntimeException("Stub!"); }
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
@Deprecated
public static interface OnTetheringEntitlementResultListener {

@Deprecated
public void onTetheringEntitlementResult(int resultCode);
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
@Deprecated
public abstract static class OnTetheringEventCallback {

@Deprecated
public OnTetheringEventCallback() { throw new RuntimeException("Stub!"); }

@Deprecated
public void onUpstreamChanged(@android.annotation.Nullable android.net.Network network) { throw new RuntimeException("Stub!"); }
}

}

