// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.


package android.net.http;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public abstract class UrlRequest {

UrlRequest() { throw new RuntimeException("Stub!"); }

public abstract void cancel();

public abstract void followRedirect();

@android.annotation.NonNull
public abstract android.net.http.HeaderBlock getHeaders();

@android.annotation.Nullable
public abstract java.lang.String getHttpMethod();

public abstract int getPriority();

public abstract void getStatus(@android.annotation.NonNull android.net.http.UrlRequest.StatusListener listener);

public abstract int getTrafficStatsTag();

public abstract int getTrafficStatsUid();

public abstract boolean hasTrafficStatsTag();

public abstract boolean hasTrafficStatsUid();

public abstract boolean isCacheDisabled();

public abstract boolean isDirectExecutorAllowed();

public abstract boolean isDone();

public abstract void read(@android.annotation.NonNull java.nio.ByteBuffer buffer);

public abstract void start();

public static final int REQUEST_PRIORITY_HIGHEST = 4; // 0x4

public static final int REQUEST_PRIORITY_IDLE = 0; // 0x0

public static final int REQUEST_PRIORITY_LOW = 2; // 0x2

public static final int REQUEST_PRIORITY_LOWEST = 1; // 0x1

public static final int REQUEST_PRIORITY_MEDIUM = 3; // 0x3
@SuppressWarnings({"unchecked", "deprecation", "all"})
public abstract static class Builder {

Builder() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public abstract android.net.http.UrlRequest.Builder addHeader(@android.annotation.NonNull java.lang.String header, @android.annotation.NonNull java.lang.String value);

@android.annotation.NonNull
public abstract android.net.http.UrlRequest.Builder bindToNetwork(@android.annotation.Nullable android.net.Network network);

@android.annotation.NonNull
public abstract android.net.http.UrlRequest build();

@android.annotation.NonNull
public abstract android.net.http.UrlRequest.Builder setCacheDisabled(boolean disableCache);

@android.annotation.NonNull
public abstract android.net.http.UrlRequest.Builder setDirectExecutorAllowed(boolean allowDirectExecutor);

@android.annotation.NonNull
public abstract android.net.http.UrlRequest.Builder setHttpMethod(@android.annotation.NonNull java.lang.String method);

@android.annotation.NonNull
public abstract android.net.http.UrlRequest.Builder setPriority(int priority);

@android.annotation.NonNull
public abstract android.net.http.UrlRequest.Builder setTrafficStatsTag(int tag);

@android.annotation.NonNull
public abstract android.net.http.UrlRequest.Builder setTrafficStatsUid(int uid);

@android.annotation.NonNull
public abstract android.net.http.UrlRequest.Builder setUploadDataProvider(@android.annotation.NonNull android.net.http.UploadDataProvider uploadDataProvider, @android.annotation.NonNull java.util.concurrent.Executor executor);
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface Callback {

public void onCanceled(@android.annotation.NonNull android.net.http.UrlRequest request, @android.annotation.Nullable android.net.http.UrlResponseInfo info);

public void onFailed(@android.annotation.NonNull android.net.http.UrlRequest request, @android.annotation.Nullable android.net.http.UrlResponseInfo info, @android.annotation.NonNull android.net.http.HttpException error);

public void onReadCompleted(@android.annotation.NonNull android.net.http.UrlRequest request, @android.annotation.NonNull android.net.http.UrlResponseInfo info, @android.annotation.NonNull java.nio.ByteBuffer byteBuffer) throws java.lang.Exception;

public void onRedirectReceived(@android.annotation.NonNull android.net.http.UrlRequest request, @android.annotation.NonNull android.net.http.UrlResponseInfo info, @android.annotation.NonNull java.lang.String newLocationUrl) throws java.lang.Exception;

public void onResponseStarted(@android.annotation.NonNull android.net.http.UrlRequest request, @android.annotation.NonNull android.net.http.UrlResponseInfo info) throws java.lang.Exception;

public void onSucceeded(@android.annotation.NonNull android.net.http.UrlRequest request, @android.annotation.NonNull android.net.http.UrlResponseInfo info);
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static class Status {

Status() { throw new RuntimeException("Stub!"); }

public static final int CONNECTING = 10; // 0xa

public static final int DOWNLOADING_PAC_FILE = 5; // 0x5

public static final int ESTABLISHING_PROXY_TUNNEL = 8; // 0x8

public static final int IDLE = 0; // 0x0

public static final int INVALID = -1; // 0xffffffff

public static final int READING_RESPONSE = 14; // 0xe

public static final int RESOLVING_HOST = 9; // 0x9

public static final int RESOLVING_HOST_IN_PAC_FILE = 7; // 0x7

public static final int RESOLVING_PROXY_FOR_URL = 6; // 0x6

public static final int SENDING_REQUEST = 12; // 0xc

public static final int SSL_HANDSHAKE = 11; // 0xb

public static final int WAITING_FOR_AVAILABLE_SOCKET = 2; // 0x2

public static final int WAITING_FOR_CACHE = 4; // 0x4

public static final int WAITING_FOR_DELEGATE = 3; // 0x3

public static final int WAITING_FOR_RESPONSE = 13; // 0xd

public static final int WAITING_FOR_STALLED_SOCKET_POOL = 1; // 0x1
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface StatusListener {

public void onStatus(int status);
}

}

