/*
 * Copyright (C) 2021 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.nearby;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public interface ScanCallback {

public void onDiscovered(@android.annotation.NonNull android.nearby.NearbyDevice device);

public default void onError(int errorCode) { throw new RuntimeException("Stub!"); }

public void onLost(@android.annotation.NonNull android.nearby.NearbyDevice device);

public void onUpdated(@android.annotation.NonNull android.nearby.NearbyDevice device);

public static final int ERROR_INVALID_ARGUMENT = 2; // 0x2

public static final int ERROR_PERMISSION_DENIED = 3; // 0x3

public static final int ERROR_RESOURCE_EXHAUSTED = 4; // 0x4

public static final int ERROR_UNKNOWN = 0; // 0x0

public static final int ERROR_UNSUPPORTED = 1; // 0x1
}

