/*
 * Copyright (C) 2020 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.net.netstats.provider;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public abstract class NetworkStatsProvider {

public NetworkStatsProvider() { throw new RuntimeException("Stub!"); }

public void notifyStatsUpdated(int token, @android.annotation.NonNull android.net.NetworkStats ifaceStats, @android.annotation.NonNull android.net.NetworkStats uidStats) { throw new RuntimeException("Stub!"); }

public void notifyAlertReached() { throw new RuntimeException("Stub!"); }

public void notifyWarningReached() { throw new RuntimeException("Stub!"); }

public void notifyLimitReached() { throw new RuntimeException("Stub!"); }

public abstract void onRequestStatsUpdate(int token);

public abstract void onSetLimit(@android.annotation.NonNull java.lang.String iface, long quotaBytes);

public void onSetWarningAndLimit(@android.annotation.NonNull java.lang.String iface, long warningBytes, long limitBytes) { throw new RuntimeException("Stub!"); }

public abstract void onSetAlert(long quotaBytes);

public static final int QUOTA_UNLIMITED = -1; // 0xffffffff
}

