/*
 * Copyright (C) 2014 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.net;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public abstract class NetworkAgent {

public NetworkAgent(@android.annotation.NonNull android.content.Context context, @android.annotation.NonNull android.os.Looper looper, @android.annotation.NonNull java.lang.String logTag, @android.annotation.NonNull android.net.NetworkCapabilities nc, @android.annotation.NonNull android.net.LinkProperties lp, int score, @android.annotation.NonNull android.net.NetworkAgentConfig config, @android.annotation.Nullable android.net.NetworkProvider provider) { throw new RuntimeException("Stub!"); }

public NetworkAgent(@android.annotation.NonNull android.content.Context context, @android.annotation.NonNull android.os.Looper looper, @android.annotation.NonNull java.lang.String logTag, @android.annotation.NonNull android.net.NetworkCapabilities nc, @android.annotation.NonNull android.net.LinkProperties lp, @android.annotation.NonNull android.net.NetworkScore score, @android.annotation.NonNull android.net.NetworkAgentConfig config, @android.annotation.Nullable android.net.NetworkProvider provider) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.Network register() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.net.Network getNetwork() { throw new RuntimeException("Stub!"); }

public final void sendLinkProperties(@android.annotation.NonNull android.net.LinkProperties linkProperties) { throw new RuntimeException("Stub!"); }

public final void setUnderlyingNetworks(@android.annotation.Nullable java.util.List<android.net.Network> underlyingNetworks) { throw new RuntimeException("Stub!"); }

public void markConnected() { throw new RuntimeException("Stub!"); }

public void unregister() { throw new RuntimeException("Stub!"); }

public void setTeardownDelayMillis(int teardownDelayMillis) { throw new RuntimeException("Stub!"); }

public void unregisterAfterReplacement(int timeoutMillis) { throw new RuntimeException("Stub!"); }

@Deprecated
public void setLegacySubtype(int legacySubtype, @android.annotation.NonNull java.lang.String legacySubtypeName) { throw new RuntimeException("Stub!"); }

public final void sendNetworkCapabilities(@android.annotation.NonNull android.net.NetworkCapabilities networkCapabilities) { throw new RuntimeException("Stub!"); }

public final void sendNetworkScore(@android.annotation.NonNull android.net.NetworkScore score) { throw new RuntimeException("Stub!"); }

public final void sendNetworkScore(int score) { throw new RuntimeException("Stub!"); }

public void onNetworkUnwanted() { throw new RuntimeException("Stub!"); }

public void onBandwidthUpdateRequested() { throw new RuntimeException("Stub!"); }

public void onValidationStatus(int status, @android.annotation.Nullable android.net.Uri redirectUri) { throw new RuntimeException("Stub!"); }

public void onSaveAcceptUnvalidated(boolean accept) { throw new RuntimeException("Stub!"); }

public void onNetworkCreated() { throw new RuntimeException("Stub!"); }

public void onNetworkDestroyed() { throw new RuntimeException("Stub!"); }

public void onDscpPolicyStatusUpdated(int policyId, int status) { throw new RuntimeException("Stub!"); }

public void onStartSocketKeepalive(int slot, @android.annotation.NonNull java.time.Duration interval, @android.annotation.NonNull android.net.KeepalivePacketData packet) { throw new RuntimeException("Stub!"); }

public void onStopSocketKeepalive(int slot) { throw new RuntimeException("Stub!"); }

public final void sendSocketKeepaliveEvent(int slot, int event) { throw new RuntimeException("Stub!"); }

public void onAddKeepalivePacketFilter(int slot, @android.annotation.NonNull android.net.KeepalivePacketData packet) { throw new RuntimeException("Stub!"); }

public void onRemoveKeepalivePacketFilter(int slot) { throw new RuntimeException("Stub!"); }

public void onSignalStrengthThresholdsUpdated(@android.annotation.NonNull int[] thresholds) { throw new RuntimeException("Stub!"); }

public void onAutomaticReconnectDisabled() { throw new RuntimeException("Stub!"); }

public void onQosCallbackRegistered(int qosCallbackId, @android.annotation.NonNull android.net.QosFilter filter) { throw new RuntimeException("Stub!"); }

public void onQosCallbackUnregistered(int qosCallbackId) { throw new RuntimeException("Stub!"); }

public final void sendQosSessionAvailable(int qosCallbackId, int sessionId, @android.annotation.NonNull android.net.QosSessionAttributes attributes) { throw new RuntimeException("Stub!"); }

public final void sendQosSessionLost(int qosCallbackId, int sessionId, int qosSessionType) { throw new RuntimeException("Stub!"); }

public final void sendQosCallbackError(int qosCallbackId, int exceptionType) { throw new RuntimeException("Stub!"); }

public void setLingerDuration(@android.annotation.NonNull java.time.Duration duration) { throw new RuntimeException("Stub!"); }

public void sendAddDscpPolicy(@android.annotation.NonNull android.net.DscpPolicy policy) { throw new RuntimeException("Stub!"); }

public void sendRemoveDscpPolicy(int policyId) { throw new RuntimeException("Stub!"); }

public void sendRemoveAllDscpPolicies() { throw new RuntimeException("Stub!"); }

public static final int DSCP_POLICY_STATUS_DELETED = 4; // 0x4

public static final int DSCP_POLICY_STATUS_INSUFFICIENT_PROCESSING_RESOURCES = 3; // 0x3

public static final int DSCP_POLICY_STATUS_POLICY_NOT_FOUND = 5; // 0x5

public static final int DSCP_POLICY_STATUS_REQUESTED_CLASSIFIER_NOT_SUPPORTED = 2; // 0x2

public static final int DSCP_POLICY_STATUS_REQUEST_DECLINED = 1; // 0x1

public static final int DSCP_POLICY_STATUS_SUCCESS = 0; // 0x0

public static final int VALIDATION_STATUS_NOT_VALID = 2; // 0x2

public static final int VALIDATION_STATUS_VALID = 1; // 0x1
}

