/*
 * Copyright (C) 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.nearby;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public abstract class PresenceCredential {

PresenceCredential() { throw new RuntimeException("Stub!"); }

public int getType() { throw new RuntimeException("Stub!"); }

public int getIdentityType() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public byte[] getSecretId() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public byte[] getAuthenticityKey() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.List<android.nearby.CredentialElement> getCredentialElements() { throw new RuntimeException("Stub!"); }

public boolean equals(java.lang.Object obj) { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }

public static final int CREDENTIAL_TYPE_PRIVATE = 0; // 0x0

public static final int CREDENTIAL_TYPE_PUBLIC = 1; // 0x1

public static final int IDENTITY_TYPE_PRIVATE = 1; // 0x1

public static final int IDENTITY_TYPE_PROVISIONED = 2; // 0x2

public static final int IDENTITY_TYPE_TRUSTED = 3; // 0x3

public static final int IDENTITY_TYPE_UNKNOWN = 0; // 0x0
}

