/*
 * Copyright 2017 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.net;

import java.net.Inet6Address;

/**
 * Representation of a MAC address.
 *
 * This class only supports 48 bits long addresses and does not support 64 bits long addresses.
 * Instances of this class are immutable. This class provides implementations of hashCode()
 * and equals() that make it suitable for use as keys in standard implementations of
 * {@link java.util.Map}.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class MacAddress implements android.os.Parcelable {

MacAddress() { throw new RuntimeException("Stub!"); }

/**
 * Returns the type of this address.
 *
 * @return the int constant representing the MAC address type of this MacAddress.

 * Value is android.net.MacAddress.TYPE_UNKNOWN, {@link android.net.MacAddress#TYPE_UNICAST}, {@link android.net.MacAddress#TYPE_MULTICAST}, or {@link android.net.MacAddress#TYPE_BROADCAST}
 */

public int getAddressType() { throw new RuntimeException("Stub!"); }

/**
 * @return true if this MacAddress is a locally assigned address.
 */

public boolean isLocallyAssigned() { throw new RuntimeException("Stub!"); }

/**
 * Convert this MacAddress to a byte array.
 *
 * The returned array is in network order. For example, if this MacAddress is 1:2:3:4:5:6,
 * the returned array is [1, 2, 3, 4, 5, 6].
 *
 * @return a byte array representation of this MacAddress.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public byte[] toByteArray() { throw new RuntimeException("Stub!"); }

/**
 * Returns a human-readable representation of this MacAddress.
 * The exact format is implementation-dependent and should not be assumed to have any
 * particular format.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.lang.String toString() { throw new RuntimeException("Stub!"); }

/**
 * @return a String representation of the OUI part of this MacAddress made of 3 hexadecimal
 * numbers in [0,ff] joined by ':' characters.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.lang.String toOuiString() { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param o This value may be {@code null}.
 */

public boolean equals(@android.annotation.Nullable java.lang.Object o) { throw new RuntimeException("Stub!"); }

public void writeToParcel(android.os.Parcel out, int flags) { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

/**
 * Creates a MacAddress from the given String representation. A valid String representation
 * for a MacAddress is a series of 6 values in the range [0,ff] printed in hexadecimal
 * and joined by ':' characters.
 *
 * @param addr a String representation of a MAC address.
 * This value cannot be {@code null}.
 * @return the MacAddress corresponding to the given String representation.
 * This value cannot be {@code null}.
 * @throws java.lang.IllegalArgumentException if the given String is not a valid representation.
 */

@android.annotation.NonNull
public static android.net.MacAddress fromString(@android.annotation.NonNull java.lang.String addr) { throw new RuntimeException("Stub!"); }

/**
 * Creates a MacAddress from the given byte array representation.
 * A valid byte array representation for a MacAddress is a non-null array of length 6.
 *
 * @param addr a byte array representation of a MAC address.
 * This value cannot be {@code null}.
 * @return the MacAddress corresponding to the given byte array representation.
 * @throws java.lang.IllegalArgumentException if the given byte array is not a valid representation.
 */

@android.annotation.NonNull
public static android.net.MacAddress fromBytes(@android.annotation.NonNull byte[] addr) { throw new RuntimeException("Stub!"); }

/**
 * Checks if this MAC Address matches the provided range.
 *
 * @param baseAddress MacAddress representing the base address to compare with.
 * This value cannot be {@code null}.
 * @param mask MacAddress representing the mask to use during comparison.
 * This value cannot be {@code null}.
 * @return true if this MAC Address matches the given range.
 *
 */

public boolean matches(@android.annotation.NonNull android.net.MacAddress baseAddress, @android.annotation.NonNull android.net.MacAddress mask) { throw new RuntimeException("Stub!"); }

/**
 * Create a link-local Inet6Address from the MAC address. The EUI-48 MAC address is converted
 * to an EUI-64 MAC address per RFC 4291. The resulting EUI-64 is used to construct a link-local
 * IPv6 address per RFC 4862.
 *
 * @return A link-local Inet6Address constructed from the MAC address.

 * This value may be {@code null}.
 */

@android.annotation.Nullable
public java.net.Inet6Address getLinkLocalIpv6FromEui48Mac() { throw new RuntimeException("Stub!"); }

/**
 * The MacAddress representing the unique broadcast MAC address.
 */

public static final android.net.MacAddress BROADCAST_ADDRESS;
static { BROADCAST_ADDRESS = null; }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.net.MacAddress> CREATOR;
static { CREATOR = null; }

/** Indicates a MAC address is the broadcast address. */

public static final int TYPE_BROADCAST = 3; // 0x3

/** Indicates a MAC address is a multicast address. */

public static final int TYPE_MULTICAST = 2; // 0x2

/** Indicates a MAC address is a unicast address. */

public static final int TYPE_UNICAST = 1; // 0x1
}

