/*
 * Copyright (C) 2021 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package android.net.vcn;

import android.net.NetworkCapabilities;
import android.telephony.SubscriptionInfo;
import android.telephony.SubscriptionManager;
import android.telephony.TelephonyManager;
import java.util.Set;

/**
 * This class represents a configuration for a network template class of underlying cellular
 * networks.
 *
 * <p>See {@link android.net.vcn.VcnUnderlyingNetworkTemplate VcnUnderlyingNetworkTemplate}
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class VcnCellUnderlyingNetworkTemplate extends android.net.vcn.VcnUnderlyingNetworkTemplate {

VcnCellUnderlyingNetworkTemplate() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param other This value may be {@code null}.
 */

public boolean equals(@android.annotation.Nullable java.lang.Object other) { throw new RuntimeException("Stub!"); }

/**
 * Returns the matching criteria for CBS networks.
 *
 * @see android.net.vcn.VcnCellUnderlyingNetworkTemplate.Builder#setCbs(int)

 * @return Value is {@link android.net.vcn.VcnUnderlyingNetworkTemplate#MATCH_ANY}, {@link android.net.vcn.VcnUnderlyingNetworkTemplate#MATCH_REQUIRED}, or {@link android.net.vcn.VcnUnderlyingNetworkTemplate#MATCH_FORBIDDEN}
 */

public int getCbs() { throw new RuntimeException("Stub!"); }

/**
 * Returns the matching criteria for DUN networks.
 *
 * @see android.net.vcn.VcnCellUnderlyingNetworkTemplate.Builder#setDun(int)

 * @return Value is {@link android.net.vcn.VcnUnderlyingNetworkTemplate#MATCH_ANY}, {@link android.net.vcn.VcnUnderlyingNetworkTemplate#MATCH_REQUIRED}, or {@link android.net.vcn.VcnUnderlyingNetworkTemplate#MATCH_FORBIDDEN}
 */

public int getDun() { throw new RuntimeException("Stub!"); }

/**
 * Returns the matching criteria for IMS networks.
 *
 * @see android.net.vcn.VcnCellUnderlyingNetworkTemplate.Builder#setIms(int)

 * @return Value is {@link android.net.vcn.VcnUnderlyingNetworkTemplate#MATCH_ANY}, {@link android.net.vcn.VcnUnderlyingNetworkTemplate#MATCH_REQUIRED}, or {@link android.net.vcn.VcnUnderlyingNetworkTemplate#MATCH_FORBIDDEN}
 */

public int getIms() { throw new RuntimeException("Stub!"); }

/**
 * Returns the matching criteria for INTERNET networks.
 *
 * @see android.net.vcn.VcnCellUnderlyingNetworkTemplate.Builder#setInternet(int)

 * @return Value is {@link android.net.vcn.VcnUnderlyingNetworkTemplate#MATCH_ANY}, {@link android.net.vcn.VcnUnderlyingNetworkTemplate#MATCH_REQUIRED}, or {@link android.net.vcn.VcnUnderlyingNetworkTemplate#MATCH_FORBIDDEN}
 */

public int getInternet() { throw new RuntimeException("Stub!"); }

/**
 * Returns the matching criteria for MMS networks.
 *
 * @see android.net.vcn.VcnCellUnderlyingNetworkTemplate.Builder#setMms(int)

 * @return Value is {@link android.net.vcn.VcnUnderlyingNetworkTemplate#MATCH_ANY}, {@link android.net.vcn.VcnUnderlyingNetworkTemplate#MATCH_REQUIRED}, or {@link android.net.vcn.VcnUnderlyingNetworkTemplate#MATCH_FORBIDDEN}
 */

public int getMms() { throw new RuntimeException("Stub!"); }

/**
 * Retrieve the matching operator PLMN IDs, or an empty set if any PLMN ID is acceptable.
 *
 * @see android.net.vcn.VcnCellUnderlyingNetworkTemplate.Builder#setOperatorPlmnIds(Set)

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.util.Set<java.lang.String> getOperatorPlmnIds() { throw new RuntimeException("Stub!"); }

/**
 * Return the matching criteria for opportunistic cellular subscriptions.
 *
 * @see android.net.vcn.VcnCellUnderlyingNetworkTemplate.Builder#setOpportunistic(int)

 * @return Value is {@link android.net.vcn.VcnUnderlyingNetworkTemplate#MATCH_ANY}, {@link android.net.vcn.VcnUnderlyingNetworkTemplate#MATCH_REQUIRED}, or {@link android.net.vcn.VcnUnderlyingNetworkTemplate#MATCH_FORBIDDEN}
 */

public int getOpportunistic() { throw new RuntimeException("Stub!"); }

/**
 * Returns the matching criteria for RCS networks.
 *
 * @see android.net.vcn.VcnCellUnderlyingNetworkTemplate.Builder#setRcs(int)

 * @return Value is {@link android.net.vcn.VcnUnderlyingNetworkTemplate#MATCH_ANY}, {@link android.net.vcn.VcnUnderlyingNetworkTemplate#MATCH_REQUIRED}, or {@link android.net.vcn.VcnUnderlyingNetworkTemplate#MATCH_FORBIDDEN}
 */

public int getRcs() { throw new RuntimeException("Stub!"); }

/**
 * Return the matching criteria for roaming networks.
 *
 * @see android.net.vcn.VcnCellUnderlyingNetworkTemplate.Builder#setRoaming(int)

 * @return Value is {@link android.net.vcn.VcnUnderlyingNetworkTemplate#MATCH_ANY}, {@link android.net.vcn.VcnUnderlyingNetworkTemplate#MATCH_REQUIRED}, or {@link android.net.vcn.VcnUnderlyingNetworkTemplate#MATCH_FORBIDDEN}
 */

public int getRoaming() { throw new RuntimeException("Stub!"); }

/**
 * Retrieve the matching sim specific carrier IDs, or an empty set if any sim specific carrier
 * ID is acceptable.
 *
 * @see android.net.vcn.VcnCellUnderlyingNetworkTemplate.Builder#setSimSpecificCarrierIds(Set)

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.util.Set<java.lang.Integer> getSimSpecificCarrierIds() { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }
/** This class is used to incrementally build VcnCellUnderlyingNetworkTemplate objects. */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

/** Construct a Builder object. */

public Builder() { throw new RuntimeException("Stub!"); }

/**
 * Build the VcnCellUnderlyingNetworkTemplate.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.vcn.VcnCellUnderlyingNetworkTemplate build() { throw new RuntimeException("Stub!"); }

/**
 * Sets the matching criteria for CBS networks.
 *
 * <p>A template where {@code setCbs(MATCH_REQUIRED)} is called will only match CBS networks
 * (ones with NET_CAPABILITY_CBS). A template where {@code setCbs(MATCH_FORBIDDEN)} is
 * called will only match networks that do not support CBS (ones without
 * NET_CAPABILITY_CBS).
 *
 * @param matchCriteria the matching criteria for CBS networks. Defaults to {@link
 *     #MATCH_ANY}.
 * Value is {@link android.net.vcn.VcnUnderlyingNetworkTemplate#MATCH_ANY}, {@link android.net.vcn.VcnUnderlyingNetworkTemplate#MATCH_REQUIRED}, or {@link android.net.vcn.VcnUnderlyingNetworkTemplate#MATCH_FORBIDDEN}
 * @see android.net.NetworkCapabilities#NET_CAPABILITY_CBS
 
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.vcn.VcnCellUnderlyingNetworkTemplate.Builder setCbs(int matchCriteria) { throw new RuntimeException("Stub!"); }

/**
 * Sets the matching criteria for DUN networks.
 *
 * <p>A template where {@code setDun(MATCH_REQUIRED)} is called will only match DUN networks
 * (ones with NET_CAPABILITY_DUN). A template where {@code setDun(MATCH_FORBIDDEN)} is
 * called will only match networks that do not support DUN (ones without
 * NET_CAPABILITY_DUN).
 *
 * @param matchCriteria the matching criteria for DUN networks. Defaults to {@link
 *     #MATCH_ANY}.
 * Value is {@link android.net.vcn.VcnUnderlyingNetworkTemplate#MATCH_ANY}, {@link android.net.vcn.VcnUnderlyingNetworkTemplate#MATCH_REQUIRED}, or {@link android.net.vcn.VcnUnderlyingNetworkTemplate#MATCH_FORBIDDEN}
 * @see android.net.NetworkCapabilities#NET_CAPABILITY_DUN
 
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.vcn.VcnCellUnderlyingNetworkTemplate.Builder setDun(int matchCriteria) { throw new RuntimeException("Stub!"); }

/**
 * Sets the matching criteria for IMS networks.
 *
 * <p>A template where {@code setIms(MATCH_REQUIRED)} is called will only match IMS networks
 * (ones with NET_CAPABILITY_IMS). A template where {@code setIms(MATCH_FORBIDDEN)} is
 * called will only match networks that do not support IMS (ones without
 * NET_CAPABILITY_IMS).
 *
 * @param matchCriteria the matching criteria for IMS networks. Defaults to {@link
 *     #MATCH_ANY}.
 * Value is {@link android.net.vcn.VcnUnderlyingNetworkTemplate#MATCH_ANY}, {@link android.net.vcn.VcnUnderlyingNetworkTemplate#MATCH_REQUIRED}, or {@link android.net.vcn.VcnUnderlyingNetworkTemplate#MATCH_FORBIDDEN}
 * @see android.net.NetworkCapabilities#NET_CAPABILITY_IMS
 
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.vcn.VcnCellUnderlyingNetworkTemplate.Builder setIms(int matchCriteria) { throw new RuntimeException("Stub!"); }

/**
 * Sets the matching criteria for INTERNET networks.
 *
 * <p>A template where {@code setInternet(MATCH_REQUIRED)} is called will only match
 * INTERNET networks (ones with NET_CAPABILITY_INTERNET). A template where {@code
 * setInternet(MATCH_FORBIDDEN)} is called will only match networks that do not support
 * INTERNET (ones without NET_CAPABILITY_INTERNET).
 *
 * @param matchCriteria the matching criteria for INTERNET networks. Defaults to {@link
 *     #MATCH_REQUIRED}.
 * Value is {@link android.net.vcn.VcnUnderlyingNetworkTemplate#MATCH_ANY}, {@link android.net.vcn.VcnUnderlyingNetworkTemplate#MATCH_REQUIRED}, or {@link android.net.vcn.VcnUnderlyingNetworkTemplate#MATCH_FORBIDDEN}
 * @see android.net.NetworkCapabilities#NET_CAPABILITY_INTERNET
 
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.vcn.VcnCellUnderlyingNetworkTemplate.Builder setInternet(int matchCriteria) { throw new RuntimeException("Stub!"); }

/**
 * Set the matching criteria for metered networks.
 *
 * <p>A template where setMetered(MATCH_REQUIRED) will only match metered networks (one
 * without NET_CAPABILITY_NOT_METERED). A template where setMetered(MATCH_FORBIDDEN) will
 * only match a network that is not metered (one with NET_CAPABILITY_NOT_METERED).
 *
 * @param matchCriteria the matching criteria for metered networks. Defaults to {@link
 *     #MATCH_ANY}.
 * Value is {@link android.net.vcn.VcnUnderlyingNetworkTemplate#MATCH_ANY}, {@link android.net.vcn.VcnUnderlyingNetworkTemplate#MATCH_REQUIRED}, or {@link android.net.vcn.VcnUnderlyingNetworkTemplate#MATCH_FORBIDDEN}
 * @see android.net.NetworkCapabilities#NET_CAPABILITY_NOT_METERED
 
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.vcn.VcnCellUnderlyingNetworkTemplate.Builder setMetered(int matchCriteria) { throw new RuntimeException("Stub!"); }

/**
 * Set the minimum upstream bandwidths that this template will match.
 *
 * <p>This template will not match a network that does not provide at least the bandwidth
 * passed as the entry bandwidth, except in the case that the network is selected as the VCN
 * Gateway Connection's underlying network, where it will continue to match until the
 * bandwidth drops under the exit bandwidth.
 *
 * <p>The entry criteria MUST be greater than, or equal to the exit criteria to avoid the
 * invalid case where a network fulfills the entry criteria, but at the same time fails the
 * exit criteria.
 *
 * <p>Estimated bandwidth of a network is provided by the transport layer, and reported in
 * {@link android.net.NetworkCapabilities NetworkCapabilities}. The provided estimates will be used without modification.
 *
 * @param minEntryDownstreamBandwidthKbps the minimum accepted downstream bandwidth for
 *     networks that ARE NOT the already-selected underlying network, or {@code 0} to
 *     disable this requirement. Disabled by default.
 * @param minExitDownstreamBandwidthKbps the minimum accepted downstream bandwidth for a
 *     network that IS the already-selected underlying network, or {@code 0} to disable this
 *     requirement. Disabled by default.
 * @return this {@link android.net.vcn.VcnCellUnderlyingNetworkTemplate.Builder Builder} instance, for chaining

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.vcn.VcnCellUnderlyingNetworkTemplate.Builder setMinDownstreamBandwidthKbps(int minEntryDownstreamBandwidthKbps, int minExitDownstreamBandwidthKbps) { throw new RuntimeException("Stub!"); }

/**
 * Set the minimum upstream bandwidths that this template will match.
 *
 * <p>This template will not match a network that does not provide at least the bandwidth
 * passed as the entry bandwidth, except in the case that the network is selected as the VCN
 * Gateway Connection's underlying network, where it will continue to match until the
 * bandwidth drops under the exit bandwidth.
 *
 * <p>The entry criteria MUST be greater than, or equal to the exit criteria to avoid the
 * invalid case where a network fulfills the entry criteria, but at the same time fails the
 * exit criteria.
 *
 * <p>Estimated bandwidth of a network is provided by the transport layer, and reported in
 * {@link android.net.NetworkCapabilities NetworkCapabilities}. The provided estimates will be used without modification.
 *
 * @param minEntryUpstreamBandwidthKbps the minimum accepted upstream bandwidth for networks
 *     that ARE NOT the already-selected underlying network, or {@code 0} to disable this
 *     requirement. Disabled by default.
 * @param minExitUpstreamBandwidthKbps the minimum accepted upstream bandwidth for a network
 *     that IS the already-selected underlying network, or {@code 0} to disable this
 *     requirement. Disabled by default.
 * @return this {@link android.net.vcn.VcnCellUnderlyingNetworkTemplate.Builder Builder} instance, for chaining

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.vcn.VcnCellUnderlyingNetworkTemplate.Builder setMinUpstreamBandwidthKbps(int minEntryUpstreamBandwidthKbps, int minExitUpstreamBandwidthKbps) { throw new RuntimeException("Stub!"); }

/**
 * Sets the matching criteria for MMS networks.
 *
 * <p>A template where {@code setMms(MATCH_REQUIRED)} is called will only match MMS networks
 * (ones with NET_CAPABILITY_MMS). A template where {@code setMms(MATCH_FORBIDDEN)} is
 * called will only match networks that do not support MMS (ones without
 * NET_CAPABILITY_MMS).
 *
 * @param matchCriteria the matching criteria for MMS networks. Defaults to {@link
 *     #MATCH_ANY}.
 * Value is {@link android.net.vcn.VcnUnderlyingNetworkTemplate#MATCH_ANY}, {@link android.net.vcn.VcnUnderlyingNetworkTemplate#MATCH_REQUIRED}, or {@link android.net.vcn.VcnUnderlyingNetworkTemplate#MATCH_FORBIDDEN}
 * @see android.net.NetworkCapabilities#NET_CAPABILITY_MMS
 
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.vcn.VcnCellUnderlyingNetworkTemplate.Builder setMms(int matchCriteria) { throw new RuntimeException("Stub!"); }

/**
 * Set operator PLMN IDs with which a network can match this template.
 *
 * <p>This is used to distinguish cases where roaming agreements may dictate a different
 * priority from a partner's networks.
 *
 * @param operatorPlmnIds the matching operator PLMN IDs in String. Network with one of the
 *     matching PLMN IDs can match this template. If the set is empty, any PLMN ID will
 *     match. The default is an empty set. A valid PLMN is a concatenation of MNC and MCC,
 *     and thus consists of 5 or 6 decimal digits.
 * This value cannot be {@code null}.
 * @see android.telephony.SubscriptionInfo#getMccString()
 * @see android.telephony.SubscriptionInfo#getMncString()
 
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.vcn.VcnCellUnderlyingNetworkTemplate.Builder setOperatorPlmnIds(@android.annotation.NonNull java.util.Set<java.lang.String> operatorPlmnIds) { throw new RuntimeException("Stub!"); }

/**
 * Set the matching criteria for opportunistic cellular subscriptions.
 *
 * @param matchCriteria the matching criteria for opportunistic cellular subscriptions.
 *     Defaults to {@link #MATCH_ANY}.
 * Value is {@link android.net.vcn.VcnUnderlyingNetworkTemplate#MATCH_ANY}, {@link android.net.vcn.VcnUnderlyingNetworkTemplate#MATCH_REQUIRED}, or {@link android.net.vcn.VcnUnderlyingNetworkTemplate#MATCH_FORBIDDEN}
 * @see android.telephony.SubscriptionManager#setOpportunistic(boolean, int)
 
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.vcn.VcnCellUnderlyingNetworkTemplate.Builder setOpportunistic(int matchCriteria) { throw new RuntimeException("Stub!"); }

/**
 * Sets the matching criteria for RCS networks.
 *
 * <p>A template where {@code setRcs(MATCH_REQUIRED)} is called will only match RCS networks
 * (ones with NET_CAPABILITY_RCS). A template where {@code setRcs(MATCH_FORBIDDEN)} is
 * called will only match networks that do not support RCS (ones without
 * NET_CAPABILITY_RCS).
 *
 * @param matchCriteria the matching criteria for RCS networks. Defaults to {@link
 *     #MATCH_ANY}.
 * Value is {@link android.net.vcn.VcnUnderlyingNetworkTemplate#MATCH_ANY}, {@link android.net.vcn.VcnUnderlyingNetworkTemplate#MATCH_REQUIRED}, or {@link android.net.vcn.VcnUnderlyingNetworkTemplate#MATCH_FORBIDDEN}
 * @see android.net.NetworkCapabilities#NET_CAPABILITY_RCS
 
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.vcn.VcnCellUnderlyingNetworkTemplate.Builder setRcs(int matchCriteria) { throw new RuntimeException("Stub!"); }

/**
 * Set the matching criteria for roaming networks.
 *
 * <p>A template where setRoaming(MATCH_REQUIRED) will only match roaming networks (one
 * without NET_CAPABILITY_NOT_ROAMING). A template where setRoaming(MATCH_FORBIDDEN) will
 * only match a network that is not roaming (one with NET_CAPABILITY_NOT_ROAMING).
 *
 * @param matchCriteria the matching criteria for roaming networks. Defaults to {@link
 *     #MATCH_ANY}.
 * Value is {@link android.net.vcn.VcnUnderlyingNetworkTemplate#MATCH_ANY}, {@link android.net.vcn.VcnUnderlyingNetworkTemplate#MATCH_REQUIRED}, or {@link android.net.vcn.VcnUnderlyingNetworkTemplate#MATCH_FORBIDDEN}
 * @see android.net.NetworkCapabilities#NET_CAPABILITY_NOT_ROAMING
 
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.vcn.VcnCellUnderlyingNetworkTemplate.Builder setRoaming(int matchCriteria) { throw new RuntimeException("Stub!"); }

/**
 * Set sim specific carrier IDs with which a network can match this template.
 *
 * @param simSpecificCarrierIds the matching sim specific carrier IDs. Network with one of
 *     the sim specific carrier IDs can match this template. If the set is empty, any
 *     carrier ID will match. The default is an empty set.
 * This value cannot be {@code null}.
 * @see android.telephony.TelephonyManager#getSimSpecificCarrierId()
 
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.vcn.VcnCellUnderlyingNetworkTemplate.Builder setSimSpecificCarrierIds(@android.annotation.NonNull java.util.Set<java.lang.Integer> simSpecificCarrierIds) { throw new RuntimeException("Stub!"); }
}

}

