/*
 * Copyright (C) 2019 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.net;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public class ConnectivityDiagnosticsManager {

ConnectivityDiagnosticsManager() { throw new RuntimeException("Stub!"); }

public void registerConnectivityDiagnosticsCallback(@android.annotation.NonNull android.net.NetworkRequest request, @android.annotation.NonNull java.util.concurrent.Executor e, @android.annotation.NonNull android.net.ConnectivityDiagnosticsManager.ConnectivityDiagnosticsCallback callback) { throw new RuntimeException("Stub!"); }

public void unregisterConnectivityDiagnosticsCallback(@android.annotation.NonNull android.net.ConnectivityDiagnosticsManager.ConnectivityDiagnosticsCallback callback) { throw new RuntimeException("Stub!"); }
@SuppressWarnings({"unchecked", "deprecation", "all"})
public abstract static class ConnectivityDiagnosticsCallback {

public ConnectivityDiagnosticsCallback() { throw new RuntimeException("Stub!"); }

public void onConnectivityReportAvailable(@android.annotation.NonNull android.net.ConnectivityDiagnosticsManager.ConnectivityReport report) { throw new RuntimeException("Stub!"); }

public void onDataStallSuspected(@android.annotation.NonNull android.net.ConnectivityDiagnosticsManager.DataStallReport report) { throw new RuntimeException("Stub!"); }

public void onNetworkConnectivityReported(@android.annotation.NonNull android.net.Network network, boolean hasConnectivity) { throw new RuntimeException("Stub!"); }
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class ConnectivityReport implements android.os.Parcelable {

public ConnectivityReport(@android.annotation.NonNull android.net.Network network, long reportTimestamp, @android.annotation.NonNull android.net.LinkProperties linkProperties, @android.annotation.NonNull android.net.NetworkCapabilities networkCapabilities, @android.annotation.NonNull android.os.PersistableBundle additionalInfo) { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

public boolean equals(@android.annotation.Nullable java.lang.Object o) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.os.PersistableBundle getAdditionalInfo() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.LinkProperties getLinkProperties() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.Network getNetwork() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.NetworkCapabilities getNetworkCapabilities() { throw new RuntimeException("Stub!"); }

public long getReportTimestamp() { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.net.ConnectivityDiagnosticsManager.ConnectivityReport> CREATOR;
static { CREATOR = null; }

public static final java.lang.String KEY_NETWORK_PROBES_ATTEMPTED_BITMASK = "networkProbesAttempted";

public static final java.lang.String KEY_NETWORK_PROBES_SUCCEEDED_BITMASK = "networkProbesSucceeded";

public static final java.lang.String KEY_NETWORK_VALIDATION_RESULT = "networkValidationResult";

public static final int NETWORK_PROBE_DNS = 4; // 0x4

public static final int NETWORK_PROBE_FALLBACK = 32; // 0x20

public static final int NETWORK_PROBE_HTTP = 8; // 0x8

public static final int NETWORK_PROBE_HTTPS = 16; // 0x10

public static final int NETWORK_PROBE_PRIVATE_DNS = 64; // 0x40

public static final int NETWORK_VALIDATION_RESULT_INVALID = 0; // 0x0

public static final int NETWORK_VALIDATION_RESULT_PARTIALLY_VALID = 2; // 0x2

public static final int NETWORK_VALIDATION_RESULT_SKIPPED = 3; // 0x3

public static final int NETWORK_VALIDATION_RESULT_VALID = 1; // 0x1
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class DataStallReport implements android.os.Parcelable {

public DataStallReport(@android.annotation.NonNull android.net.Network network, long reportTimestamp, int detectionMethod, @android.annotation.NonNull android.net.LinkProperties linkProperties, @android.annotation.NonNull android.net.NetworkCapabilities networkCapabilities, @android.annotation.NonNull android.os.PersistableBundle stallDetails) { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

public boolean equals(@android.annotation.Nullable java.lang.Object o) { throw new RuntimeException("Stub!"); }

public int getDetectionMethod() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.LinkProperties getLinkProperties() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.Network getNetwork() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.net.NetworkCapabilities getNetworkCapabilities() { throw new RuntimeException("Stub!"); }

public long getReportTimestamp() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.os.PersistableBundle getStallDetails() { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.net.ConnectivityDiagnosticsManager.DataStallReport> CREATOR;
static { CREATOR = null; }

public static final int DETECTION_METHOD_DNS_EVENTS = 1; // 0x1

public static final int DETECTION_METHOD_TCP_METRICS = 2; // 0x2

public static final java.lang.String KEY_DNS_CONSECUTIVE_TIMEOUTS = "dnsConsecutiveTimeouts";

public static final java.lang.String KEY_TCP_METRICS_COLLECTION_PERIOD_MILLIS = "tcpMetricsCollectionPeriodMillis";

public static final java.lang.String KEY_TCP_PACKET_FAIL_RATE = "tcpPacketFailRate";
}

}

