/*
 * Copyright (C) 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package android.health.connect.datatypes;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class SleepSessionRecord extends android.health.connect.datatypes.IntervalRecord {

SleepSessionRecord() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public java.lang.CharSequence getNotes() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public java.lang.CharSequence getTitle() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.util.List<android.health.connect.datatypes.SleepSessionRecord.Stage> getStages() { throw new RuntimeException("Stub!"); }

public boolean equals(java.lang.Object o) { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.health.connect.datatypes.AggregationType<java.lang.Long> SLEEP_DURATION_TOTAL;
static { SLEEP_DURATION_TOTAL = null; }
@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

public Builder(@android.annotation.NonNull android.health.connect.datatypes.Metadata metadata, @android.annotation.NonNull java.time.Instant startTime, @android.annotation.NonNull java.time.Instant endTime) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.health.connect.datatypes.SleepSessionRecord.Builder setStartZoneOffset(@android.annotation.NonNull java.time.ZoneOffset startZoneOffset) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.health.connect.datatypes.SleepSessionRecord.Builder setEndZoneOffset(@android.annotation.NonNull java.time.ZoneOffset endZoneOffset) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.health.connect.datatypes.SleepSessionRecord.Builder clearStartZoneOffset() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.health.connect.datatypes.SleepSessionRecord.Builder clearEndZoneOffset() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.health.connect.datatypes.SleepSessionRecord.Builder setNotes(@android.annotation.Nullable java.lang.CharSequence notes) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.health.connect.datatypes.SleepSessionRecord.Builder setTitle(@android.annotation.Nullable java.lang.CharSequence title) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.health.connect.datatypes.SleepSessionRecord.Builder setStages(@android.annotation.NonNull java.util.List<android.health.connect.datatypes.SleepSessionRecord.Stage> stages) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.health.connect.datatypes.SleepSessionRecord build() { throw new RuntimeException("Stub!"); }
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static class Stage {

public Stage(@android.annotation.NonNull java.time.Instant startTime, @android.annotation.NonNull java.time.Instant endTime, int stageType) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.time.Instant getStartTime() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.time.Instant getEndTime() { throw new RuntimeException("Stub!"); }

public int getType() { throw new RuntimeException("Stub!"); }

public boolean equals(java.lang.Object o) { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class StageType {

StageType() { throw new RuntimeException("Stub!"); }

public static final int STAGE_TYPE_AWAKE = 1; // 0x1

public static final int STAGE_TYPE_AWAKE_IN_BED = 7; // 0x7

public static final int STAGE_TYPE_AWAKE_OUT_OF_BED = 3; // 0x3

public static final int STAGE_TYPE_SLEEPING = 2; // 0x2

public static final int STAGE_TYPE_SLEEPING_DEEP = 5; // 0x5

public static final int STAGE_TYPE_SLEEPING_LIGHT = 4; // 0x4

public static final int STAGE_TYPE_SLEEPING_REM = 6; // 0x6

public static final int STAGE_TYPE_UNKNOWN = 0; // 0x0
}

}

