/*
 * Copyright (C) 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.health.connect.datatypes;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class RecordTypeIdentifier {

RecordTypeIdentifier() { throw new RuntimeException("Stub!"); }

public static final int RECORD_TYPE_ACTIVE_CALORIES_BURNED = 2; // 0x2

public static final int RECORD_TYPE_ACTIVITY_INTENSITY = 42; // 0x2a

public static final int RECORD_TYPE_BASAL_BODY_TEMPERATURE = 20; // 0x14

public static final int RECORD_TYPE_BASAL_METABOLIC_RATE = 16; // 0x10

public static final int RECORD_TYPE_BLOOD_GLUCOSE = 25; // 0x19

public static final int RECORD_TYPE_BLOOD_PRESSURE = 23; // 0x17

public static final int RECORD_TYPE_BODY_FAT = 17; // 0x11

public static final int RECORD_TYPE_BODY_TEMPERATURE = 29; // 0x1d

public static final int RECORD_TYPE_BODY_WATER_MASS = 34; // 0x22

public static final int RECORD_TYPE_BONE_MASS = 32; // 0x20

public static final int RECORD_TYPE_CERVICAL_MUCUS = 19; // 0x13

public static final int RECORD_TYPE_CYCLING_PEDALING_CADENCE = 12; // 0xc

public static final int RECORD_TYPE_DISTANCE = 7; // 0x7

public static final int RECORD_TYPE_ELEVATION_GAINED = 4; // 0x4

public static final int RECORD_TYPE_EXERCISE_SESSION = 37; // 0x25

public static final int RECORD_TYPE_FLOORS_CLIMBED = 5; // 0x5

public static final int RECORD_TYPE_HEART_RATE = 11; // 0xb

public static final int RECORD_TYPE_HEART_RATE_VARIABILITY_RMSSD = 35; // 0x23

public static final int RECORD_TYPE_HEIGHT = 24; // 0x18

public static final int RECORD_TYPE_HYDRATION = 3; // 0x3

public static final int RECORD_TYPE_INTERMENSTRUAL_BLEEDING = 36; // 0x24

public static final int RECORD_TYPE_LEAN_BODY_MASS = 27; // 0x1b

public static final int RECORD_TYPE_MENSTRUATION_FLOW = 21; // 0x15

public static final int RECORD_TYPE_MENSTRUATION_PERIOD = 10; // 0xa

public static final int RECORD_TYPE_MINDFULNESS_SESSION = 41; // 0x29

public static final int RECORD_TYPE_NUTRITION = 8; // 0x8

public static final int RECORD_TYPE_OVULATION_TEST = 30; // 0x1e

public static final int RECORD_TYPE_OXYGEN_SATURATION = 22; // 0x16

public static final int RECORD_TYPE_PLANNED_EXERCISE_SESSION = 40; // 0x28

public static final int RECORD_TYPE_POWER = 13; // 0xd

public static final int RECORD_TYPE_RESPIRATORY_RATE = 31; // 0x1f

public static final int RECORD_TYPE_RESTING_HEART_RATE = 33; // 0x21

public static final int RECORD_TYPE_SEXUAL_ACTIVITY = 28; // 0x1c

public static final int RECORD_TYPE_SKIN_TEMPERATURE = 39; // 0x27

public static final int RECORD_TYPE_SLEEP_SESSION = 38; // 0x26

public static final int RECORD_TYPE_SPEED = 14; // 0xe

public static final int RECORD_TYPE_STEPS = 1; // 0x1

public static final int RECORD_TYPE_STEPS_CADENCE = 15; // 0xf

public static final int RECORD_TYPE_TOTAL_CALORIES_BURNED = 9; // 0x9

public static final int RECORD_TYPE_UNKNOWN = 0; // 0x0

public static final int RECORD_TYPE_VO2_MAX = 18; // 0x12

public static final int RECORD_TYPE_WEIGHT = 26; // 0x1a

public static final int RECORD_TYPE_WHEELCHAIR_PUSHES = 6; // 0x6
}

