/*
 * Copyright (C) 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.health.connect;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public class HealthPermissionCategory {

HealthPermissionCategory() { throw new RuntimeException("Stub!"); }

public static final int ACTIVE_CALORIES_BURNED = 1; // 0x1

public static final int ACTIVITY_INTENSITY = 42; // 0x2a

public static final int BASAL_BODY_TEMPERATURE = 33; // 0x21

public static final int BASAL_METABOLIC_RATE = 9; // 0x9

public static final int BLOOD_GLUCOSE = 26; // 0x1a

public static final int BLOOD_PRESSURE = 27; // 0x1b

public static final int BODY_FAT = 10; // 0xa

public static final int BODY_TEMPERATURE = 28; // 0x1c

public static final int BODY_WATER_MASS = 11; // 0xb

public static final int BONE_MASS = 12; // 0xc

public static final int CERVICAL_MUCUS = 18; // 0x12

public static final int DISTANCE = 2; // 0x2

public static final int ELEVATION_GAINED = 3; // 0x3

public static final int EXERCISE = 4; // 0x4

public static final int FLOORS_CLIMBED = 5; // 0x5

public static final int HEART_RATE = 29; // 0x1d

public static final int HEART_RATE_VARIABILITY = 30; // 0x1e

public static final int HEIGHT = 13; // 0xd

public static final int HYDRATION = 23; // 0x17

public static final int INTERMENSTRUAL_BLEEDING = 38; // 0x26

public static final int LEAN_BODY_MASS = 15; // 0xf

public static final int MENSTRUATION = 20; // 0x14

public static final int MINDFULNESS = 41; // 0x29

public static final int NUTRITION = 24; // 0x18

public static final int OVULATION_TEST = 21; // 0x15

public static final int OXYGEN_SATURATION = 31; // 0x1f

public static final int PLANNED_EXERCISE = 40; // 0x28

public static final int POWER = 36; // 0x24

public static final int RESPIRATORY_RATE = 32; // 0x20

public static final int RESTING_HEART_RATE = 34; // 0x22

public static final int SEXUAL_ACTIVITY = 22; // 0x16

public static final int SKIN_TEMPERATURE = 39; // 0x27

public static final int SLEEP = 25; // 0x19

public static final int SPEED = 37; // 0x25

public static final int STEPS = 6; // 0x6

public static final int TOTAL_CALORIES_BURNED = 35; // 0x23

public static final int UNKNOWN = 0; // 0x0

public static final int VO2_MAX = 7; // 0x7

public static final int WEIGHT = 17; // 0x11

public static final int WHEELCHAIR_PUSHES = 8; // 0x8
}

