/*
 * Copyright (C) 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package android.health.connect.datatypes;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class BloodPressureRecord extends android.health.connect.datatypes.InstantRecord {

BloodPressureRecord() { throw new RuntimeException("Stub!"); }

public boolean equals(java.lang.Object o) { throw new RuntimeException("Stub!"); }

public int getBodyPosition() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.health.connect.datatypes.units.Pressure getDiastolic() { throw new RuntimeException("Stub!"); }

public int getMeasurementLocation() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.health.connect.datatypes.units.Pressure getSystolic() { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.health.connect.datatypes.AggregationType<android.health.connect.datatypes.units.Pressure> DIASTOLIC_AVG;
static { DIASTOLIC_AVG = null; }

@android.annotation.NonNull public static final android.health.connect.datatypes.AggregationType<android.health.connect.datatypes.units.Pressure> DIASTOLIC_MAX;
static { DIASTOLIC_MAX = null; }

@android.annotation.NonNull public static final android.health.connect.datatypes.AggregationType<android.health.connect.datatypes.units.Pressure> DIASTOLIC_MIN;
static { DIASTOLIC_MIN = null; }

@android.annotation.NonNull public static final android.health.connect.datatypes.AggregationType<android.health.connect.datatypes.units.Pressure> SYSTOLIC_AVG;
static { SYSTOLIC_AVG = null; }

@android.annotation.NonNull public static final android.health.connect.datatypes.AggregationType<android.health.connect.datatypes.units.Pressure> SYSTOLIC_MAX;
static { SYSTOLIC_MAX = null; }

@android.annotation.NonNull public static final android.health.connect.datatypes.AggregationType<android.health.connect.datatypes.units.Pressure> SYSTOLIC_MIN;
static { SYSTOLIC_MIN = null; }
@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class BloodPressureMeasurementLocation {

BloodPressureMeasurementLocation() { throw new RuntimeException("Stub!"); }

public static final int BLOOD_PRESSURE_MEASUREMENT_LOCATION_LEFT_UPPER_ARM = 3; // 0x3

public static final int BLOOD_PRESSURE_MEASUREMENT_LOCATION_LEFT_WRIST = 1; // 0x1

public static final int BLOOD_PRESSURE_MEASUREMENT_LOCATION_RIGHT_UPPER_ARM = 4; // 0x4

public static final int BLOOD_PRESSURE_MEASUREMENT_LOCATION_RIGHT_WRIST = 2; // 0x2

public static final int BLOOD_PRESSURE_MEASUREMENT_LOCATION_UNKNOWN = 0; // 0x0
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class BodyPosition {

BodyPosition() { throw new RuntimeException("Stub!"); }

public static final int BODY_POSITION_LYING_DOWN = 3; // 0x3

public static final int BODY_POSITION_RECLINING = 4; // 0x4

public static final int BODY_POSITION_SITTING_DOWN = 2; // 0x2

public static final int BODY_POSITION_STANDING_UP = 1; // 0x1

public static final int BODY_POSITION_UNKNOWN = 0; // 0x0
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

public Builder(@android.annotation.NonNull android.health.connect.datatypes.Metadata metadata, @android.annotation.NonNull java.time.Instant time, int measurementLocation, @android.annotation.NonNull android.health.connect.datatypes.units.Pressure systolic, @android.annotation.NonNull android.health.connect.datatypes.units.Pressure diastolic, int bodyPosition) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.health.connect.datatypes.BloodPressureRecord build() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.health.connect.datatypes.BloodPressureRecord.Builder clearZoneOffset() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.health.connect.datatypes.BloodPressureRecord.Builder setZoneOffset(@android.annotation.NonNull java.time.ZoneOffset zoneOffset) { throw new RuntimeException("Stub!"); }
}

}

