/*
 * Copyright (C) 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.health.connect;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public class HealthConnectManager {

HealthConnectManager() { throw new RuntimeException("Stub!"); }

public void insertRecords(@android.annotation.NonNull java.util.List<android.health.connect.datatypes.Record> records, @android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.os.OutcomeReceiver<android.health.connect.InsertRecordsResponse,android.health.connect.HealthConnectException> callback) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public <T> void aggregate(@android.annotation.NonNull android.health.connect.AggregateRecordsRequest<T> request, @android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.os.OutcomeReceiver<android.health.connect.AggregateRecordsResponse<T>,android.health.connect.HealthConnectException> callback) { throw new RuntimeException("Stub!"); }

public <T> void aggregateGroupByDuration(@android.annotation.NonNull android.health.connect.AggregateRecordsRequest<T> request, @android.annotation.NonNull java.time.Duration duration, @android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.os.OutcomeReceiver<java.util.List<android.health.connect.AggregateRecordsGroupedByDurationResponse<T>>,android.health.connect.HealthConnectException> callback) { throw new RuntimeException("Stub!"); }

public <T> void aggregateGroupByPeriod(@android.annotation.NonNull android.health.connect.AggregateRecordsRequest<T> request, @android.annotation.NonNull java.time.Period period, @android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.os.OutcomeReceiver<java.util.List<android.health.connect.AggregateRecordsGroupedByPeriodResponse<T>>,android.health.connect.HealthConnectException> callback) { throw new RuntimeException("Stub!"); }

public void deleteRecords(@android.annotation.NonNull android.health.connect.DeleteUsingFiltersRequest request, @android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.os.OutcomeReceiver<java.lang.Void,android.health.connect.HealthConnectException> callback) { throw new RuntimeException("Stub!"); }

public void deleteRecords(@android.annotation.NonNull java.util.List<android.health.connect.RecordIdFilter> recordIds, @android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.os.OutcomeReceiver<java.lang.Void,android.health.connect.HealthConnectException> callback) { throw new RuntimeException("Stub!"); }

public void deleteRecords(@android.annotation.NonNull java.lang.Class<? extends android.health.connect.datatypes.Record> recordType, @android.annotation.NonNull android.health.connect.TimeRangeFilter timeRangeFilter, @android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.os.OutcomeReceiver<java.lang.Void,android.health.connect.HealthConnectException> callback) { throw new RuntimeException("Stub!"); }

public void getChangeLogs(@android.annotation.NonNull android.health.connect.changelog.ChangeLogsRequest changeLogsRequest, @android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.os.OutcomeReceiver<android.health.connect.changelog.ChangeLogsResponse,android.health.connect.HealthConnectException> callback) { throw new RuntimeException("Stub!"); }

public void getChangeLogToken(@android.annotation.NonNull android.health.connect.changelog.ChangeLogTokenRequest request, @android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.os.OutcomeReceiver<android.health.connect.changelog.ChangeLogTokenResponse,android.health.connect.HealthConnectException> callback) { throw new RuntimeException("Stub!"); }

public void fetchDataOriginsPriorityOrder(int dataCategory, @android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.os.OutcomeReceiver<android.health.connect.FetchDataOriginsPriorityOrderResponse,android.health.connect.HealthConnectException> callback) { throw new RuntimeException("Stub!"); }

public void updateDataOriginPriorityOrder(@android.annotation.NonNull android.health.connect.UpdateDataOriginPriorityOrderRequest request, @android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.os.OutcomeReceiver<java.lang.Void,android.health.connect.HealthConnectException> callback) { throw new RuntimeException("Stub!"); }

public void queryAllRecordTypesInfo(@android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.os.OutcomeReceiver<java.util.Map<java.lang.Class<? extends android.health.connect.datatypes.Record>,android.health.connect.RecordTypeInfoResponse>,android.health.connect.HealthConnectException> callback) { throw new RuntimeException("Stub!"); }

public int getRecordRetentionPeriodInDays() { throw new RuntimeException("Stub!"); }

public void setRecordRetentionPeriodInDays(int days, @android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.os.OutcomeReceiver<java.lang.Void,android.health.connect.HealthConnectException> callback) { throw new RuntimeException("Stub!"); }

public void queryAccessLogs(@android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.os.OutcomeReceiver<java.util.List<android.health.connect.accesslog.AccessLog>,android.health.connect.HealthConnectException> callback) { throw new RuntimeException("Stub!"); }

public <T extends android.health.connect.datatypes.Record> void readRecords(@android.annotation.NonNull android.health.connect.ReadRecordsRequest<T> request, @android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.os.OutcomeReceiver<android.health.connect.ReadRecordsResponse<T>,android.health.connect.HealthConnectException> callback) { throw new RuntimeException("Stub!"); }

public void updateRecords(@android.annotation.NonNull java.util.List<android.health.connect.datatypes.Record> records, @android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.os.OutcomeReceiver<java.lang.Void,android.health.connect.HealthConnectException> callback) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public void getContributorApplicationsInfo(@android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.os.OutcomeReceiver<android.health.connect.ApplicationInfoResponse,android.health.connect.HealthConnectException> callback) { throw new RuntimeException("Stub!"); }

public void stageAllHealthConnectRemoteData(@android.annotation.NonNull java.util.Map<java.lang.String,android.os.ParcelFileDescriptor> pfdsByFileName, @android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.os.OutcomeReceiver<java.lang.Void,android.health.connect.restore.StageRemoteDataException> callback) throws java.lang.NullPointerException { throw new RuntimeException("Stub!"); }

public void updateDataDownloadState(int downloadState) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public void getHealthConnectDataState(@android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.os.OutcomeReceiver<android.health.connect.HealthConnectDataState,android.health.connect.HealthConnectException> callback) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public void queryActivityDates(@android.annotation.NonNull java.util.List<java.lang.Class<? extends android.health.connect.datatypes.Record>> recordTypes, @android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.os.OutcomeReceiver<java.util.List<java.time.LocalDate>,android.health.connect.HealthConnectException> callback) { throw new RuntimeException("Stub!"); }

public void startMigration(@android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.os.OutcomeReceiver<java.lang.Void,android.health.connect.migration.MigrationException> callback) { throw new RuntimeException("Stub!"); }

public void finishMigration(@android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.os.OutcomeReceiver<java.lang.Void,android.health.connect.migration.MigrationException> callback) { throw new RuntimeException("Stub!"); }

public void writeMigrationData(@android.annotation.NonNull java.util.List<android.health.connect.migration.MigrationEntity> entities, @android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.os.OutcomeReceiver<java.lang.Void,android.health.connect.migration.MigrationException> callback) { throw new RuntimeException("Stub!"); }

public void insertMinDataMigrationSdkExtensionVersion(int requiredSdkExtension, @android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.os.OutcomeReceiver<java.lang.Void,android.health.connect.migration.MigrationException> callback) { throw new RuntimeException("Stub!"); }

public static boolean isHealthPermission(@android.annotation.NonNull android.content.Context context, @android.annotation.NonNull java.lang.String permission) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public static java.util.Set<java.lang.String> getHealthPermissions(@android.annotation.NonNull android.content.Context context) { throw new RuntimeException("Stub!"); }

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.BROADCAST_INTENT_ACTION) public static final java.lang.String ACTION_HEALTH_CONNECT_MIGRATION_READY = "android.health.connect.action.HEALTH_CONNECT_MIGRATION_READY";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.ACTIVITY_INTENT_ACTION) public static final java.lang.String ACTION_HEALTH_HOME_SETTINGS = "android.health.connect.action.HEALTH_HOME_SETTINGS";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.ACTIVITY_INTENT_ACTION) public static final java.lang.String ACTION_MANAGE_HEALTH_DATA = "android.health.connect.action.MANAGE_HEALTH_DATA";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.ACTIVITY_INTENT_ACTION) public static final java.lang.String ACTION_MANAGE_HEALTH_PERMISSIONS = "android.health.connect.action.MANAGE_HEALTH_PERMISSIONS";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.ACTIVITY_INTENT_ACTION) public static final java.lang.String ACTION_REQUEST_EXERCISE_ROUTE = "android.health.connect.action.REQUEST_EXERCISE_ROUTE";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.ACTIVITY_INTENT_ACTION) public static final java.lang.String ACTION_REQUEST_HEALTH_PERMISSIONS = "android.health.connect.action.REQUEST_HEALTH_PERMISSIONS";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.ACTIVITY_INTENT_ACTION) public static final java.lang.String ACTION_SHOW_MIGRATION_INFO = "android.health.connect.action.SHOW_MIGRATION_INFO";

@android.annotation.SdkConstant(android.annotation.SdkConstant.SdkConstantType.INTENT_CATEGORY) public static final java.lang.String CATEGORY_HEALTH_PERMISSIONS = "android.intent.category.HEALTH_PERMISSIONS";

public static final int DATA_DOWNLOAD_COMPLETE = 4; // 0x4

public static final int DATA_DOWNLOAD_FAILED = 3; // 0x3

public static final int DATA_DOWNLOAD_RETRY = 2; // 0x2

public static final int DATA_DOWNLOAD_STARTED = 1; // 0x1

public static final int DATA_DOWNLOAD_STATE_UNKNOWN = 0; // 0x0

public static final java.lang.String EXTRA_EXERCISE_ROUTE = "android.health.connect.extra.EXERCISE_ROUTE";

public static final java.lang.String EXTRA_SESSION_ID = "android.health.connect.extra.SESSION_ID";
}

