/*
 * Copyright (C) 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.health.connect.datatypes;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class ExerciseSegmentType {

ExerciseSegmentType() { throw new RuntimeException("Stub!"); }

public static final int EXERCISE_SEGMENT_TYPE_ARM_CURL = 26; // 0x1a

public static final int EXERCISE_SEGMENT_TYPE_BACK_EXTENSION = 27; // 0x1b

public static final int EXERCISE_SEGMENT_TYPE_BALL_SLAM = 28; // 0x1c

public static final int EXERCISE_SEGMENT_TYPE_BARBELL_SHOULDER_PRESS = 1; // 0x1

public static final int EXERCISE_SEGMENT_TYPE_BENCH_PRESS = 29; // 0x1d

public static final int EXERCISE_SEGMENT_TYPE_BENCH_SIT_UP = 2; // 0x2

public static final int EXERCISE_SEGMENT_TYPE_BIKING = 3; // 0x3

public static final int EXERCISE_SEGMENT_TYPE_BIKING_STATIONARY = 4; // 0x4

public static final int EXERCISE_SEGMENT_TYPE_BURPEE = 30; // 0x1e

public static final int EXERCISE_SEGMENT_TYPE_CRUNCH = 31; // 0x1f

public static final int EXERCISE_SEGMENT_TYPE_DEADLIFT = 32; // 0x20

public static final int EXERCISE_SEGMENT_TYPE_DOUBLE_ARM_TRICEPS_EXTENSION = 33; // 0x21

public static final int EXERCISE_SEGMENT_TYPE_DUMBBELL_CURL_LEFT_ARM = 5; // 0x5

public static final int EXERCISE_SEGMENT_TYPE_DUMBBELL_CURL_RIGHT_ARM = 6; // 0x6

public static final int EXERCISE_SEGMENT_TYPE_DUMBBELL_FRONT_RAISE = 7; // 0x7

public static final int EXERCISE_SEGMENT_TYPE_DUMBBELL_LATERAL_RAISE = 8; // 0x8

public static final int EXERCISE_SEGMENT_TYPE_DUMBBELL_ROW = 34; // 0x22

public static final int EXERCISE_SEGMENT_TYPE_DUMBBELL_TRICEPS_EXTENSION_LEFT_ARM = 9; // 0x9

public static final int EXERCISE_SEGMENT_TYPE_DUMBBELL_TRICEPS_EXTENSION_RIGHT_ARM = 10; // 0xa

public static final int EXERCISE_SEGMENT_TYPE_DUMBBELL_TRICEPS_EXTENSION_TWO_ARM = 11; // 0xb

public static final int EXERCISE_SEGMENT_TYPE_ELLIPTICAL = 12; // 0xc

public static final int EXERCISE_SEGMENT_TYPE_FORWARD_TWIST = 13; // 0xd

public static final int EXERCISE_SEGMENT_TYPE_FRONT_RAISE = 35; // 0x23

public static final int EXERCISE_SEGMENT_TYPE_HIGH_INTENSITY_INTERVAL_TRAINING = 62; // 0x3e

public static final int EXERCISE_SEGMENT_TYPE_HIP_THRUST = 36; // 0x24

public static final int EXERCISE_SEGMENT_TYPE_HULA_HOOP = 37; // 0x25

public static final int EXERCISE_SEGMENT_TYPE_JUMPING_JACK = 38; // 0x26

public static final int EXERCISE_SEGMENT_TYPE_JUMP_ROPE = 39; // 0x27

public static final int EXERCISE_SEGMENT_TYPE_KETTLEBELL_SWING = 40; // 0x28

public static final int EXERCISE_SEGMENT_TYPE_LATERAL_RAISE = 41; // 0x29

public static final int EXERCISE_SEGMENT_TYPE_LAT_PULL_DOWN = 42; // 0x2a

public static final int EXERCISE_SEGMENT_TYPE_LEG_CURL = 43; // 0x2b

public static final int EXERCISE_SEGMENT_TYPE_LEG_EXTENSION = 44; // 0x2c

public static final int EXERCISE_SEGMENT_TYPE_LEG_PRESS = 45; // 0x2d

public static final int EXERCISE_SEGMENT_TYPE_LEG_RAISE = 46; // 0x2e

public static final int EXERCISE_SEGMENT_TYPE_LUNGE = 47; // 0x2f

public static final int EXERCISE_SEGMENT_TYPE_MOUNTAIN_CLIMBER = 48; // 0x30

public static final int EXERCISE_SEGMENT_TYPE_OTHER_WORKOUT = 64; // 0x40

public static final int EXERCISE_SEGMENT_TYPE_PAUSE = 67; // 0x43

public static final int EXERCISE_SEGMENT_TYPE_PILATES = 14; // 0xe

public static final int EXERCISE_SEGMENT_TYPE_PLANK = 49; // 0x31

public static final int EXERCISE_SEGMENT_TYPE_PULL_UP = 50; // 0x32

public static final int EXERCISE_SEGMENT_TYPE_PUNCH = 51; // 0x33

public static final int EXERCISE_SEGMENT_TYPE_REST = 66; // 0x42

public static final int EXERCISE_SEGMENT_TYPE_ROWING_MACHINE = 15; // 0xf

public static final int EXERCISE_SEGMENT_TYPE_RUNNING = 16; // 0x10

public static final int EXERCISE_SEGMENT_TYPE_RUNNING_TREADMILL = 17; // 0x11

public static final int EXERCISE_SEGMENT_TYPE_SHOULDER_PRESS = 52; // 0x34

public static final int EXERCISE_SEGMENT_TYPE_SINGLE_ARM_TRICEPS_EXTENSION = 53; // 0x35

public static final int EXERCISE_SEGMENT_TYPE_SIT_UP = 54; // 0x36

public static final int EXERCISE_SEGMENT_TYPE_SQUAT = 55; // 0x37

public static final int EXERCISE_SEGMENT_TYPE_STAIR_CLIMBING = 18; // 0x12

public static final int EXERCISE_SEGMENT_TYPE_STAIR_CLIMBING_MACHINE = 19; // 0x13

public static final int EXERCISE_SEGMENT_TYPE_STRETCHING = 20; // 0x14

public static final int EXERCISE_SEGMENT_TYPE_SWIMMING_BACKSTROKE = 57; // 0x39

public static final int EXERCISE_SEGMENT_TYPE_SWIMMING_BREASTSTROKE = 58; // 0x3a

public static final int EXERCISE_SEGMENT_TYPE_SWIMMING_BUTTERFLY = 59; // 0x3b

public static final int EXERCISE_SEGMENT_TYPE_SWIMMING_FREESTYLE = 56; // 0x38

public static final int EXERCISE_SEGMENT_TYPE_SWIMMING_MIXED = 60; // 0x3c

public static final int EXERCISE_SEGMENT_TYPE_SWIMMING_OPEN_WATER = 21; // 0x15

public static final int EXERCISE_SEGMENT_TYPE_SWIMMING_OTHER = 61; // 0x3d

public static final int EXERCISE_SEGMENT_TYPE_SWIMMING_POOL = 22; // 0x16

public static final int EXERCISE_SEGMENT_TYPE_UNKNOWN = 0; // 0x0

public static final int EXERCISE_SEGMENT_TYPE_UPPER_TWIST = 23; // 0x17

public static final int EXERCISE_SEGMENT_TYPE_WALKING = 24; // 0x18

public static final int EXERCISE_SEGMENT_TYPE_WEIGHTLIFTING = 63; // 0x3f

public static final int EXERCISE_SEGMENT_TYPE_WHEELCHAIR = 25; // 0x19

public static final int EXERCISE_SEGMENT_TYPE_YOGA = 65; // 0x41
}

