/*
 * Copyright (C) 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.health.connect.datatypes;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class MedicalResource implements android.os.Parcelable {

MedicalResource() { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

public boolean equals(java.lang.Object o) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.lang.String getDataSourceId() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.health.connect.datatypes.FhirResource getFhirResource() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.health.connect.datatypes.FhirVersion getFhirVersion() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.health.connect.MedicalResourceId getId() { throw new RuntimeException("Stub!"); }

public int getType() { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }

public java.lang.String toString() { throw new RuntimeException("Stub!"); }

public void writeToParcel(@android.annotation.NonNull android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.health.connect.datatypes.MedicalResource> CREATOR;
static { CREATOR = null; }

public static final int MEDICAL_RESOURCE_TYPE_ALLERGIES_INTOLERANCES = 2; // 0x2

public static final int MEDICAL_RESOURCE_TYPE_CONDITIONS = 7; // 0x7

public static final int MEDICAL_RESOURCE_TYPE_LABORATORY_RESULTS = 6; // 0x6

public static final int MEDICAL_RESOURCE_TYPE_MEDICATIONS = 9; // 0x9

public static final int MEDICAL_RESOURCE_TYPE_PERSONAL_DETAILS = 10; // 0xa

public static final int MEDICAL_RESOURCE_TYPE_PRACTITIONER_DETAILS = 11; // 0xb

public static final int MEDICAL_RESOURCE_TYPE_PREGNANCY = 3; // 0x3

public static final int MEDICAL_RESOURCE_TYPE_PROCEDURES = 8; // 0x8

public static final int MEDICAL_RESOURCE_TYPE_SOCIAL_HISTORY = 4; // 0x4

public static final int MEDICAL_RESOURCE_TYPE_VACCINES = 1; // 0x1

public static final int MEDICAL_RESOURCE_TYPE_VISITS = 12; // 0xc

public static final int MEDICAL_RESOURCE_TYPE_VITAL_SIGNS = 5; // 0x5
@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class Builder {

public Builder(@android.annotation.NonNull android.health.connect.datatypes.MedicalResource other) { throw new RuntimeException("Stub!"); }

public Builder(@android.annotation.NonNull android.health.connect.datatypes.MedicalResource.Builder other) { throw new RuntimeException("Stub!"); }

public Builder(int type, @android.annotation.NonNull java.lang.String dataSourceId, @android.annotation.NonNull android.health.connect.datatypes.FhirVersion fhirVersion, @android.annotation.NonNull android.health.connect.datatypes.FhirResource fhirResource) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.health.connect.datatypes.MedicalResource build() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.health.connect.datatypes.MedicalResource.Builder setDataSourceId(@android.annotation.NonNull java.lang.String dataSourceId) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.health.connect.datatypes.MedicalResource.Builder setFhirResource(@android.annotation.NonNull android.health.connect.datatypes.FhirResource fhirResource) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.health.connect.datatypes.MedicalResource.Builder setFhirVersion(@android.annotation.NonNull android.health.connect.datatypes.FhirVersion fhirVersion) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.health.connect.datatypes.MedicalResource.Builder setType(int type) { throw new RuntimeException("Stub!"); }
}

}

