/*
 * Copyright (C) 2019 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.net.ipsec.ike;


/**
 * IkeRfc822AddrIdentification represents an IKE entity identification based on a fully-qualified
 * RFC 822 email address ID (e.g. ike@android.com).
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class IkeRfc822AddrIdentification extends android.net.ipsec.ike.IkeIdentification {

/**
 * Construct an instance of {@link android.net.ipsec.ike.IkeRfc822AddrIdentification IkeRfc822AddrIdentification} with a fully-qualified RFC 822
 * email address.
 *
 * @param rfc822Name the fully-qualified RFC 822 email address.
 */

public IkeRfc822AddrIdentification(@android.annotation.NonNull java.lang.String rfc822Name) { throw new RuntimeException("Stub!"); }

/** @hide */

public int hashCode() { throw new RuntimeException("Stub!"); }

/** @hide */

public boolean equals(java.lang.Object o) { throw new RuntimeException("Stub!"); }

/** The fully-qualified RFC 822 email address. */

@android.annotation.NonNull public final java.lang.String rfc822Name;
{ rfc822Name = null; }
}

