/*
 * Copyright (C) 2019 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package android.net.ipsec.ike.exceptions;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public abstract class IkeProtocolException extends android.net.ipsec.ike.exceptions.IkeException {

IkeProtocolException() { throw new RuntimeException("Stub!"); }

public int getErrorType() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public byte[] getErrorData() { throw new RuntimeException("Stub!"); }

public static final int ERROR_TYPE_AUTHENTICATION_FAILED = 24; // 0x18

public static final int ERROR_TYPE_CHILD_SA_NOT_FOUND = 44; // 0x2c

public static final int ERROR_TYPE_FAILED_CP_REQUIRED = 37; // 0x25

public static final int ERROR_TYPE_INTERNAL_ADDRESS_FAILURE = 36; // 0x24

public static final int ERROR_TYPE_INVALID_IKE_SPI = 4; // 0x4

public static final int ERROR_TYPE_INVALID_KE_PAYLOAD = 17; // 0x11

public static final int ERROR_TYPE_INVALID_MAJOR_VERSION = 5; // 0x5

public static final int ERROR_TYPE_INVALID_MESSAGE_ID = 9; // 0x9

public static final int ERROR_TYPE_INVALID_SELECTORS = 39; // 0x27

public static final int ERROR_TYPE_INVALID_SYNTAX = 7; // 0x7

public static final int ERROR_TYPE_NO_ADDITIONAL_SAS = 35; // 0x23

public static final int ERROR_TYPE_NO_PROPOSAL_CHOSEN = 14; // 0xe

public static final int ERROR_TYPE_SINGLE_PAIR_REQUIRED = 34; // 0x22

public static final int ERROR_TYPE_TEMPORARY_FAILURE = 43; // 0x2b

public static final int ERROR_TYPE_TS_UNACCEPTABLE = 38; // 0x26

public static final int ERROR_TYPE_UNSUPPORTED_CRITICAL_PAYLOAD = 1; // 0x1
}

